% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_resources.R
\name{fhir_recent_http_error}
\alias{fhir_recent_http_error}
\title{Return most recent http error from \code{\link[=fhir_search]{fhir_search()}}}
\usage{
fhir_recent_http_error()
}
\value{
A string containing the error message
}
\description{
Whenever a call to \code{\link[=fhir_search]{fhir_search()}} produces any http error, the error information is saved internally
until the next http error occurs (or the R session ends). The error information can be accessed with \code{fhir_recent_http_error}.
If you want to log that information outside of your R session, set the argument \code{log_errors} of \code{\link[=fhir_search]{fhir_search()}} .
}
\examples{
\dontrun{
fhir_search("https://server.fire.ly/Medicatio", max_bundles = 1)
cat(fhir_recent_http_error())
}

}
\seealso{
\code{\link[=fhir_search]{fhir_search()}}
}
