% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_resources.R
\docType{methods}
\name{fhir_unserialize}
\alias{fhir_unserialize}
\alias{fhir_unserialize,fhir_bundle_xml-method}
\alias{fhir_unserialize,fhir_bundle_serialized-method}
\alias{fhir_unserialize,fhir_resource_xml-method}
\alias{fhir_unserialize,fhir_resource_serialized-method}
\alias{fhir_unserialize,fhir_bundle_list-method}
\title{Unserialize a \linkS4class{fhir_bundle}, \linkS4class{fhir_bundle_list} or \linkS4class{fhir_resource}}
\usage{
fhir_unserialize(bundles)

\S4method{fhir_unserialize}{fhir_bundle_xml}(bundles)

\S4method{fhir_unserialize}{fhir_bundle_serialized}(bundles)

\S4method{fhir_unserialize}{fhir_resource_xml}(bundles)

\S4method{fhir_unserialize}{fhir_resource_serialized}(bundles)

\S4method{fhir_unserialize}{fhir_bundle_list}(bundles)
}
\arguments{
\item{bundles}{A \linkS4class{fhir_bundle}, \linkS4class{fhir_bundle_list} or \linkS4class{fhir_resource} object.}
}
\value{
A  \linkS4class{fhir_bundle_serialized}, \linkS4class{fhir_bundle_list} or \linkS4class{fhir_resource_serialized}object.
}
\description{
Unserializes FHIR resources or bundles that have been serialized to allow for saving in .rda or .RData format,
i.e. it turns a \linkS4class{fhir_bundle_serialized}/\linkS4class{fhir_resource_serialized} object into an \linkS4class{fhir_bundle_xml}/\linkS4class{fhir_resource_xml} object.
}
\examples{

#unserialize bundle list
fhir_unserialize(patient_bundles)

#unserialize single bundle
fhir_unserialize(patient_bundles[[1]])

}
