% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_resources.R
\name{fhir_authenticate}
\alias{fhir_authenticate}
\title{Create token for Authentication}
\usage{
fhir_authenticate(
  secret,
  key,
  base_url,
  access,
  authorize,
  query_authorize_extra = list()
)
}
\arguments{
\item{secret}{The consumer/client secret, belonging to \code{key}.}

\item{key}{Consumer key, also called client ID.
For Keycloak this would for instance be the Keycloak client, e.g. "postman".}

\item{base_url}{The URL the user will be redirected to after authorization is complete.
This will usually be the base url of you FHIR server.}

\item{access}{The url used to exchange unauthenticated for authenticated token.
This can be identical to \code{authorize}.}

\item{authorize}{The url to send the client for authorization.}

\item{query_authorize_extra}{A named list holding query parameters to append to initial auth page query.
Could hold info about user identity and scope for keycloak like this:\preformatted{list(scope = "openid",
     grant_type = "password",
     username = "fhir-user",
     password = "fhirtest")
}}
}
\description{
This function is a wrapper to create an \link[httr:Token-class]{httr::Token} object for authentication with OAuth2/OpenID Connect.
Internally, it calls \code{\link[httr:oauth_app]{httr::oauth_app()}}, \code{\link[httr:oauth_endpoint]{httr::oauth_endpoint()}} and \code{\link[httr:oauth2.0_token]{httr::oauth2.0_token()}} to create a token that can
then be used in \link{fhir_search}.
}
