% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{fhir_save_design}
\alias{fhir_save_design}
\title{Write design to xml}
\usage{
fhir_save_design(design, file = "design.xml")
}
\arguments{
\item{design}{A list representing a valid design as used in \code{\link{fhir_crack}}}

\item{file}{A string specifying the file to write to, defaults to writing "design.xml"
into the current working directory}
}
\description{
Writes a design for use with \code{\link{fhir_crack}} to an xml file
}
\examples{
design <- list(
   Pat = list(
      resource = "//Patient",
      cols = "./*"
   )

)

fhir_save_design(design, file = tempfile())
}
