% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fhircrack.R
\name{fhir_capability_statement}
\alias{fhir_capability_statement}
\title{Get capability statement}
\usage{
fhir_capability_statement(
  url = "https://hapi.fhir.org/baseR4",
  sep = " ",
  remove_empty_columns = TRUE,
  add_indices = TRUE,
  brackets = c("<", ">"),
  verbose = 2
)
}
\arguments{
\item{url}{The URL of the FHIR server endpoint.}

\item{sep}{A string to separate pasted multiple entries}

\item{remove_empty_columns}{Logical scalar. Remove empty columns?}

\item{add_indices}{A logical scalar.}

\item{brackets}{A vector of strings defining the Brackets surrounding the indices. e.g. c( "<", ">")}

\item{verbose}{An integer Scalar.  If 0, nothings is printed, if 1, only finishing message is printed, if > 1,
downloading/extraction progress will be printed. Defaults to 2.}
}
\value{
A list of data frames containing the information from the statement
}
\description{
Get the capability statement of a FHIR server.
}
\examples{
\donttest{cap <- fhir_capability_statement("https://hapi.fhir.org/baseR4")}

}
