% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_status_tree.R
\name{add_status_tree}
\alias{add_status_tree}
\title{Add column \code{status_tree} based on the status of all stems of each tree.}
\usage{
add_status_tree(data, status_a = "A", status_d = "D")
}
\arguments{
\item{data}{A ForestGEO-like dataframe: A \emph{ViewFullTable}, \emph{tree} or \emph{stem}
table.}

\item{status_a, status_d}{Sting to match alive and dead stems; it corresponds
to the values of the variable \code{status} (in census tables) or \code{Status} (with
capital "S" in ViewFull tables).}
}
\value{
The input data set with the additional variable \code{status_tree}.
}
\description{
Add column \code{status_tree} based on the status of all stems of each tree.
}
\examples{
# styler: off
stem <- tribble(
  ~CensusID, ~treeID, ~stemID, ~status,
          1,       1,       1,     "A",
          1,       1,       2,     "D",

          1,       2,       3,     "D",
          1,       2,       4,     "D",



          2,       1,       1,     "A",
          2,       1,       2,     "G",

          2,       2,       3,     "D",
          2,       2,       4,     "G"
)
# styler: on

add_status_tree(stem)

}
\seealso{
Other functions to add columns to dataframes: 
\code{\link{add_subquad}()},
\code{\link{add_var}()}

Other functions for ForestGEO data: 
\code{\link{add_subquad}()},
\code{\link{add_var}()}

Other functions for fgeo census: 
\code{\link{add_var}()},
\code{\link{guess_plotdim}()},
\code{\link{pick_drop}}

Other functions for fgeo vft: 
\code{\link{add_subquad}()},
\code{\link{add_var}()},
\code{\link{guess_plotdim}()},
\code{\link{pick_drop}}
}
\concept{functions for ForestGEO data}
\concept{functions for fgeo census}
\concept{functions for fgeo vft}
\concept{functions to add columns to dataframes}
