% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_matches.R
\name{extract_insensitive}
\alias{extract_insensitive}
\alias{detect_insensitive}
\title{Detect and extract matching strings -- ignoring case.}
\usage{
extract_insensitive(x, y)

detect_insensitive(x, y)
}
\arguments{
\item{x}{A string to be muted as in \code{y}, it a case insensitive match is
found.}

\item{y}{A string to use as a reference to match \code{x}.}
}
\value{
\code{detect_*} and \code{extract_*} return a logical vector and a string.
}
\description{
Detect and extract matching strings -- ignoring case.

Return TRUE in position where name of x is in y; FALSE otherwise.
}
\examples{
x <- c("stemid", "n")
y <- c("StemID", "treeID")
detect_insensitive(x, y)
extract_insensitive(x, y)

vft <- data.frame(TreeID = 1, Status = 1)
extract_insensitive(tolower(names(vft)), names(vft))
extract_insensitive(names(vft), tolower(names(vft)))
}
\seealso{
Other functions for developers: \code{\link{check_crucial_names}},
  \code{\link{flag_if_group}}, \code{\link{is_multiple}},
  \code{\link{nms_try_rename}},
  \code{\link{rename_matches}}, \code{\link{type_ensure}}

Other general functions to deal with names: \code{\link{rename_matches}}
}
\concept{functions for developers}
\concept{general functions to deal with names}
\keyword{internal}
