% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_crucial_names.R
\name{check_crucial_names}
\alias{check_crucial_names}
\title{Check if an object contains specific names.}
\usage{
check_crucial_names(x, nms)
}
\arguments{
\item{x}{A named object.}

\item{nms}{String; names expected to be found in \code{x}.}
}
\value{
Invisible \code{x}, or an error with informative message.
}
\description{
Check if an object contains specific names.
}
\examples{
v <- c(x = 1)
check_crucial_names(v, "x")

dfm <- data.frame(x = 1)
check_crucial_names(dfm, "x")
}
\seealso{
Other functions to check inputs: \code{\link{flag_if_group}},
  \code{\link{is_multiple}}

Other functions for developers: \code{\link{extract_insensitive}},
  \code{\link{flag_if_group}}, \code{\link{is_multiple}},
  \code{\link{nms_try_rename}},
  \code{\link{rename_matches}}, \code{\link{type_ensure}}
}
\concept{exported functions for internal use}
\concept{functions for developers}
\concept{functions to check inputs}
\concept{general functions to assert}
\keyword{internal}
