% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_outcomes_week.R
\name{ffs_adp_outcomes_week}
\alias{ffs_adp_outcomes_week}
\title{Connects ff_scoringhistory to past ADP rankings}
\usage{
ffs_adp_outcomes_week(scoring_history, pos_filter = c("QB", "RB", "WR", "TE"))
}
\arguments{
\item{scoring_history}{a scoring history table as created by \code{ffscrapr::ff_scoringhistory()}}

\item{pos_filter}{a character vector: filter the positions returned to these specific positions, default: c("QB","RB","WR","TE)}
}
\value{
a dataframe with position, rank, probability of games played, and a corresponding nested list per row of all week score outcomes.
}
\description{
The backbone of the ffsimulator resampling process is coming up with a population of weekly outcomes for every inseason weekly rank. This function creates that dataframe by connecting historical FantasyPros.com rankings to nflfastR-based scoring data, as created by \code{ffscrapr::ff_scoringhistory()}.
}
\examples{
\donttest{
# cached data
scoring_history <- .ffs_cache("mfl_scoring_history.rds")
ffs_adp_outcomes_week(scoring_history, pos_filter = c("QB","RB","WR","TE"))
}

}
\seealso{
\code{fp_rankings_history_week} for the included historical rankings
}
