% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_generics.R, R/espn_draftpicks.R,
%   R/flea_draftpicks.R, R/mfl_draftpicks.R, R/sleeper_draftpicks.R
\name{ff_draftpicks}
\alias{ff_draftpicks}
\alias{ff_draftpicks.espn_conn}
\alias{ff_draftpicks.flea_conn}
\alias{ff_draftpicks.mfl_conn}
\alias{ff_draftpicks.sleeper_conn}
\title{Get Draft Picks}
\usage{
ff_draftpicks(conn, ...)

\method{ff_draftpicks}{espn_conn}(conn, ...)

\method{ff_draftpicks}{flea_conn}(conn, franchise_id = NULL, ...)

\method{ff_draftpicks}{mfl_conn}(conn, ...)

\method{ff_draftpicks}{sleeper_conn}(conn, ...)
}
\arguments{
\item{conn}{the list object created by \code{ff_connect()}}

\item{...}{other arguments (currently unused)}

\item{franchise_id}{A list of franchise IDs to pull, if NULL will return all franchise IDs}
}
\value{
Returns a dataframe with current and future draft picks for each franchise
}
\description{
Returns all draft picks (current and future) that belong to a specific franchise and have not yet been converted into players (i.e. selected.)
}
\section{Methods (by class)}{
\itemize{
\item \code{espn_conn}: ESPN: does not support future/draft pick trades - for draft results, please use ff_draft.

\item \code{flea_conn}: Fleaflicker: retrieves current and future draft picks, potentially for a specified team.

\item \code{mfl_conn}: MFL: returns current and future picks

\item \code{sleeper_conn}: Sleeper: retrieves current and future draft picks
}}

\examples{
\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
  conn <- espn_connect(
    season = 2018,
    league_id = 1178049,
    espn_s2 = Sys.getenv("TAN_ESPN_S2"),
    swid = Sys.getenv("TAN_SWID")
  )

  ff_draftpicks(conn)
}) # end try
}

\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
  conn <- fleaflicker_connect(2020, 206154)
  ff_draftpicks(conn, franchise_id = 1373475)
}) # end try
}

\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
  dlf_conn <- mfl_connect(2020, league_id = 37920)
  ff_draftpicks(conn = dlf_conn)
}) # end try
}

\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
  jml_conn <- ff_connect(platform = "sleeper", league_id = "522458773317046272", season = 2020)
  ff_draftpicks(jml_conn)
}) # end try
}

}
