% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/views.R
\name{view_on_copula}
\alias{view_on_copula}
\alias{view_on_copula.default}
\alias{view_on_copula.matrix}
\alias{view_on_copula.xts}
\alias{view_on_copula.tbl_df}
\title{Views on Copulas}
\usage{
view_on_copula(x, simul, p)

\method{view_on_copula}{default}(x, simul, p)

\method{view_on_copula}{matrix}(x, simul, p)

\method{view_on_copula}{xts}(x, simul, p)

\method{view_on_copula}{tbl_df}(x, simul, p)
}
\arguments{
\item{x}{A multivariate copula.}

\item{simul}{A simulated target copula.}

\item{p}{An object of the \code{ffp} class.}
}
\value{
A \code{list} of the \code{view} class.
}
\description{
Helper to construct constraints on copulas for entropy programming.
}
\examples{
\donttest{
  set.seed(1)
  library(ggplot2)

  # Invariants
  ret <- diff(log(EuStockMarkets))
  u <- apply(ret, 2, stats::pnorm) # assuming normal copula
  n <- nrow(u)

  #' Prior probability distribution
  prior <- rep(1 / n, n)

  # Simulated marginals
  simul_marg <- bootstrap_scenarios(ret, as_ffp(prior), as.double(n))

  # Copulas derived from the simulated margins
  simul_cop <- apply(simul_marg, 2, stats::pnorm) # assuming normal copula

  views <- view_on_copula(x = u, simul = simul_cop, p = prior)
  views

  ep <- entropy_pooling(p = prior, Aeq = views$Aeq, beq = views$beq, solver = "nloptr")
  autoplot(ep)
}
}
