## ---- include = FALSE----------------------------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
if (!interactive()) {
  options(width = 99)
}

## ----setup---------------------------------------------------------------------------------------
library(fflr)
packageVersion("fflr")

## ----espn_games----------------------------------------------------------------------------------
espn_games()

## ----ffl_seasons---------------------------------------------------------------------------------
ffl_seasons()

## ----ffl_info------------------------------------------------------------------------------------
str(ffl_info())

## ----ffl_now-------------------------------------------------------------------------------------
ffl_year()
ffl_week()

## ----ffl_past------------------------------------------------------------------------------------
ffl_year(offset = -2)
ffl_week(offset =  1)

## ----options-------------------------------------------------------------------------------------
options(lid = 252353)

## ----league_info---------------------------------------------------------------------------------
str(league_info())

## ----league_members------------------------------------------------------------------------------
league_members()

## ----league_teams--------------------------------------------------------------------------------
(teams = league_teams())

## ----team_abbrev---------------------------------------------------------------------------------
team_abbrev(id = 6, teams)

## ----roster_settings-----------------------------------------------------------------------------
roster_settings()
score_settings()

## ----all_players---------------------------------------------------------------------------------
all_players()

## ----player_info---------------------------------------------------------------------------------
player_info(id = 3054850, row = TRUE)

## ----nfl_players---------------------------------------------------------------------------------
nfl_players

## ----player_news---------------------------------------------------------------------------------
player_news(id = 15847)

## ----player_outlook, results='asis'--------------------------------------------------------------
outlooks <- player_outlook()
nrow(outlooks)
cat(paste(">", outlooks$outlook[1]))

## ----team_roster---------------------------------------------------------------------------------
rosters <- team_roster()

## ----my_roster-----------------------------------------------------------------------------------
rosters$KIER

## ----start_roster--------------------------------------------------------------------------------
start_roster(rosters$KIER)

## ----best_roster---------------------------------------------------------------------------------
(best <- best_roster(rosters$KIER))
roster_score(best)

## ----pro_schedule--------------------------------------------------------------------------------
(sched <- ffl_merge(
  x = rosters$KIER[, 1:9], 
  y = pro_schedule()
))

## ----opponent_ranks------------------------------------------------------------------------------
ffl_merge(
  x = sched[, 6:10], 
  y = opponent_ranks(), 
  by = c("pos", "opp" = "pro")
)

## ----player_acquire------------------------------------------------------------------------------
player_acquire()[[5]]

## ----roster_moves--------------------------------------------------------------------------------
ffl_merge(
  x = roster_moves()[, 7:14], 
  y = nfl_players[, 1:3]
)

## ----draft_picks---------------------------------------------------------------------------------
ffl_merge(
  x = draft_picks(), 
  y = nfl_players[, 1:3]
)

## ----moves_summary-------------------------------------------------------------------------------
moves_summary()

## ----match_scores--------------------------------------------------------------------------------
match_scores()

## ----match_schedule------------------------------------------------------------------------------
match_schedule()

## ----live_scoring--------------------------------------------------------------------------------
live_scoring()

## ----schedule_settings---------------------------------------------------------------------------
schedule_settings()

## ----week_scores---------------------------------------------------------------------------------
week_scores()

## ----score_summary-------------------------------------------------------------------------------
score_summary()

## ----past_scores---------------------------------------------------------------------------------
past <- week_scores(old = TRUE)
names(past) <- 2015:2019
str(past, max.level = 1)

## ----past_info-----------------------------------------------------------------------------------
str(league_info())
league_info(old = TRUE)

