% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_data.R
\name{check_format}
\alias{check_format}
\title{Checks the fishing trip input data}
\usage{
check_format(x, correct = FALSE)
}
\arguments{
\item{x}{The input data.frame.}

\item{correct}{Should automatic corrections to the data be attempted.}
}
\value{
The input data.frame, with or without attempted corrections.
}
\description{
Checks the fishing trip data input data that is then used by the
\code{\link{calc_fishing_effort}} function.
The fishing trip data is stored in a \code{data.frame} which describes the
trip details (departure and return date and time) and the fishing activities
that occurred on the trip (by date, gear and area). The format of the input
data is explained in the the Nicosia report Annex 4 and in the package
vignette \emph{checking_data}.
The associated function \code{\link{calc_fishing_effort}} uses the input data
to calculate the fishing effort of each trip. This function depends on the
input data being in the correct format.
The \code{\link{check_format}} function checks that the format and contents
of the data are correct.  When the function is called various messages are
reported to the screen describing if the contents are OK and if not, why not.
If the data is not correct then warnings are produced.
Users should repeatedly check their date with this function and modify it as
described until the check passes without warning. Only if the data passes the
checks without warning can it used by the \code{\link{calc_fishing_effort}}.
It is possible to ask the function to attempt to automatically correct simple
errors (wrong case, numerics instead of characters etc). If this option is
used the function outputs messages describing the changes being performed.
The corrected data is returned by the function. Note that calling the
function with automatic corrections does not guarantee that the returned data
is correct. The returned data should be passed again into
\code{\link{check_format}} to see if it now passes.
More information on how \code{\link{check_format}} should be used can be found in
the package vignette \emph{checking_data}.
}
\seealso{
See \code{\link{calc_fishing_effort}} for calculating effort.
See the package vignette \emph{checking_data} for more details on how to use
\code{\link{check_format}}.
}
