% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_effort.R
\name{calc_days_at_sea_trip}
\alias{calc_days_at_sea_trip}
\title{Calculate days at sea for a fishing trip.}
\usage{
calc_days_at_sea_trip(trip)
}
\arguments{
\item{trip}{Data.frame of the trip data}
}
\value{
A \code{data.frame} with the days at sea by gear, fishing area
and economic zone.
}
\description{
Calculate days at sea for a single fishing trip using data in the format
described in the package vignette \emph{checking_data}.
}
\details{
The input is a single fishing trip. The format of the data should be
checked by \code{\link{check_format}} before calling this function 
(see the package vignette \emph{checking_data} for more details).
Days at sea is reported at the gear (type and mesh size), fishing area and
economic zone level. The total number of days at sea is the number of
commenced 24 hour periods.
The total number of days at sea of a trip is split equally over dates on
which fishing occurs. The effort for each fishing date is split equally over
the fishing activity on that date.  Active and passive gears are treated
equally.
See the vignette \emph{calculating_fishing_effort} for more details.
This function is called by \code{\link{calc_fishing_effort}}.
}
\examples{
trip1 <- data.frame(
   eunr_id = "my_boat", loa = 2000, gt = 70, kw = 400,
   trip_id = "trip1",
   # 4 day trip
   depdate = "20140718", deptime = "0615", retdate = "20140721", rettime = "1615",
   # Only fish on 2 of those
   fishdate = c("20140719", "20140719", "20140719", "20140719", "20140720",
       "20140720", "20140720"), 
   gear = c("OTB","OTB","OTB","GN","OTB","GN","FPO"), gear_mesh_size = c(80,80,80,50,80,50,0),
   fishing_area = "27.4.B",
   economic_zone = "EU",
   rectangle = c("39F0","40F0","41F0","41F0","41F0","41F0","41F0"),
   stringsAsFactors = FALSE
)
das <- calc_days_at_sea_trip(trip1)
}
\seealso{
See \code{\link{calc_fishing_effort}}.
See the package vignette \emph{checking_data} for data preparation
and the vignette \emph{calculating_fishing_effort} for the calculation
details.
}
