% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfs.R
\name{dfs}
\alias{dfs}
\title{Deep Feature Synthesis}
\usage{
dfs(entityset, target_entity, agg_primitives = NULL,
  trans_primitives = NULL, max_depth = 2L, ...)
}
\arguments{
\item{entityset}{The entityset on which to perform dfs.}

\item{target_entity}{The name of the entity on which to perform dfs.}

\item{agg_primitives}{Primitives passed to relational data.}

\item{trans_primitives}{Primitives passed to non-relational data.}

\item{max_depth}{Controls the maximum depth of features.}

\item{...}{Additional parameters passed to `featuretools.dfs`.}
}
\value{
A `featuretools` feature matrix.
}
\description{
The main function from featuretools used to create new features.
}
\examples{
\donttest{
es <- as_entityset(cars, index = "row_number")
dfs(es, target_entity = "df1", trans_primitives = c("and"))
}
}
