% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.R
\name{plotcloud}
\alias{plotcloud}
\title{Plot word cloud}
\usage{
plotcloud(corpus, k = NULL, stopwords = "en", ...)
}
\arguments{
\item{corpus}{The corpus of documents (a vector of characters) or the vocabulary of the documents (result of function \code{getvocab}).}

\item{k}{A categorial variable (vector or factor).}

\item{stopwords}{Stopwords, or the language of the documents. NULL if stop words should not be removed.}

\item{...}{Other parameters.}
}
\description{
Plot a word cloud based on the word frequencies in the documents.
}
\examples{
\dontrun{
text = loadtext ("http://mattmahoney.net/dc/text8.zip")
plotcloud (text)
vocab = getvocab (text, mincount = 1, lang = NULL, stopwords = "en")
plotcloud (vocab)
}
}
\seealso{
\code{\link{plotzipf}}, \code{\link{getvocab}}, \code{\link[wordcloud]{wordcloud}}
}
