% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{bootstrap.curves}
\alias{bootstrap.curves}
\title{Plot evaluation curves with bootstrap sampling}
\usage{
bootstrap.curves(methods, x, y, nruns = 10, seed = NULL,
  curve = c("ROC", "Cost"), methodparameters = NULL, new = TRUE,
  lty = 1, names = NULL, ...)
}
\arguments{
\item{methods}{The classification or regression method to be evaluated.}

\item{x}{The dataset (description/predictors), a \code{matrix} or \code{data.frame}.}

\item{y}{The target (class labels or numeric values), a \code{factor} or \code{vector}.}

\item{nruns}{The number of bootstrap runs.}

\item{seed}{A specified seed for random number generation (useful for testing different method with the same bootstap samplings).}

\item{curve}{A character string indicating the type of curve to be plotted.}

\item{methodparameters}{Method parameters (if null tuning is done by cross-validation).}

\item{new}{A logical value indicating whether a new plot should be be created or not.}

\item{lty}{The line type (and color) specified as an integer.}

\item{names}{Method names.}

\item{...}{Other specific parameters for the leaning method.}
}
\description{
Evaluation a classification method according to ROC Curves or Cost Curves using bootstrap approach.
}
\examples{
require ("datasets")
data (iris)
d = iris
levels (d [, 5]) = c ("+", "+", "-") # Building a two classes dataset
# One method
bootstrap.curves (NB, d [, -5], d [, 5], seed = 0)
# Three methods
bootstrap.curves (c (NB, LDA, LR), d [, -5], d [, 5], seed = 0)
}
\seealso{
\code{\link{bootstrap}}, \code{\link[ROCR]{prediction}}, \code{\link[ROCR]{performance}}
}
