% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{SVMr}
\alias{SVMr}
\title{Classification using Support Vector Machine with a radial kernel}
\usage{
SVMr(train, labels, gamma = 2^(-3:3), cost = 2^(-3:3),
  methodparameters = NULL, tune = FALSE, ...)
}
\arguments{
\item{train}{The training set (description), as a \code{data.frame}.}

\item{labels}{Class labels of the training set (\code{vector} or \code{factor}).}

\item{gamma}{The gamma parameter (if a vector, cross-over validation is used to chose the best size).}

\item{cost}{The cost parameter (if a vector, cross-over validation is used to chose the best size).}

\item{methodparameters}{Object containing the parameters. If given, it replaces \code{gamma} and \code{cost}.}

\item{tune}{If true, the function returns paramters instead of a classification model.}

\item{...}{Other arguments.}
}
\value{
The classification model.
}
\description{
This function builds a classification model using Support Vector Machine with a radial kernel.
}
\examples{
require (datasets)
data (iris)
SVMr (iris [, -5], iris [, 5], gamma = 1, cost = 1)
}
\seealso{
\code{\link[e1071]{svm}}, \code{\link{SVM}}
}
