% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh.R
\name{projection.points.1.5D}
\alias{projection.points.1.5D}
\title{Project 2D points onto 1.5D linear network mesh}
\usage{
projection.points.1.5D(mesh, locations)
}
\arguments{
\item{mesh}{A mesh.1.5D object representing the graph mesh, created by \link{create.mesh.1.5D}.}

\item{locations}{2D points to be projected onto 1.5D mesh.}
}
\value{
2D points projected onto 1.5D linear network mesh.
}
\description{
This function projects any 2D points onto 1.5D linear network mesh.
}
\examples{
library(fdaPDE)
##Create Mesh

nodes=matrix(c(0.25,0.25,0.5,0.25,0.75,0.5,0.75,0.), nrow = 4, byrow=TRUE)
edges=matrix(c(1,2,2,3,2,4),nrow = 3,byrow = TRUE)
mesh_ = create.mesh.1.5D(nodes,edges,order=1)

## Create 2D points to be projected
locations=matrix(nrow=5,ncol=2)
locations[,1] = runif(5,min=0.25,max=0.75)
locations[,2] = runif(5,min=0.25,max=0.5)

## Project the points on the mesh
loc = projection.points.1.5D(mesh_, locations)
}
