% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fbroc.roc.R
\name{boot.roc}
\alias{boot.roc}
\title{Bootstrap ROC curve}
\usage{
boot.roc(pred, true.class, stratify = TRUE, n.boot = 1000)
}
\arguments{
\item{pred}{A numeric vector. Contains predictions. \code{boot.roc} assumes
that a high prediction is evidence for the observation belonging to the
positive class.}

\item{true.class}{A logical vector. TRUE indicates the sample belonging to the
positive class.}

\item{stratify}{Logical. Indicates whether we use stratified bootstrap.
Default to TRUE. Non-stratified bootstrap is not yet implemented.}

\item{n.boot}{A number that will be coerced to integer. Specified the
number of bootstrap replicates. Defaults to 1000.}
}
\value{
A list of class \code{fbroc.roc}, containing the elements:
\item{prediction}{Input predictions.}
\item{true.class}{Input classes.}
\item{thresholds}{Thresholds.}
\item{n.thresholds}{Number of thresholds.}
\item{n.boot}{Number of bootstrap replicates.}
\item{n.pos}{Number of positive observations.}
\item{n.neg}{Number of negative observations.}
\item{tpr.fpr}{Vector containing true and false positive rates at
                     the different thresholds for the original predictions.}
\item{tpr.fpr.raw}{Vector containing raw results from C++ for later usage by
 other functions.}
\item{time.used}{Time in seconds used for the bootstrap. Other steps are not
included.}
\item{auc}{The AUC of the original ROC curve.}
\item{tpr.fpr.boot.matrix}{Matrix containing TPR and FPR values at the
thresholds for each bootstrap replicate.}
}
\description{
\code{boot.roc} calculates the ROC curve, initializes the settings
and calculates the bootstrap results for the true and false
positive rate at every relevant threshold. Missing values are removed with
a warning prior to bootstrapping.
}
\examples{
y <- rep(c(TRUE, FALSE), each = 500)
x <- rnorm(1000) + y
result.boot <- boot.roc(x, y)
}
\seealso{
\code{\link{plot.fbroc.roc}}, \code{\link{print.fbroc.roc}}
}

