% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setModel.R
\name{setModel}
\alias{setModel}
\alias{print.linkdat.model}
\title{Set, change or display the model parameters for 'linkdat' objects}
\usage{
setModel(x, model = NULL, chrom = NULL, penetrances = NULL, dfreq = NULL)

\method{print}{linkdat.model}(x, ...)
}
\arguments{
\item{x}{in \code{setModel}: a \code{\link{linkdat}} object. In
\code{print.linkdat.model}: a \code{linkdat.model} object.}

\item{model}{NULL, or an object of class \code{linkdat.model}, namely a list
with elements \code{chrom}, \code{penetrances} and \code{dfreq}.  In the
\code{setModel} function, the \code{model} argument can be one of the
integers 1-4, with the following meanings:

1 = autosomal dominant; fully penetrant, dfreq=1e-5

2 = autosomal recessive; fully penetrant, dfreq=1e-5

3 = X-linked dominant; fully penetrant, dfreq=1e-5

4 = X-linked recessive; fully penetrant, dfreq=1e-5}

\item{chrom}{a character, either 'AUTOSOMAL' or 'X'. Lower case versions are
allowed and will be converted automatically.}

\item{penetrances}{if \code{chrom=='AUTOSOMAL'}: a numeric of length 3 -
\code{(f0, f1, f2)} - where \code{fi} is the probability of being affected
given \code{i} disease alleles.

If \code{chrom=='X'}: a list of two vectors, containing the penetrances for
each sex: \code{penetrances = list(male=c(f0, f1), female=c(f0, f1, f2))}.}

\item{dfreq}{the population frequency of the disease allele.}

\item{...}{further parameters}
}
\value{
\code{setModel} returns a new \code{linkdat} object, whose
\code{model} entry is a \code{linkdat.model} object: A list containing the
given \code{chrom}, \code{penetrances} and \code{dfreq}.
}
\description{
Functions to set, change and display model parameters involved in parametric
linkage analysis.
}
\seealso{
\code{\link{linkdat}}
}
