% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nested_list.R
\name{nested_list}
\alias{nested_list}
\title{Output a nested list in RMarkdown list format}
\usage{
nested_list(x, pre = "", quote = "")
}
\arguments{
\item{x}{The list}

\item{pre}{Text to prefix to each line (e.g., if you want all lines indented 4 spaces to start, use "    ")}

\item{quote}{Text to quote values with (e.g., use "`" to make sure values are not parsed as markdown}
}
\value{
A character string
}
\description{
Output a nested list in RMarkdown list format
}
\examples{
x <- list(
  a = list(a1 = "Named", a2 = "List"),
  b = list("Unnamed", "List"),
  c = c(c1 = "Named", c2 = "Vector"),
  d = c("Unnamed", "Vector"),
  e = list(e1 = list("A", "B", "C"),
           e2 = list(a = "A", b = "B"),
           e3 = c("A", "B", "C"),
           e4 = 100),
  f = "single item vector",
  g = list()
)
nested_list(x)
}
