% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wide2long.R
\name{wide2long}
\alias{wide2long}
\title{Convert data from wide to long format}
\usage{
wide2long(
  data,
  within_factors = c(),
  within_cols = c(),
  dv = "y",
  id = "id",
  sep = faux_options("sep")
)
}
\arguments{
\item{data}{the tbl in wide format}

\item{within_factors}{the names of the within factors}

\item{within_cols}{the names (or indices) of the within-subject (value) columns}

\item{dv}{the name of the dv column (defaults to "y")}

\item{id}{the name of the ID column(s) if they don't exist, a new column will be made (defaults to ("id")}

\item{sep}{separator for within-columns (to be used in strsplit, so can be regex), defaults to "_"}
}
\value{
a tbl in long format
}
\description{
Convert data from wide to long format
}
\examples{
wide2long(iris, c("Feature", "Measure"), 1:4, sep = "\\\\.")

}
