% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnorm_pre.R
\name{rnorm_pre}
\alias{rnorm_pre}
\title{Make a normal vector correlated to an existing vector}
\usage{
rnorm_pre(x, mu = 0, sd = 1, r = 0, empirical = FALSE)
}
\arguments{
\item{x}{the existing vector}

\item{mu}{desired mean of returned vector}

\item{sd}{desired SD of returned vector}

\item{r}{desired correlation between existing and returned vectors}

\item{empirical}{logical. If true, mu, sd and r specify the empirical not population mean, sd and covariance}
}
\value{
vector
}
\description{
\code{rnorm_pre} Produces a random normally distributed vector with the specified correlation to an existing vector
}
\examples{
v1 <- rnorm(10)
v2 <- rnorm_pre(v1, 0, 1, 0.5)
cor(v1, v2)
}
