% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric.distance.medianecc.R
\name{metric.distance.medianecc}
\alias{metric.distance.medianecc}
\title{Median Eccentricity}
\usage{
metric.distance.medianecc(g, p)
}
\arguments{
\item{g}{The input network.}

\item{p}{The sampling probability.}
}
\value{
A real constant.
}
\description{
Calculate the (estimated) median eccentricity of a graph.
}
\details{
Is the median eccentricities of all nodes in graph \emph{g}.
\code{metric.distance.medianecc} calculates the (estimated) median eccentricity of graph \emph{g} with a justified error.
}
\examples{
\dontrun{
x <-  net.erdos.renyi.gnp(1000, 0.01)
metric.distance.medianecc(x, 0.01)}
}
\author{
Xu Dong, Nazrul Shaikh.
}
\references{
West, Douglas Brent. Introduction to graph theory. Vol. 2. Upper Saddle River: Prentice hall, 2001.
}

