% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xor.r
\name{xor,GVector,GVector-method}
\alias{xor,GVector,GVector-method}
\alias{xor}
\title{Select parts of polygons not shared between two GVectors}
\usage{
\S4method{xor}{GVector,GVector}(x, y)
}
\arguments{
\item{x, y}{\code{GVector}s.}
}
\value{
A \code{GVector}.
}
\description{
The \code{xor()} function selects the area that does \emph{not} overlap between two "polygon" \code{GVector}s. You can also use the \code{/} operator, as in \code{vect1 / vect2}.
}
\examples{
if (grassStarted()) {

# Setup
library(sf)

# Polygon of coastal Madagascar and Dypsis specimens
madCoast4 <- fastData("madCoast4") # polygons
madDypsis <- fastData("madDypsis") # points

# Convert vectors:
coast4 <- fast(madCoast4)
dypsis <- fast(madDypsis)

# Create another polygons vector from a convex hull around Dypsis points
hull <- convHull(dypsis)

### union()

unioned <- union(coast4, hull)
plot(unioned)

plus <- coast4 + hull # same as union()

### intersect

inter <- intersect(coast4, hull)
plot(coast4)
plot(hull, border = "red", add = TRUE)
plot(inter, border = "blue", add = TRUE)

### xor

xr <- xor(coast4, hull)
plot(coast4)
plot(xr, border = "blue", add = TRUE)

### erase

erased <- erase(coast4, hull)
plot(coast4)
plot(erased, border = "blue", add = TRUE)

minus <- coast4 - hull # same as erase()

}
}
\seealso{
\code{\link[=crop]{crop()}}, \code{\link[=intersect]{intersect()}}, \code{\link[=union]{union()}}, \code{\link[=erase]{erase()}}
}
