% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropRows.r
\name{dropRows,data.table-method}
\alias{dropRows,data.table-method}
\alias{dropRows}
\alias{dropRows,data.frame-method}
\alias{dropRows,matrix-method}
\title{Remove rows in a data.table, data.frame, or matrix.}
\usage{
\S4method{dropRows}{data.table}(x, drops)

\S4method{dropRows}{data.frame}(x, drops)

\S4method{dropRows}{matrix}(x, drops)
}
\arguments{
\item{x}{A \code{data.table} or \code{data.frame}.}

\item{drops}{Numeric, integer, or logical vector: Indices or indicators of rows to remove.

If a logical vector is supplied, rows that correspond to \code{TRUE} will be removed. If the vector is shorter than the number of rows, values of \code{drops} will be recycled.}
}
\value{
A \code{data.table} or \code{data.frame}.
}
\description{
As of September of 2023, the \strong{data.table} package does not have a function for removing rows by index. This function does this job.
}
\examples{

library(data.table)

dt <- data.table(
   x = 1:10,
   y = letters[1:10],
   z = rnorm(10)
)

# make some values NA
dt[x == 4 | x == 8, y := NA_character_]
dt

# Replace NAs:
replaceNAs(dt, replace = -99, cols = "y")
dt

# Drop rows:
dropped <- dropRows(dt, 8:10)
dropped

# NB May not print... in that case, use:
print(dropped)

# We can also use replaceNAs() on vectors:
y <- 1:10
y[c(2, 10)] <- NA
replaceNAs(y, -99)

# Same as:
y <- 1:10
y[c(2, 10)] <- NA
y[is.na(y)] <- -99
}
