% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcpd.R
\name{fastcpd_mean}
\alias{fastcpd_mean}
\alias{fastcpd.mean}
\title{Find change points efficiently in mean change models}
\usage{
fastcpd_mean(data, ...)

fastcpd.mean(data, ...)
}
\arguments{
\item{data}{A matrix, a data frame or a vector.}

\item{...}{Other arguments passed to \code{\link[=fastcpd]{fastcpd()}}, for example,
\code{segment_count}.}
}
\value{
A \linkS4class{fastcpd} object.
}
\description{
\code{\link[=fastcpd_mean]{fastcpd_mean()}} and \code{\link[=fastcpd.mean]{fastcpd.mean()}} are wrapper
functions of \code{\link[=fastcpd]{fastcpd()}} to find the mean change. The function is
similar to \code{\link[=fastcpd]{fastcpd()}} except that the data is by default a matrix or
data frame or a vector with each row / element as an observation and thus a
formula is not required here.
}
\examples{
if (requireNamespace("mvtnorm", quietly = TRUE)) {
  set.seed(1)
  p <- 3
  data <- rbind(
    mvtnorm::rmvnorm(3e+5, mean = rep(0, p), sigma = diag(100, p)),
    mvtnorm::rmvnorm(4e+5, mean = rep(50, p), sigma = diag(100, p)),
    mvtnorm::rmvnorm(3e+5, mean = rep(2, p), sigma = diag(100, p))
  )
  result_time <- system.time(
    result <- fastcpd.mean(data, r.progress = FALSE, cp_only = TRUE)
  )
  print(result_time)
  summary(result)
}
}
\seealso{
\code{\link[=fastcpd]{fastcpd()}}
}
