% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcpd_data.R
\docType{data}
\name{bitcoin}
\alias{bitcoin}
\title{Bitcoin Market Price (USD)}
\format{
A data frame with 1354 rows and 2 variables:
\describe{
  \item{date}{POSIXct,POSIXt (TZ: "UTC") from 2019-01-02 to 2023-10-28}
  \item{price}{The average USD market price across major bitcoin exchanges}
}
}
\source{
<https://www.blockchain.com/explorer/charts/market-price>
}
\usage{
bitcoin
}
\description{
The average USD market price across major bitcoin exchanges.
}
\examples{
\donttest{
if (!requireNamespace("ggplot2", quietly = TRUE)) utils::install.packages(
  "ggplot2", repos = "https://cloud.r-project.org", quiet = TRUE
)

ggplot2::ggplot(bitcoin, ggplot2::aes(x = date, y = price)) +
  ggplot2::geom_line()

result <- suppressWarnings(
  fastcpd.garch(diff(log(bitcoin$price[200:500])), c(1, 1))
)
summary(result)
bitcoin$date[result@cp_set + 200]
plot(result)
}
}
\keyword{datasets}
