% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unet.R
\name{UnetBlock}
\alias{UnetBlock}
\title{UnetBlock}
\usage{
UnetBlock(
  up_in_c,
  x_in_c,
  hook,
  final_div = TRUE,
  blur = FALSE,
  act_cls = nn$ReLU,
  self_attention = FALSE,
  init = nn$init$kaiming_normal_,
  norm_type = NULL,
  ks = 3,
  stride = 1,
  padding = NULL,
  bias = NULL,
  ndim = 2,
  bn_1st = TRUE,
  transpose = FALSE,
  xtra = NULL,
  bias_std = 0.01,
  dilation = 1,
  groups = 1,
  padding_mode = "zeros"
)
}
\arguments{
\item{up_in_c}{up_in_c parameter}

\item{x_in_c}{x_in_c parameter}

\item{hook}{The hook is set to this intermediate layer to store the output needed for this block.}

\item{final_div}{final div}

\item{blur}{blur is used to avoid checkerboard artifacts at each layer.}

\item{act_cls}{activation}

\item{self_attention}{self_attention determines if we use a self-attention layer}

\item{init}{initializer}

\item{norm_type}{normalization type}

\item{ks}{kernel size}

\item{stride}{stride}

\item{padding}{padding mode}

\item{bias}{bias}

\item{ndim}{number of dimensions}

\item{bn_1st}{batch normalization 1st}

\item{transpose}{transpose}

\item{xtra}{xtra}

\item{bias_std}{bias standard deviation}

\item{dilation}{dilation}

\item{groups}{groups}

\item{padding_mode}{The mode of padding}
}
\value{
None
}
\description{
A quasi-UNet block, using `PixelShuffle_ICNR upsampling`.
}
