% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qrchol}
\alias{qrchol}
\title{Cholesky decomposition via QR factorization.}
\usage{
qrchol(X, nb = NULL)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix.}

\item{nb}{number of blocks for the recursive block QR decomposition, default is NULL.}
}
\value{
an upper triangular matrix of dimension \eqn{p\times p} which represents the Cholesky decomposition of \eqn{X^\top X}.
}
\description{
qrchol, provides the Cholesky decomposition of the symmetric and positive definite matrix \eqn{X^\top X\in\mathbb{R}^{p\times p}}, where \eqn{X\in\mathbb{R}^{n\times p}} is the input matrix.
}
