% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.fastNaiveBayes.gaussian.R
\name{predict.fastNaiveBayes.gaussian}
\alias{predict.fastNaiveBayes.gaussian}
\title{Predict Method for fastNaiveBayes.gaussian fits}
\usage{
\method{predict}{fastNaiveBayes.gaussian}(object, newdata,
  type = c("class", "raw", "rawprob"), sparse = FALSE,
  threshold = .Machine$double.eps, ...)
}
\arguments{
\item{object}{A fitted object of class "fastNaiveBayes.gaussian".}

\item{newdata}{A numeric matrix. A Sparse dgcMatrix is also accepted.
Note that if newdata contains features that were not encountered in the training data, these are omitted from the prediction.
Furthermore, newdata can contain fewer features than encountered in the training data.}

\item{type}{If "raw", the conditional a-posterior probabilities for each class are returned, and the class with maximal probability else.}

\item{sparse}{Use a sparse Matrix? If true a sparse matrix will be constructed from x, which can give up to a 40\% speed up.
It's possible to directly feed a sparse dgcMatrix as x, which will set this parameter to TRUE}

\item{threshold}{A threshold for the minimum probability. For Bernoulli and Multinomial event models Laplace smoothing solves this,
but in the case of Gaussian event models, this ensures numerical probabilities}

\item{...}{Not used.}
}
\value{
If type = 'class', a factor with classified class levels. If type = 'raw', a matrix with the predicted probabilities of
    each class, where each column in the matrix corresponds to a class level.
}
\description{
Uses a fastNaiveBayes.gaussian model and a new data set to create the classifications.
    This can either be the raw probabilities generated by the fastNaiveBayes.gaussian model or the classes themselves.
}
\details{
In the extremely unlikely case that two classes have the exact same estimated probability, the first encountered class
    is used as the classification and a warning is issued.

    Using a sparse matrix directly can be especially useful if it's necessary to use predict multiple times on the same matrix or
    on different subselections of the same initial matrix, see examples for further details.
}
\examples{
rm(list = ls())
library(fastNaiveBayes)
cars <- mtcars
y <- as.factor(ifelse(cars$mpg > 25, "High", "Low"))
x <- cars[, 2:ncol(cars)]

dist <- fastNaiveBayes::fastNaiveBayes.detect_distribution(x, nrows = nrow(x))

# Gaussian only
vars <- c("hp", dist$gaussian)
newx <- x[, vars]

mod <- fastNaiveBayes.gaussian(newx, y)
pred <- predict(mod, newdata = newx)
mean(pred != y)
}
