% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterMatch.R
\name{clusterMatch}
\alias{clusterMatch}
\title{clusterMatch}
\usage{
clusterMatch(vecA, vecB, nclusters, max.n, word.embed, min.var,
weighted.kmeans, iter.max)
}
\arguments{
\item{vecA}{The character vector from dataset A}

\item{vecB}{The character vector from dataset B}

\item{nclusters}{The number of clusters to create from the provided data. Either
nclusters = NULL or max.n = NULL.}

\item{max.n}{The maximum size of either dataset A or dataset B in
the largest cluster. Either nclusters = NULL or max.n = NULL}

\item{word.embed}{Whether to use word embedding clustering. Default is FALSE.}

\item{min.var}{The minimum amount of explained variance (maximum = 1) a
PCA dimension can provide in order to be included in k-means clustering when
using word embedding. Default is .20.}

\item{weighted.kmeans}{Whether to weight the k-means algorithm features by the
explained variance of the included principal component when using word
embedding clustering. Default is FALSE.}

\item{iter.max}{Maximum number of iterations for the k-means algorithm.}
}
\value{
\code{clusterMatch} returns a list of length 3:
\item{clusterA}{The cluster assignments for dataset A}
\item{clusterB}{The cluster assignments for dataset B}
\item{n.clusters}{The number of clusters created}
\item{kmeans}{The k-means object output.}
\item{pca}{The PCA object output.}
\item{dims.pca}{The number of dimensions from PCA used for the k-means clustering.}
}
\description{
Creates properly sized clusters for matching, using either
alphabetical or word embedding clustering. If using word embedding,
the function first creates a word embedding out of the provided
vectors, and then runs PCA on the matrix. It then takes the first
\code{k} dimensions (where \code{k} is provided by the user) and
k-means is run on that matrix to get the clusters.
}
\examples{
data(samplematch)
cl <- clusterMatch(dfA$firstname, dfB$firstname, nclusters = 3)
}
\author{
Ben Fifield <benfifield@gmail.com>
}

