% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_full_analysis.R
\name{compute_full_analysis}
\alias{compute_full_analysis}
\title{Compute a suite of tables and plots from various fasstr functions}
\usage{
compute_full_analysis(
  data,
  dates = Date,
  values = Value,
  groups = STATION_NUMBER,
  station_number,
  analyses = 1:7,
  basin_area,
  water_year_start = 1,
  start_year,
  end_year,
  exclude_years,
  months = 1:12,
  complete_years = FALSE,
  ignore_missing = FALSE,
  allowed_missing_annual = ifelse(ignore_missing, 100, 0),
  allowed_missing_monthly = ifelse(ignore_missing, 100, 0),
  zyp_method = "zhang",
  zyp_alpha
)
}
\arguments{
\item{data}{Data frame of daily data that contains columns of dates, flow values, and (optional) groups (e.g. station numbers).
Leave blank or set to \code{NULL} if using \code{station_number} argument.}

\item{dates}{Name of column in \code{data} that contains dates formatted YYYY-MM-DD. Only required if dates column name is not 
'Date' (default). Leave blank or set to \code{NULL} if using \code{station_number} argument.}

\item{values}{Name of column in \code{data} that contains numeric flow values, in units of cubic metres per second.
Only required if values column name is not 'Value' (default). Leave blank if using \code{station_number} argument.}

\item{groups}{Name of column in \code{data} that contains unique identifiers for different data sets, if applicable. Only required 
if groups column name is not 'STATION_NUMBER'. Function will automatically group by a column named 'STATION_NUMBER' if 
present. Remove the 'STATION_NUMBER' column beforehand to remove this grouping. Leave blank if using \code{station_number} 
argument.}

\item{station_number}{Character string vector of seven digit Water Survey of Canada station numbers (e.g. \code{"08NM116"}) of
which to extract daily streamflow data from a HYDAT database. Requires \code{tidyhydat} package and a HYDAT database.
Leave blank if using \code{data} argument.}

\item{analyses}{Numeric vector of analyses to run (default is all (\code{1:7})):
\itemize{
 \item{1: Screening}
 \item{2: Long-term}
 \item{3: Annual}
 \item{4: Monthly}
 \item{5: Daily}
 \item{6: Annual Trends}
 \item{7: Low-flow Frequencies}
 }}

\item{basin_area}{Upstream drainage basin area, in square kilometres, to apply to observations. Three options:

(1) Leave blank if \code{groups} is STATION_NUMBER with HYDAT station numbers to extract basin areas from HYDAT.

(2) A single numeric value to apply to all observations.

(3) List each basin area for each group/station in groups (can override HYDAT value if listed) as such \code{c("08NM116" = 795, 
"08NM242" = 10)}. If group is not listed the HYDAT area will be applied if it exists, otherwise it will be \code{NA}.}

\item{water_year_start}{Numeric value indicating the month (\code{1} through \code{12}) of the start of water year for
analysis. Default \code{1}.}

\item{start_year}{Numeric value of the first year to consider for analysis. Leave blank or set well before start date (i.e.
\code{1800}) to use from the first year of the source data.}

\item{end_year}{Numeric value of the last year to consider for analysis. Leave blank or set well after end date (i.e.
\code{2100}) to use up to the last year of the source data.}

\item{exclude_years}{Numeric vector of years to exclude from analysis. Leave blank or set to \code{NULL} to include all years.}

\item{months}{Numeric vector of months to include in analysis. For example, \code{3} for March, \code{6:8} for Jun-Aug or 
\code{c(10:12,1)} for first four months (Oct-Jan) when \code{water_year_start = 10} (Oct). Default summarizes all 
months (\code{1:12}). If not all months, seasonal total yield and volumetric flows will not be included.}

\item{complete_years}{Logical values indicating whether to include only years with complete data in analysis. Default \code{FALSE}.}

\item{ignore_missing}{Logical value indicating whether dates with missing values should be included in the calculation. If
\code{TRUE} then a statistic will be calculated regardless of missing dates. If \code{FALSE} then only those statistics from
time periods with no missing dates will be returned. Default \code{FALSE}.}

\item{allowed_missing_annual}{Numeric value between 0 and 100 indicating the \strong{percentage} of missing dates allowed to be
included to calculate an annual statistic (0 to 100 percent). If \code{'ignore_missing = FALSE'} then it defaults to \code{0} 
(zero missing dates allowed), if \code{'ignore_missing = TRUE'} then it defaults to \code{100} (any missing dates allowed); 
consistent with \code{ignore_missing} usage. Supersedes \code{ignore_missing} when used. Only for annual means, percentiles,
minimums, and maximums.}

\item{allowed_missing_monthly}{Numeric value between 0 and 100 indicating the \strong{percentage} of missing dates allowed to be
included to calculate a monthly statistic (0 to 100 percent). If \code{'ignore_missing = FALSE'} then it defaults to \code{0} 
(zero missing dates allowed), if \code{'ignore_missing = TRUE'} then it defaults to \code{100} (any missing dates allowed); 
consistent with \code{ignore_missing} usage. Supersedes \code{ignore_missing} when used.Only for monthly means, percentiles,
minimums, and maximums.}

\item{zyp_method}{Character string identifying the prewhitened trend method to use from \code{'zyp'}, either \code{'zhang'} or
\code{'yuepilon'}. \code{'zhang'} is recommended over \code{'yuepilon'} for hydrologic applications (see 
\code{compute_annual_trends()}; Bürger 2017; Zhang and Zwiers 2004). Only required if analysis group 6 is included. 
Default \code{'zhang'}.}

\item{zyp_alpha}{Numeric value of the significance level (ex. \code{0.05}) of when to plot a trend line. Leave blank for no line.}
}
\value{
A list of lists of tibble data frames and ggplot2 objects from various fasstr functions
   organized by the analysis groups as listed above.
}
\description{
Calculates tables and plots from a suite of statistics from \code{fasstr} functions. Calculates statistics from all 
   values, unless specified.The statistics are grouped into 7 analysis groups (see \code{analyses} argument) which are stored in 
   lists in the object. Due to the number of tables and plots to be made, this function may take several minutes to complete. If 
   \code{ignore_missing = FALSE} (default) and there is missing data, some tables and plots may be empty and produce warnings. 
   Use \code{ignore_missing = TRUE} to ignore the missing values or filter your data to complete years.
   Returns a list of tibbles and plots.
}
\examples{
\dontrun{

# Working examples:

# Compute a full analysis will all the analyses
results <- compute_full_analysis(station_number = "08NM116",
                                 start_year = 1980,
                                 end_year = 2010)

# Compute a full analysis with only Annual (3) and Daily (5) analyses
results <- compute_full_analysis(station_number = "08NM116",
                                 start_year = 1980,
                                 end_year = 2010,
                                 analyses = c(3,5))
                     
}
}
\seealso{
\code{\link{plot_flow_data}},
         \code{\link{screen_flow_data}},
         \code{\link{plot_data_screening}},
         \code{\link{plot_missing_dates}},
         \code{\link{calc_longterm_monthly_stats}},
         \code{\link{plot_longterm_monthly_stats}},
         \code{\link{calc_longterm_daily_stats}},
         \code{\link{plot_longterm_daily_stats}},
         \code{\link{plot_monthly_means}},
         \code{\link{plot_flow_duration}},
         \code{\link{calc_annual_stats}},
         \code{\link{plot_annual_stats}},
         \code{\link{calc_annual_cumulative_stats}},
         \code{\link{plot_annual_cumulative_stats}},
         \code{\link{calc_annual_flow_timing}},
         \code{\link{plot_annual_flow_timing}},
         \code{\link{calc_annual_normal_days}},
         \code{\link{plot_annual_normal_days}},
         \code{\link{calc_annual_lowflows}},
         \code{\link{plot_annual_lowflows}},
         \code{\link{plot_annual_means}},
         \code{\link{calc_monthly_stats}},
         \code{\link{plot_monthly_stats}},
         \code{\link{calc_monthly_cumulative_stats}},
         \code{\link{plot_monthly_cumulative_stats}},
         \code{\link{calc_daily_stats}},
         \code{\link{plot_daily_stats}},
         \code{\link{calc_daily_cumulative_stats}},
         \code{\link{plot_daily_cumulative_stats}},
         \code{\link{compute_annual_trends}},
         \code{\link{compute_annual_frequencies}},
         \code{\link{write_flow_data}},
         \code{\link{write_plots}}
}
