/*
 * Decompiled with CFR 0.152.
 */
package jfm.xml;

import jfm.model.CropInput;
import jfm.model.Types;
import jfm.xml.JFMObjectParser;
import jfm.xml.ObjectParser;
import jfm.xml.XMLObjectException;
import jfm.xml.XMLSyntaxException;

public class CropInputParser
extends JFMObjectParser {
    public CropInputParser(ObjectParser parent_) {
        this.parent = parent_;
        this.registerAttribute("type", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("unitCost", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("baseAmount", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("increments", JFMObjectParser.optionalAttribute);
    }

    public void initializeObject() throws XMLObjectException, XMLSyntaxException {
        try {
            Types.VariableType associated = Types.xmlToVariableType(this.getNamedAttribute("type"));
            double unitCost = Double.parseDouble(this.getNamedAttribute("unitCost"));
            double baseAmount = Double.parseDouble(this.getNamedAttribute("baseAmount"));
            double[] amounts = new double[]{baseAmount};
            if (this.attributeHasValue("increments")) {
                String[] incrs = this.getNamedAttribute("increments").split(",");
                amounts = new double[incrs.length + 1];
                amounts[0] = baseAmount;
                for (int i = 0; i < incrs.length; ++i) {
                    amounts[i + 1] = baseAmount + Double.parseDouble(incrs[i]);
                }
            }
            this.obj = new CropInput(amounts, unitCost, associated);
        }
        catch (XMLSyntaxException ex) {
            throw new XMLSyntaxException("Syntax exception when parsing input " + ex.getMessage());
        }
    }

    protected boolean isPrimitive() {
        return false;
    }

    public String name() {
        return "CropInputParser";
    }

    public String parsesNode() {
        return "input";
    }

    public String toString() {
        return "CropInputParser";
    }
}

