/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jfm.lp.ConstraintBuilder;
import jfm.lp.LPX;
import jfm.lp.MatrixElement;
import jfm.lp.MatrixRow;
import jfm.lp.MatrixVariable;
import jfm.lp.ModelComponent;
import jfm.model.BadModelException;
import jfm.model.Crop;
import jfm.model.CropYear;
import jfm.model.CroppingComponent;
import jfm.model.Farm;
import jfm.model.Location;
import jfm.model.Operation;
import jfm.model.Rotation;
import jfm.model.RotationMatrix;
import jfm.model.RotationPenalty;
import jfm.model.Types;

public final class RotationsComponent
extends ModelComponent {
    private static String constraintTag = "Rotations";
    private final int numPeriods;
    private final Map<CropYear, HashMap<CropYear, RotationPenalty>> rotationPenalties = new HashMap<CropYear, HashMap<CropYear, RotationPenalty>>();

    public String name() {
        return "rotations";
    }

    public RotationsComponent(int numPeriods_, CroppingComponent cropping, Location loc) {
        super(ModelComponent.MCType.ROTATIONS);
        this.requireObjective(Types.ObjectiveType.PROFIT);
        this.numPeriods = numPeriods_;
        for (CropYear toyr : cropping.cropYears()) {
            HashMap<CropYear, RotationPenalty> frommap = new HashMap<CropYear, RotationPenalty>();
            for (CropYear fromyr : cropping.cropYears()) {
                double pen = 0.0;
                RotationPenalty penaltyp = new RotationPenalty(pen);
                frommap.put(fromyr, penaltyp);
            }
            this.rotationPenalties.put(toyr, frommap);
        }
        this.addConstraintBuilder(new LastOpRotationConstraint());
        this.addConstraintBuilder(new SeqFirstOpRotationConstraint());
        this.addConstraintBuilder(new NonSeqFirstOpRotationConstraint());
    }

    public RotationsComponent copy() {
        throw new Error("Bare copy() called on rotations. Should use copy(Cropping,Location) instead");
    }

    RotationsComponent copy(CroppingComponent newcropping, Location loc) {
        return new RotationsComponent(this.numPeriods, newcropping, loc);
    }

    protected void initializeStructure() throws BadModelException {
        CroppingComponent cropping = this.getParent().cropping;
        this.setRotationPenalties(this.getParent().location());
        Set<CropYear> cropYearsSet = cropping.cropYears();
        for (CropYear toCrop : cropYearsSet) {
            boolean canRotateTo = false;
            for (CropYear fromCrop : cropYearsSet) {
                if (!this.isAllowed(toCrop, fromCrop, cropping)) continue;
                canRotateTo = true;
                Operation handoverfromop = cropping.getCrop(fromCrop.base).getCopy(fromCrop.copyYear).handOverOperation();
                RotationPenalty penaltyp = this.rotationPenalties.get(toCrop).get(fromCrop);
                penaltyp.registerParent(this);
                for (Integer phandover : handoverfromop.unfoldedAllowedSet()) {
                    MatrixVariable newVariable = new MatrixVariable(-penaltyp.penalty(), 0.0, 0.0, LPX.LPX_LO, LPX.LPX_CV, this.matrix.numCols(), Types.ObjectiveType.PROFIT);
                    newVariable.setTag((Object)((Object)fromCrop.base) + "_" + fromCrop.copyYear + "_to_" + (Object)((Object)toCrop.base) + "_" + toCrop.copyYear + "_" + phandover);
                    this.matrix.addVariable(newVariable);
                    penaltyp.registerVariable(newVariable, phandover);
                }
            }
            if (canRotateTo) continue;
            throw new BadModelException("The model is badly specified. It is impossible to rotate to crop " + (Object)((Object)toCrop.base));
        }
    }

    public void setFormulaVariables() {
    }

    private void setRotationPenalties(Location loc) {
        CroppingComponent cropping = this.getParent().cropping;
        Set<CropYear> cropYearsSet = cropping.cropYears();
        for (CropYear toCrop : cropYearsSet) {
            for (CropYear fromCrop : cropYearsSet) {
                if (!this.isAllowed(toCrop, fromCrop, cropping)) continue;
                Types.CropType toD = cropping.getCrop((Types.CropType)toCrop.base).type;
                Types.DiseaseType fD = cropping.getCrop((Types.CropType)fromCrop.base).diseaseType;
                Crop.CropCopy ccp = cropping.getCrop(toCrop.base).getCopy(toCrop.copyYear);
                this.rotationPenalties.get(toCrop).get(fromCrop).setPenalty(cropping.getRotationPenalty(toD, fD), ccp, loc);
            }
        }
    }

    protected void updateStructure() {
        for (HashMap<CropYear, RotationPenalty> rpto : this.rotationPenalties.values()) {
            for (RotationPenalty rp : rpto.values()) {
                rp.updateStructure(this);
            }
        }
        this.structureUpdateDone();
    }

    private boolean isAllowed(CropYear to, CropYear from, CroppingComponent cropping) {
        Crop.CropCopy tocrop = cropping.getCrop(to.base).getCopy(to.copyYear);
        Crop.CropCopy fromcrop = cropping.getCrop(from.base).getCopy(from.copyYear);
        Rotation toCpRot = cropping.getCrop(tocrop.type()).rotation();
        if (toCpRot.isForbidden(fromcrop.diseaseType())) {
            return false;
        }
        if (tocrop.diseaseType() == Types.DiseaseType.NONE) {
            return true;
        }
        if (to.copyYear == 0 && fromcrop.diseaseType() != tocrop.diseaseType()) {
            return true;
        }
        if (fromcrop.diseaseType() == tocrop.diseaseType()) {
            if (from.copyYear + 1 == to.copyYear) {
                return true;
            }
            Crop cp = cropping.getCrop(to.base);
            if (from.copyYear == to.copyYear && cp.continuousCroppingAllowed && to.copyYear == cp.getYearCopies().size() - 1) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer outstring = new StringBuffer();
        outstring.append("--- Rotations ---");
        return outstring.toString();
    }

    public double[] getSolvedRotationPenaltyForCrop(Crop.CropCopy tocp, Location loc) {
        CroppingComponent cropping = this.getParent().cropping;
        List<Crop.CropCopy> usedCrops = cropping.cropsUsed();
        CropYear toyr = new CropYear(tocp.type(), tocp.copyYear());
        double[] totalCost = new double[]{0.0, 0.0};
        for (Crop.CropCopy frcp : usedCrops) {
            CropYear fromyr = new CropYear(frcp.type(), frcp.copyYear());
            if (!this.isAllowed(toyr, fromyr, cropping)) continue;
            for (Integer p : cropping.getCrop(fromyr.base).getCopy(fromyr.copyYear).handOverOperation().unfoldedAllowedSet()) {
                RotationPenalty rp = this.rotationPenalties.get(toyr).get(fromyr);
                double[] penalties = cropping.getRotationPenalty(tocp.type(), frcp.diseaseType());
                if (!(rp.area(p) > 0.0)) continue;
                totalCost[0] = totalCost[0] + rp.area(p) * tocp.costOfYieldPenalty(penalties[0], loc);
                totalCost[1] = totalCost[1] + rp.area(p) * penalties[1];
            }
        }
        return totalCost;
    }

    public RotationMatrix getSolvedRotationMatrix() {
        CroppingComponent cropping = this.getParent().cropping;
        List<Crop.CropCopy> usedCrops = cropping.cropsUsed();
        HashSet<Types.CropType> cropTypes = new HashSet<Types.CropType>();
        for (Crop.CropCopy cp : usedCrops) {
            cropTypes.add(cp.type());
        }
        RotationMatrix rmatrix = new RotationMatrix(cropTypes);
        for (Crop.CropCopy tocp : usedCrops) {
            CropYear toyr = new CropYear(tocp.type(), tocp.copyYear());
            for (Crop.CropCopy frcp : usedCrops) {
                CropYear fromyr = new CropYear(frcp.type(), frcp.copyYear());
                double area = 0.0;
                if (this.isAllowed(toyr, fromyr, cropping)) {
                    for (Integer p : cropping.getCrop(fromyr.base).getCopy(fromyr.copyYear).handOverOperation().unfoldedAllowedSet()) {
                        area += this.rotationPenalties.get(toyr).get(fromyr).area(p);
                    }
                }
                rmatrix.addElement(fromyr.base, toyr.base, area);
            }
        }
        return rmatrix;
    }

    public String printSolution() {
        DecimalFormat d3 = new DecimalFormat("#000");
        CroppingComponent cropping = this.getParent().cropping;
        StringBuffer outstring = new StringBuffer();
        outstring.append("--- Rotation Matrix ---\n");
        List<Crop.CropCopy> usedCrops = cropping.cropsUsed();
        outstring.append("      ");
        for (Crop.CropCopy cp : usedCrops) {
            outstring.append(cp.type().shortName + " ");
        }
        outstring.append("\n");
        outstring.append("     ");
        for (Crop.CropCopy cp : usedCrops) {
            outstring.append(" " + d3.format(cp.grossMargin()) + " ");
        }
        outstring.append("\n");
        for (Crop.CropCopy tocp : usedCrops) {
            outstring.append(tocp.type().shortName + " ");
            CropYear toyr = new CropYear(tocp.type(), tocp.copyYear());
            for (Crop.CropCopy frcp : usedCrops) {
                CropYear fromyr = new CropYear(frcp.type(), frcp.copyYear());
                double area = 0.0;
                if (this.rotationPenalties.get(toyr) != null && this.rotationPenalties.get(fromyr) != null) {
                    for (Integer p : frcp.handOverOperation().unfoldedAllowedSet()) {
                        area += this.rotationPenalties.get(toyr).get(fromyr).area(p);
                    }
                }
                if (area >= 0.0) {
                    outstring.append(" ");
                }
                outstring.append(d3.format(area) + " ");
            }
            outstring.append("\n");
        }
        return outstring.toString();
    }

    public final class SeqFirstOpRotationConstraint
    extends ConstraintBuilder {
        public SeqFirstOpRotationConstraint() {
            super(ConstraintBuilder.CBType.SEQFIRSTOPROT, ModelComponent.MCType.ROTATIONS);
        }

        protected void build() {
            int row = RotationsComponent.this.matrix.numRows();
            CroppingComponent cropping = RotationsComponent.this.getParent().cropping;
            Set<CropYear> cropYearsSet = cropping.cropYears();
            MatrixRow rp = null;
            boolean newRow = false;
            for (CropYear toyr : cropYearsSet) {
                Crop.CropCopy tocrop = cropping.getCrop(toyr.base).getCopy(toyr.copyYear);
                Operation firstop = tocrop.operations().get(0);
                Set<Integer> unfoldedfirstopallow = firstop.unfoldedAllowedSet();
                for (Integer pstart : unfoldedfirstopallow) {
                    newRow = true;
                    for (CropYear fromyr : cropYearsSet) {
                        Operation lastop;
                        Set<Integer> foldedendallow;
                        if (!RotationsComponent.this.isAllowed(toyr, fromyr, cropping) || !(foldedendallow = (lastop = cropping.getCrop(fromyr.base).getCopy(fromyr.copyYear).handOverOperation()).foldedAllowedSet()).contains(pstart)) continue;
                        if (newRow) {
                            rp = new MatrixRow(0.0, 0.0, LPX.LPX_LO, row, constraintTag, this.type().tag);
                            RotationsComponent.this.matrix.addRow(rp);
                            rp.addElement(new MatrixElement(firstop.getDependentColumn(pstart), -1.0));
                            ++row;
                            newRow = false;
                        }
                        for (Integer endp : lastop.unfoldedAllowedSet()) {
                            if (Farm.wrapPeriod(endp, RotationsComponent.this.numPeriods) > pstart) continue;
                            rp.addElement(new MatrixElement(((RotationPenalty)((HashMap)RotationsComponent.this.rotationPenalties.get(toyr)).get(fromyr)).getDependentColumn(endp), 1.0));
                        }
                    }
                }
            }
        }
    }

    public final class NonSeqFirstOpRotationConstraint
    extends ConstraintBuilder {
        public NonSeqFirstOpRotationConstraint() {
            super(ConstraintBuilder.CBType.NONSEQFIRSTOPROT, ModelComponent.MCType.ROTATIONS);
        }

        protected void build() {
            int row = RotationsComponent.this.matrix.numRows();
            CroppingComponent cropping = RotationsComponent.this.getParent().cropping;
            Set<CropYear> cropYearsSet = cropping.cropYears();
            for (CropYear toyr : cropYearsSet) {
                Crop.CropCopy tocrop = cropping.getCrop(toyr.base).getCopy(toyr.copyYear);
                Operation firstop = tocrop.operations().get(0);
                MatrixRow rp = new MatrixRow(0.0, 0.0, LPX.LPX_LO, row, constraintTag, this.type().tag);
                RotationsComponent.this.matrix.addRow(rp);
                ++row;
                Set<Integer> unfoldedfirstopallow = firstop.unfoldedAllowedSet();
                for (CropYear fromyr : cropYearsSet) {
                    if (!RotationsComponent.this.isAllowed(toyr, fromyr, cropping)) continue;
                    for (Integer pstart : unfoldedfirstopallow) {
                        rp.addElement(new MatrixElement(firstop.getDependentColumn(pstart), -1.0));
                        Operation lastop = cropping.getCrop(fromyr.base).getCopy(fromyr.copyYear).handOverOperation();
                        for (Integer endp : lastop.unfoldedAllowedSet()) {
                            rp.addElement(new MatrixElement(((RotationPenalty)((HashMap)RotationsComponent.this.rotationPenalties.get(toyr)).get(fromyr)).getDependentColumn(endp), 1.0));
                        }
                    }
                }
            }
        }
    }

    public final class LastOpRotationConstraint
    extends ConstraintBuilder {
        public LastOpRotationConstraint() {
            super(ConstraintBuilder.CBType.LASTOPROT, ModelComponent.MCType.ROTATIONS);
        }

        protected void build() {
            int row = RotationsComponent.this.matrix.numRows();
            CroppingComponent cropping = RotationsComponent.this.getParent().cropping;
            Set<CropYear> cropYearsSet = cropping.cropYears();
            for (CropYear fromyr : cropYearsSet) {
                Crop.CropCopy fromcrop = cropping.getCrop(fromyr.base).getCopy(fromyr.copyYear);
                Operation lastfromop = fromcrop.handOverOperation();
                MatrixRow rp = new MatrixRow(0.0, 0.0, LPX.LPX_FX, row, constraintTag, this.type().tag);
                RotationsComponent.this.matrix.addRow(rp);
                ++row;
                for (Integer p : lastfromop.unfoldedAllowedSet()) {
                    rp.addElement(new MatrixElement(lastfromop.getDependentColumn(p), 1.0));
                    for (CropYear toyr : cropYearsSet) {
                        if (!RotationsComponent.this.isAllowed(toyr, fromyr, cropping)) continue;
                        rp.addElement(new MatrixElement(((RotationPenalty)((HashMap)RotationsComponent.this.rotationPenalties.get(toyr)).get(fromyr)).getDependentColumn(p), -1.0));
                    }
                }
            }
        }
    }
}

