/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jfm.model.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Rotation {
    private final Map<Types.DiseaseType, double[]> rotPenalties = new HashMap<Types.DiseaseType, double[]>();
    private final Set<Types.DiseaseType> forbiddenDiseases = new HashSet<Types.DiseaseType>();
    public final Types.CropType to;

    public Rotation(Types.CropType totype, Map<Types.DiseaseType, double[]> rps, Set<Types.DiseaseType> forbidden) {
        this.rotPenalties.putAll(Collections.unmodifiableMap(rps));
        this.forbiddenDiseases.addAll(forbidden);
        this.to = totype;
    }

    public double[] getPenalty(Types.DiseaseType fromType) {
        if (this.rotPenalties != null && this.rotPenalties.containsKey((Object)fromType)) {
            return this.rotPenalties.get((Object)fromType);
        }
        double[] nocosts = new double[]{0.0, 0.0};
        return nocosts;
    }

    public boolean isForbidden(Types.DiseaseType dis) {
        return this.forbiddenDiseases.contains((Object)dis);
    }

    public Rotation copy() {
        return new Rotation(this.to, this.rotPenalties, this.forbiddenDiseases);
    }
}

