/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import jfm.lp.ConstraintBuilder;
import jfm.lp.LPX;
import jfm.lp.MatrixElement;
import jfm.lp.MatrixRow;
import jfm.lp.MatrixVariable;
import jfm.lp.ModelComponent;
import jfm.model.BadModelException;
import jfm.model.Crop;
import jfm.model.CroppingComponent;
import jfm.model.Types;

public class MOTADRiskComponent
extends ModelComponent {
    private MatrixVariable riskVar = null;

    public MOTADRiskComponent() {
        super(ModelComponent.MCType.MOTADRISK);
        this.requireObjective(Types.ObjectiveType.MOTADRISK);
        this.addConstraintBuilder(new MOTADRiskValueConstraint());
    }

    public ModelComponent copy() {
        return new MOTADRiskComponent();
    }

    protected void initializeStructure() throws BadModelException {
        MatrixVariable newVariable = new MatrixVariable(1.0, 0.0, 0.0, LPX.LPX_LO, LPX.LPX_CV, this.matrix.numCols(), Types.ObjectiveType.MOTADRISK);
        newVariable.setTag("motadrisk");
        this.riskVar = newVariable;
        this.matrix.addVariable(newVariable);
    }

    protected String name() {
        return "MotadRisk";
    }

    public void setFormulaVariables() {
    }

    protected void updateStructure() {
    }

    public final class MOTADRiskValueConstraint
    extends ConstraintBuilder {
        public MOTADRiskValueConstraint() {
            super(ConstraintBuilder.CBType.MOTADRISKVALUE, ModelComponent.MCType.MOTADRISK);
        }

        protected void build() {
            int row = MOTADRiskComponent.this.matrix.numRows();
            CroppingComponent cropping = MOTADRiskComponent.this.getParent().cropping;
            MatrixRow rowpointer = new MatrixRow(0.0, 0.0, LPX.LPX_FX, row, "MOTADRiskValue", this.type().tag);
            MOTADRiskComponent.this.matrix.addRow(rowpointer);
            ++row;
            rowpointer.addElement(new MatrixElement(MOTADRiskComponent.this.riskVar.column(), 1.0));
            for (Crop cp : cropping.getCrops().values()) {
                for (Crop.CropCopy cpp : cp.getYearCopies()) {
                    rowpointer.addElement(new MatrixElement(cpp.getDependentColumn(0), -1.0 * Math.abs(cpp.getMOTADRisk())));
                }
            }
        }
    }
}

