/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import jfm.lp.ConstraintBuilder;
import jfm.lp.LPX;
import jfm.lp.MatrixElement;
import jfm.lp.MatrixRow;
import jfm.lp.ModelComponent;
import jfm.model.BadModelException;
import jfm.model.Crop;
import jfm.model.CropYear;
import jfm.model.CroppingComponent;
import jfm.model.WoodlandComponent;

public class LandUseComponent
extends ModelComponent {
    public final CroppingComponent cropping;
    private WoodlandComponent woodland = null;
    public double area;
    private static String constraintTag = "landUse";

    public LandUseComponent(CroppingComponent cropping_) {
        super(ModelComponent.MCType.LANDUSE);
        this.cropping = cropping_;
        this.addConstraintBuilder(new TotalAreaConstraint());
    }

    public double getArea() {
        return this.area;
    }

    public void setArea(double newArea) {
        this.area = newArea;
        this.cropping.requireStructureUpdate();
    }

    public ModelComponent copy() {
        throw new Error("Should not be called");
    }

    protected void initializeStructure() throws BadModelException {
    }

    protected String name() {
        return "LandUse";
    }

    public void setFormulaVariables() {
    }

    protected void updateStructure() {
    }

    public final class TotalAreaConstraint
    extends ConstraintBuilder {
        public TotalAreaConstraint() {
            super(ConstraintBuilder.CBType.TOTALAREA, ModelComponent.MCType.LANDUSE);
        }

        protected void build() {
            int row = LandUseComponent.this.matrix.numRows();
            MatrixRow rowpointer = new MatrixRow(LandUseComponent.this.area, LandUseComponent.this.area, LPX.LPX_FX, row, constraintTag, this.type().tag);
            LandUseComponent.this.matrix.addRow(rowpointer);
            ++row;
            for (CropYear ct : LandUseComponent.this.cropping.cropYears()) {
                Crop.CropCopy cp = LandUseComponent.this.cropping.getCrop(ct.base).getCopy(ct.copyYear);
                rowpointer.addElement(new MatrixElement(cp.getDependentColumn(0), 1.0));
            }
            if (LandUseComponent.this.woodland != null) {
                throw new Error("Woodlands not yet implemented");
            }
        }
    }
}

