% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npv_parity.R
\name{npv_parity}
\alias{npv_parity}
\title{Negative Predictive Value parity}
\usage{
npv_parity(
  data,
  outcome,
  group,
  probs = NULL,
  preds = NULL,
  outcome_base = NULL,
  cutoff = 0.5,
  base = NULL,
  group_breaks = NULL
)
}
\arguments{
\item{data}{Data.frame that contains the necessary columns.}

\item{outcome}{Column name indicating the binary outcome variable (character).}

\item{group}{Column name indicating the sensitive group (character).}

\item{probs}{Column name or vector with the predicted probabilities (numeric between 0 - 1). Either probs or preds need to be supplied.}

\item{preds}{Column name or vector with the predicted binary outcome (0 or 1). Either probs or preds need to be supplied.}

\item{outcome_base}{Base level of the outcome variable (i.e., negative class). Default is the first level of the outcome variable.}

\item{cutoff}{Cutoff to generate predicted outcomes from predicted probabilities. Default set to 0.5.}

\item{base}{Base level of the sensitive group (character).}

\item{group_breaks}{If group is continuous (e.g., age): either a numeric vector of two or more unique cut points or a single number >= 2 giving the number of intervals into which group feature is to be cut.}
}
\value{
\item{Metric}{Raw negative predictive values for all groups and metrics standardized for the base group (negative predictive value parity metric). Lower values compared to the reference group mean lower negative predictive values in the selected subgroups}
\item{Metric_plot}{Bar plot of Negative Predictive Value metric}
\item{Probability_plot}{Density plot of predicted probabilities per subgroup. Only plotted if probabilities are defined}
}
\description{
This function computes the Negative Predictive Value (NPV) parity metric

Formula: TN / (TN + FN)
}
\details{
This function computes the Negative Predictive Value (NPV) parity metric as described by the Aequitas bias toolkit.
Negative Predictive Values are calculated
by the division of true negatives with all predicted negatives. In the returned
named vector, the reference group will be assigned 1, while all other groups will be assigned values
according to whether their negative predictive values are lower or higher compared to the reference group. Lower
negative predictive values will be reflected in numbers lower than 1 in the returned named vector, thus numbers
lower than 1 mean WORSE prediction for the subgroup.
}
\examples{
data(compas)
compas$Two_yr_Recidivism_01 <- ifelse(compas$Two_yr_Recidivism == 'yes', 1, 0) 
npv_parity(data = compas, outcome = 'Two_yr_Recidivism_01', group = 'ethnicity',
probs = 'probability', cutoff = 0.4, base = 'Caucasian')
npv_parity(data = compas, outcome = 'Two_yr_Recidivism_01', group = 'ethnicity',
preds = 'predicted', cutoff = 0.5, base = 'Hispanic')

}
