% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/utilities_other.R
\name{logret}
\alias{logret}
\alias{logret.data.frame}
\alias{logret.matrix}
\title{Computes the log returns of a vector-valued time series}
\usage{
logret(dat, demean = FALSE, standardize = FALSE, ...)

\method{logret}{matrix}(dat, demean = FALSE, standardize = FALSE, ...)

\method{logret}{data.frame}(dat, ...)
}
\arguments{
\item{dat}{The raw data, a matrix with \code{n}
(number of timepoints) rows and \code{m}
(number of component series) columns.}

\item{demean}{Logical value indicating whether the data should
be de-meaned.}

\item{standardize}{Logical value indicating whether the data should
be standardized (in the sense that each component series has an empirical
variance equal to one).}

\item{...}{Ignored.}
}
\value{
Matrix containing the log returns of the (de-meaned)
data.
}
\description{
\code{logret} computes the log returns of a multivariate time
series, with optional de-meaning.
}
\section{Methods (by class)}{
\itemize{
\item \code{matrix}: (De-meaned) log returns

\item \code{data.frame}: (De-meaned) log returns
}}
\seealso{
fsvsample logret.matrix logret.data.frame
}

