% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorMergerClasses.R
\name{mergingHistory}
\alias{mergingHistory}
\title{Merging history}
\usage{
mergingHistory(factorMerger, showStats = FALSE, penalty, round = TRUE)
}
\arguments{
\item{factorMerger}{Object of a class \code{factorMerger}}

\item{showStats}{If \code{TRUE} extends results with
the loglikelihood (column \code{model}),
p-value for the \code{LRT} tests against the full model (column \code{pval})
and Generalized Information Criterion value (column \code{GIC}).
By default \code{showStats} is set to \code{FALSE}.}

\item{penalty}{GIC penalty}

\item{round}{Logical. If \code{TRUE}, the default, statistics are rounded}
}
\description{
Summarizes merging path by giving pairs of factor groups merged
in each iteration.
}
\examples{
randSample <- generateMultivariateSample(N = 100, k = 10, d = 3)
fm <- mergeFactors(randSample$response, randSample$factor)
mergingHistory(fm, showStats = TRUE)
}
