#' Breast cancer dataset
#'
#' A clinical dataset from The Cancer Genome Atlas Project from
#' the \code{RTCGA.clinical} package (\url{https://github.com/RTCGA/RTCGA.clinical}).
#' The variables are as follows:
#'
#' \itemize{
#'   \item times event time / censoring time
#'   \item bcr_patient_barcode patient code
#'   \item patient.vital_status patient status
#'   \item patient.drugs.drug.drug_name drug name given to the patient
#'   \item patient.clinical_cqcf.histological_type patient histological type
#'   \item patient.stage_event.tnm_categories.pathologic_categories.pathologic_t pathologic type
#' }
#'
#' @name BRCA
#' @docType data
#' @usage data(BRCA)
#' @keywords data
NULL


#' PISA 2012 dataset
#'
#' A dataset from \url{http://www.oecd.org/pisa/} about student performance in 2012.
#'
#' \itemize{
#'   \item PV1MATH student's performance (Mathematics)
#'   \item PV1READ student's performance (Reading)
#'   \item PV1SCIE student's performance (Science)
#'   \item CNT student's country
#'   \item OCOD1 parent's occupation
#' }
#'
#' @name pisa2012
#' @docType data
#' @usage data(pisa2012)
#' @keywords data
NULL
