\name{CA}
\alias{CA}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
function performing a Correspondence Analysis on a given data table or on (simulated) data streams.
}
\description{
This function permits user to perform fast Correspondence Analysis on (high dimensional on-line) data.  

Using stochastic processes, several estimation may be calculated depending on the user goals:
principal canonical factors, principal canonical axes, eigenvalues and correlation coefficients between the original
variables and the principal canonical factors can be computed and updated recursively.
 
Moreover, graphics may be printed in order to give a better visualization and meaning/interpretation of
the data. It's possible to get meaningful 2D visualizations: the observations are projected on the plans generated
 by direction vectors of the principal axes.  Correlation circles that show a
projection of the initial variables in the factors space are also available.
}
\usage{
CA(data, groups, stream=TRUE, nb_fact, principal_factors=TRUE, principal_axes=FALSE, 
eigenvalues=FALSE, corr=FALSE, graphics=FALSE, data_init, exec_time, print_step)
}

%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data}{
matrix : data to be analysed. The columns will represent the variables and 
the rows will represent the observations (sometimes called records, subjects or cases).
If you consider on-line data (\code{stream=TRUE}), of course all the observations are not available at the
beginning of the analysis. Thus, each observation (line of the matrix) will be treated 
individually (and then forgotten) to simulate the data stream.     
}
  \item{groups}{vector ( of dimension 2) : each component corresponds to the number (>1) of categories for each nominative variable.
}
  \item{stream}{
boolean : stream=TRUE if you consider data streams; stream=FALSE otherwise.
}
  \item{nb_fact}{
integer : number of elements to be calculated. For instance, if you need
 the three first principal canonical factors, nb_fact=3.
}
  \item{principal_factors}{ boolean : principal_factors=TRUE if you need the value of some first
principal canonical factors; principal_factors=FALSE otherwise.
}
  \item{principal_axes}{ boolean : principal_axes=TRUE if you need the value of some first
principal canonical axes; principal_axes=FALSE otherwise.
}
  \item{eigenvalues}{boolean : eigenvalues=TRUE if you need the value of some first
eigenvalues; eigenvalues=FALSE otherwise.
}
  \item{corr}{boolean : corr=TRUE if you need the value of correlation coefficient between the
original variables and some first principal canonical factors; corr=FALSE otherwise.
}
  \item{graphics}{
boolean : if graphics=TRUE, 2D visualizations will be plotted, representing
projections of the observations on all the plans generated by the \code{nb_fact} direction vectors
of the principal axes. If corr=TRUE, correlation circles that show a projection of the initial variables in the factors
spaces will also be plotted; if graphics=FALSE, no graphics will be plotted.


N.B. : For the fist kind of graphics, a gradation of grey was chosen to represent the "age" of the observations. The darker a point is, the newer the observation is. This coding
is meaningful for a data stream (stream=TRUE); if stream=FALSE, the "age" concept is less relevant: in this configuration, the darker a point is, the lower the observation is in
the matrix (database).  
}
  \item{data_init}{
integer : this argument is only relevant when stream=TRUE. It represents the number
of data used to intialize the analysis. It must be at least equal to the  number of columns of the dataset.
}
  \item{exec_time}{
real : execution time. If stream=TRUE, the analysis will stop when the first of
these two events happens: all the data were taken into account or execution time achieved. Otherwise (stream=FALSE), it's the execution time of \code{\link{CA_iter}}.
}
  \item{print_step}{
integer: this argument is only relevant when stream=TRUE. Each time that a new observation
is taken into account, a new estimation of the principal canonical factors (or principal canonical axes, ...) is computed but not
necessarily printed: it will be printed only every \code{print_step} observations.  
}
}
\details{

Reminding that CA is an analysis achieved on two groups of nominative variables only, we precise that the \code{CA} function computes the canonical elements
(principal factors, principal axes, ...) associated with the first group of nominative variables only. If the user needs the canonical elements associated with
the second group only, he may permute the two groups of variables before launching the analysis on that new dataset. If the user needs both canonical elements
associated with the two groups, an option is to launch the \code{\link{MCA}} function (generalization of the CA function
to more than two groups) on the dataset: indeed, \code{MCA} returns the general elements (principal factors, principal axes, ...) that are strongly linked to the canonical elements: for instance, if the two groups are respectively
composed of p and q variables, the principal canonical factors associated with the first (resp. second) group returned by the CA function are of length p (resp. q) whereas 
the principal general factors returned by the MCA function are of length p+q. The principal canonical factors associated with the first (resp. second) group are 
colinears to the vectors composed of the p first (resp. q last) components of the principal general factors.


}
\value{
 results that user needs (principal factors, principal axes, eigenvalues and correlation coefficients)
}
\references{
ACP projetée de données séquentielles, Monnez J-M., 42èmes Journées de Statistique (2010) 
}
\author{
BAR Romain, Université de Lorraine, IECL, Université de Lorraine, INRIA : BIGS group.
}

\seealso{ 
\code{\link{CA_iter}},
\code{\link{MCA}},
\code{\link{MCA_iter}}
}

\examples{

data(tea)
the<-cbind(tea[,18],tea[,21])
CA(rbind(the,the,the),c(6,7),stream=TRUE,3,principal_factors=TRUE,
principal_axes=TRUE,eigenvalues=TRUE,corr=TRUE,graphics=TRUE,200,1,10)
CA(rbind(the,the,the),c(6,7),TRUE,3,TRUE,TRUE,TRUE,TRUE,TRUE,200,1,10)

}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{correspondence analysis}

