% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irf.R
\name{IRF}
\alias{IRF}
\title{Compute Impulse Response Function (IRF)}
\usage{
IRF(x, ...)
}
\arguments{
\item{x}{A fitted model object, such as from a VAR or ARIMA model. This model is used to compute the impulse response.}

\item{...}{Additional arguments to be passed to lower-level functions.}
}
\description{
This function calculates the impulse response function (IRF) of a time series model.
The IRF describes how a model's variables react to external shocks over time.
}
\details{
If \code{new_data} contains the \code{.impulse} column, those values will be
treated as impulses for the calculated impulse responses.

The impulse response function provides insight into the dynamic behaviour of a system in
response to external shocks. It traces the effect of a one-unit change in the impulse
variable on the response variable over a specified number of periods.
}
