% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00-utils.R
\name{make_name_list}
\alias{make_name_list}
\title{Shortcut to create beautiful names in a list}
\usage{
make_name_list(args_list, list_elem)
}
\arguments{
\item{args_list}{A list of character string of same length of list_elem}

\item{list_elem}{A list of character string of same length of args_list}
}
\value{
A character string simplified to be used as names in a list.
}
\description{
Generate a name for an element in a list. This function is targeted for
functions creations which handle lists. Those lists may need names to go
through each elements. This function can works with \code{\link[stats:setNames]{stats::setNames()}} and
allows the user to provide name shorter, more user-friendly in their lists.
}
\examples{
{

library(tidyr)
library(magrittr)

#### Example 1 --------------------------------------------------------------
# make_name_list generates names that are informative through a line of code
# or function. tibble(iris), iris \%>\% tibble and
# list(iris = tibble(mytibble) \%>\% select(Species)) will have 'iris' as name.

list(tibble(iris), tibble(mtcars)) \%>\%
  setNames(make_name_list(list(tibble(iris), tibble(mtcars)), args_list =
    c("IRIS \%>\% complicated_code","complicated_function(MTCARS)")))

#### Example 2 --------------------------------------------------------------
# make_name_list can be used when a function uses arguments provided by the
# user to generate a list. The name is simplified and given to the list
# itself

library(dplyr)
my_function <- function(df){

  .fargs <- as.list(match.call(expand.dots = TRUE))
  list_df <-
    list(df) \%>\%
    stats::setNames(.,make_name_list(as.character(.fargs['df']),list(df)))
  return(list_df)}

my_function(tibble(iris))
my_function(iris \%>\% tibble \%>\% select(Species))

}

}
\seealso{
\code{\link[stats:setNames]{stats::setNames()}}
}
