% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SHASH.R
\name{SHASH_to_normal}
\alias{SHASH_to_normal}
\title{SHASH to normal data transformation}
\usage{
SHASH_to_normal(x, mu, sigma, nu, tau, inverse = FALSE)
}
\arguments{
\item{x}{Numeric vector of data to transform.}

\item{mu}{Parameter that modulates the mean of \code{x}.}

\item{sigma}{Parameter that modulates the variance of \code{x}.
Must be greater than zero. This parameter is on the logarithm scale.}

\item{nu}{Parameter that modulates the skewness of \code{x}.}

\item{tau}{Parameter that modulates the tailweight of \code{x}.
Must be greater than zero. This parameter is on the logarithm scale.}

\item{inverse}{Transform normal data to SHASH instead? Default: \code{FALSE}.}
}
\value{
The transformed data.
}
\description{
Transform SHASH-distributed data to normal-distributed data.
}
