% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/artifact_images.R
\name{artifact_images}
\alias{artifact_images}
\title{Artifact images}
\usage{
artifact_images(psx, idx = NULL, use_dt = TRUE)
}
\arguments{
\item{psx}{A \code{"scrub_projection"} object containing projection scrubbing
results.}

\item{idx}{The timepoints or column indexes for which to compute artifact
images. If \code{NULL} (default), use the outlying timepoints.}

\item{use_dt}{If detrended components are available (the "U" matrix of PCA
or "M" matrix of ICA), should they be used to compute the artifact images?
Otherwise, use the non-detrended components. Default: \code{TRUE}.}
}
\value{
A list of three: \code{idx}, the timepoints for which the artifact images
were computed; \code{mean}, the "mean" artifact images; and \code{top}, the
"top" artifact images. The row names of the \code{top} artifact images
matrix give the index of the top component ("V" in PCA and "S" in ICA) at
each timepoint.
}
\description{
Visualize artifact patterns from the results of \code{\link{pscrub}}.
Requires \code{pscrub(..., get_dirs=TRUE)}.
}
\details{
Computes two types: "mean" artifact images based on a weighted sum of the
projection directions, with weights determined by the scores for each
component at the flagged timepoint, and "top" artifact images based on the
projection direction with the greatest score at the flagged timepoint.
}
