% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fHMM_likelihood.R
\name{ll_hmm}
\alias{ll_hmm}
\title{Log-likelihood function of an (H)HMM}
\usage{
ll_hmm(
  parUncon,
  observations,
  controls = list(),
  hierarchy = FALSE,
  states = if (!hierarchy) 2 else c(2, 2),
  sdds = if (!hierarchy) "normal" else c("normal", "normal"),
  negative = FALSE,
  check_controls = TRUE
)
}
\arguments{
\item{parUncon}{An object of class \code{parUncon}, which is a \code{numeric} \code{vector}
with identified and unconstrained model parameters in the following order:
\enumerate{
\item non-diagonal transition probabilities \code{gammasUncon}
\item expectations \code{muUncon}
\item standard deviations \code{sigmaUncon} (if any)
\item degrees of freedom \code{dfUncon} (if any)
\item fine-scale parameters for each coarse-scale state, in the same order (if any)
}}

\item{observations}{A \code{numeric} \code{vector} of time-series data.

In the hierarchical case (\code{hierarchy = TRUE}), a \code{matrix} with
coarse-scale data in the first column and corresponding fine-scale data in
the rows.}

\item{controls}{Either a \code{list} or an object of class \code{fHMM_controls}.

The \code{list} can contain the following elements, which are described
in more detail below:
\itemize{
\item \code{hierarchy}, defines an hierarchical HMM,
\item \code{states}, defines the number of states,
\item \code{sdds}, defines the state-dependent distributions,
\item \code{horizon}, defines the time horizon,
\item \code{period}, defines a flexible, periodic fine-scale time horizon,
\item \code{data}, a \code{list} of controls that define the data,
\item \code{fit}, a \code{list} of controls that define the model fitting
}
Either none, all, or selected elements can be specified.

Unspecified parameters are set to their default values, see below.

Specifications in \code{controls} override individual specifications.}

\item{hierarchy}{A \code{logical}, set to \code{TRUE} for an hierarchical HMM.

If \code{hierarchy = TRUE}, some of the other controls must be specified for
the coarse-scale and the fine-scale layer.

By default, \code{hierarchy = FALSE}.}

\item{states}{An \code{integer}, the number of states of the underlying Markov chain.

If \code{hierarchy = TRUE}, \code{states} must be a \code{vector} of length
2. The first entry corresponds to the coarse-scale layer, while the second
entry corresponds to the fine-scale layer.

By default, \code{states = 2} if \code{hierarchy = FALSE} and
\code{states = c(2, 2)} if \code{hierarchy = TRUE}.}

\item{sdds}{A \code{character}, specifying the state-dependent distribution. One of
\itemize{
\item \code{"normal"} (the normal distribution),
\item \code{"lognormal"} (the log-normal distribution),
\item \code{"t"} (the t-distribution),
\item \code{"gamma"} (the gamma distribution),
\item \code{"poisson"} (the Poisson distribution).
}

The distribution parameters, i.e. the
\itemize{
\item mean \code{mu},
\item standard deviation \code{sigma} (not for the Poisson distribution),
\item degrees of freedom \code{df} (only for the t-distribution),
}
can be fixed via, e.g., \code{"t(df = 1)"} or
\code{"gamma(mu = 0, sigma = 1)"}.
To fix different values of a parameter for different states, separate by
"|", e.g. \code{"poisson(mu = 1|2|3)"}.

If \code{hierarchy = TRUE}, \code{sdds} must be a \code{vector} of length 2.
The first entry corresponds to the coarse-scale layer, while the second entry
corresponds to the fine-scale layer.

By default, \code{sdds = "normal"} if \code{hierarchy = FALSE} and
\code{sdds = c("normal", "normal")} if \code{hierarchy = TRUE}.}

\item{negative}{Either \code{TRUE} to return the negative log-likelihood value (useful for
optimization) or \code{FALSE} (default), else.}

\item{check_controls}{Either \code{TRUE} to check the defined controls or \code{FALSE} to not check
them (which saves computation time), else.}
}
\value{
The (negative) log-likelihood value.
}
\description{
This function computes the log-likelihood value of a (hierarchical) hidden
Markov model for given observations and parameter values.
}
\examples{
### HMM log-likelihood 
controls <- set_controls(states = 2, sdds = "normal")
parameters <- fHMM_parameters(controls)
parUncon <- par2parUncon(parameters, controls)
observations <- 1:10
ll_hmm(parUncon, observations, controls)

### HHMM log-likelihood 
controls <- set_controls(
  hierarchy = TRUE, states = c(2, 2), sdds = c("normal", "normal")
)
parameters <- fHMM_parameters(controls)
parUncon <- par2parUncon(parameters, controls)
observations <- matrix(dnorm(110), ncol = 11, nrow = 10)
ll_hmm(parUncon, observations, controls)

}
