
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU Library General 
# Public License along with this library; if not, write to the 
# Free Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
# MA  02111-1307  USA

# Copyrights (C)
# for this R-port: 
#   1999 - 2007, Diethelm Wuertz, GPL
#   Diethelm Wuertz <wuertz@itp.phys.ethz.ch>
#   info@rmetrics.org
#   www.rmetrics.org
# for the code accessed (or partly included) from other R-ports:
#   see R's copyright and license files
# for the code accessed (or partly included) from contributed R-ports
# and other sources
#   see Rmetrics's copyright file


################################################################################
# The following DST Rules were extracted from Libical library and 
# integrated into R functions. 
# Libical is an Open Source implementation of the iCalendar protocols
# and protocol data units.
# The code and datafiles are licensed under the terms of the GNU 
# Library General Public License. 
################################################################################


# AFRICA -----------------------------------------------------------------------


"Algiers" = 
function() {
structure(list(Algiers = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13, 14, NA, 15, 16, NA, 17, 18, 19, NA, 
20, 21, 22, NA, 23, NA, 24, 25, NA, 26, NA)), 
.Label = c(                                   "1911-03-10 23:50:39", 
"1916-06-14 23:00:00", "1916-10-01 23:00:00", "1917-03-24 23:00:00", 
"1917-10-07 23:00:00", "1918-03-09 23:00:00", "1918-10-06 23:00:00", 
"1919-03-01 23:00:00", "1919-10-05 23:00:00", "1920-02-14 23:00:00", 
"1920-10-23 23:00:00", "1921-03-14 23:00:00", "1921-06-21 23:00:00", 
"1939-09-11 23:00:00", "1940-02-25 02:00:00", "1944-04-03 01:00:00", 
"1945-04-02 01:00:00", "1945-09-15 23:00:00", "1946-10-06 23:00:00", 
"1963-04-13 23:00:00", "1971-04-25 23:00:00", "1971-09-26 23:00:00", 
"1977-10-20 23:00:00", "1978-09-22 01:00:00", "1979-10-25 23:00:00", 
"1980-10-31 01:00:00"), class = "factor"), offSet = c(0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
7200, 3600, 7200, 3600, 0, 3600, 0, 3600, 0, 3600, 3600, 7200, 
3600, 0, 3600, 0, 3600)), .Names = c("Algiers", "offSet"), row.names = c("1", 
"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
"14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
"25", "26", "27", "28", "29", "30", "31", "32", "33"), class = "data.frame") }


"Cairo" = 
function() {
structure(list(Cairo = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, NA, 18, NA, 19, NA, 
20, NA, 21, NA, 22, NA, 23, NA, 24, NA, 25, NA, 26, NA, 27, NA, 
28, NA, 29, NA, 30, NA, 31, NA, 32, NA, 33, NA, 34, NA, 35, NA, 
36, NA, 37, NA, 38, NA, 39, NA, 40, NA, 41, NA, 42, NA, 43, NA, 
44, NA, 45, NA, 46, NA, 47, NA, 48, NA, 49, NA, 50, NA, 51, NA, 
52, NA, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 
67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 
83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 
99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 
112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124
)), .Label = c("1940-07-14 22:00:00", "1940-09-30 21:00:00", 
"1941-04-14 22:00:00", "1941-09-15 21:00:00", "1942-03-31 22:00:00", 
"1942-10-26 21:00:00", "1943-03-31 22:00:00", "1943-10-31 21:00:00", 
"1944-03-31 22:00:00", "1944-10-31 21:00:00", "1945-04-15 22:00:00", 
"1945-10-31 21:00:00", "1957-05-09 22:00:00", "1957-09-30 21:00:00", 
"1958-04-30 22:00:00", "1958-09-30 21:00:00", "1959-04-30 23:00:00", 
"1960-04-30 23:00:00", "1961-04-30 23:00:00", "1962-04-30 23:00:00", 
"1963-04-30 23:00:00", "1964-04-30 23:00:00", "1965-04-30 23:00:00", 
"1966-04-30 23:00:00", "1967-04-30 23:00:00", "1968-04-30 23:00:00", 
"1969-04-30 23:00:00", "1970-04-30 23:00:00", "1971-04-30 23:00:00", 
"1972-04-30 23:00:00", "1973-04-30 23:00:00", "1974-04-30 23:00:00", 
"1975-04-30 23:00:00", "1976-04-30 23:00:00", "1977-04-30 23:00:00", 
"1978-04-30 23:00:00", "1979-04-30 23:00:00", "1980-04-30 23:00:00", 
"1981-04-30 23:00:00", "1982-07-24 23:00:00", "1983-07-11 23:00:00", 
"1984-04-30 23:00:00", "1985-04-30 23:00:00", "1986-04-30 23:00:00", 
"1987-04-30 23:00:00", "1988-04-30 23:00:00", "1989-05-05 23:00:00", 
"1990-04-30 23:00:00", "1991-04-30 23:00:00", "1992-04-30 23:00:00", 
"1993-04-30 23:00:00", "1994-04-30 23:00:00", "1995-04-27 22:00:00", 
"1995-09-28 21:00:00", "1996-04-25 22:00:00", "1996-09-26 21:00:00", 
"1997-04-24 22:00:00", "1997-09-25 21:00:00", "1998-04-23 22:00:00", 
"1998-09-24 21:00:00", "1999-04-29 22:00:00", "1999-09-30 21:00:00", 
"2000-04-27 22:00:00", "2000-09-28 21:00:00", "2001-04-26 22:00:00", 
"2001-09-27 21:00:00", "2002-04-25 22:00:00", "2002-09-26 21:00:00", 
"2003-04-24 22:00:00", "2003-09-25 21:00:00", "2004-04-29 22:00:00", 
"2004-09-30 21:00:00", "2005-04-28 22:00:00", "2005-09-29 21:00:00", 
"2006-04-27 22:00:00", "2006-09-28 21:00:00", "2007-04-26 22:00:00", 
"2007-09-27 21:00:00", "2008-04-24 22:00:00", "2008-09-25 21:00:00", 
"2009-04-23 22:00:00", "2009-09-24 21:00:00", "2010-04-29 22:00:00", 
"2010-09-30 21:00:00", "2011-04-28 22:00:00", "2011-09-29 21:00:00", 
"2012-04-26 22:00:00", "2012-09-27 21:00:00", "2013-04-25 22:00:00", 
"2013-09-26 21:00:00", "2014-04-24 22:00:00", "2014-09-25 21:00:00", 
"2015-04-23 22:00:00", "2015-09-24 21:00:00", "2016-04-28 22:00:00", 
"2016-09-29 21:00:00", "2017-04-27 22:00:00", "2017-09-28 21:00:00", 
"2018-04-26 22:00:00", "2018-09-27 21:00:00", "2019-04-25 22:00:00", 
"2019-09-26 21:00:00", "2020-04-23 22:00:00", "2020-09-24 21:00:00", 
"2021-04-29 22:00:00", "2021-09-30 21:00:00", "2022-04-28 22:00:00", 
"2022-09-29 21:00:00", "2023-04-27 22:00:00", "2023-09-28 21:00:00", 
"2024-04-25 22:00:00", "2024-09-26 21:00:00", "2025-04-24 22:00:00", 
"2025-09-25 21:00:00", "2026-04-23 22:00:00", "2026-09-24 21:00:00", 
"2027-04-29 22:00:00", "2027-09-30 21:00:00", "2028-04-27 22:00:00", 
"2028-09-28 21:00:00", "2029-04-26 22:00:00", "2029-09-27 21:00:00", 
"2030-04-25 22:00:00", "2030-09-26 21:00:00"), class = "factor"), 
offSet = c(10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200)), 
.Names = c("Cairo", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", 
"9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
"20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", 
"31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", 
"42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", 
"53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", 
"64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", 
"75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", 
"86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", 
"97", "98", "99", "100", "101", "102", "103", "104", "105", "106", 
"107", "108", "109", "110", "111", "112", "113", "114", "115", 
"116", "117", "118", "119", "120", "121", "122", "123", "124", 
"125", "126", "127", "128", "129", "130", "131", "132", "133", 
"134", "135", "136", "137", "138", "139", "140", "141", "142", 
"143", "144", "145", "146", "147", "148", "149", "150", "151", 
"152", "153", "154", "155", "156", "157", "158", "159", "160"
), class = "data.frame") }


"Casablanca" = 
function() {
structure(list(Casablanca = structure(as.integer(c(NA, 1, NA, 
2, NA, 3, 4, 5, NA, 6, NA, 7, NA, 8, NA, 9, NA, 10)), .Label = c(                                   
"1939-11-18 23:00:00", 
"1945-11-17 23:00:00", "1950-10-28 23:00:00", "1967-06-03 12:00:00", 
"1967-09-30 23:00:00", "1974-08-31 23:00:00", "1976-07-31 23:00:00", 
"1977-09-27 23:00:00", "1978-08-03 23:00:00", "1985-12-31 23:00:00"
), class = "factor"), offSet = c(3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0)), .Names = c("Casablanca", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", 
"9", "10", "11", "12", "13", "14", "15", "16", "17", "18"), 
class = "data.frame") }


"Johannesburg" = 
function() {
structure(list(Johannesburg = structure(as.integer(c(1, NA, 2, 
NA, 3)), .Label = c("1903-02-28 22:30:00", "1943-03-20 23:00:00", 
"1944-03-18 23:00:00"), class = "factor"), offSet = c(7200, 10800, 
7200, 10800, 7200)), .Names = c("Johannesburg", "offSet"), row.names = c("1", 
"2", "3", "4", "5"), class = "data.frame") }


"Lagos" = 
function() {
structure(list(Lagos = structure(as.integer(1), .Label = "1919-08-31 23:46:24", 
class = "factor"), offSet = 3600), .Names = c("Lagos", "offSet"), 
row.names = "1", class = "data.frame") }


"Nairobi" = 
function() {
structure(list(Nairobi = structure(as.integer(c(1, 2, 3)), .Label = 
c("1929-12-31 21:00:00", "1939-12-31 21:30:00", "1959-12-31 21:15:00"), 
class = "factor"), offSet = c(9000, 9900, 10800)), .Names = c("Nairobi", 
"offSet"), row.names = c("1", "2", "3"), class = "data.frame") }


"Tunis" = 
function() { 
structure(list(Tunis = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, NA, 9, NA, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
21, 22, 23)), .Label = c("1911-03-10 23:50:39", "1939-04-15 22:00:00", 
"1939-11-18 22:00:00", "1940-02-25 22:00:00", "1941-10-05 22:00:00", 
"1942-03-08 23:00:00", "1942-11-02 01:00:00", "1943-03-29 01:00:00", 
"1943-04-25 01:00:00", "1944-04-03 01:00:00", "1944-10-07 22:00:00", 
"1945-04-02 01:00:00", "1945-09-15 22:00:00", "1977-04-29 23:00:00", 
"1977-09-23 23:00:00", "1978-04-30 23:00:00", "1978-09-30 23:00:00", 
"1988-05-31 23:00:00", "1988-09-24 23:00:00", "1989-03-25 23:00:00", 
"1989-09-23 23:00:00", "1990-04-30 23:00:00", "1990-09-29 23:00:00"
), class = "factor"), offSet = c(3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600)), .Names = c("Tunis", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", 
"9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
"20", "21", "22", "23", "24", "25"), class = "data.frame") }


# AMERICA ----------------------------------------------------------------------


"Anchorage" = 
function() {
structure(list(Anchorage = structure(as.integer(c(1, 2, 3, 4, 
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 
38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 
54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
127, 128, 129, 130, 131, 132)), .Label = c("1900-08-20 21:59:36", 
"1942-01-01 10:00:00", "1942-02-09 12:00:00", "1945-08-14 23:00:00", 
"1945-09-30 11:00:00", "1946-01-01 10:00:00", "1967-04-01 10:00:00", 
"1969-01-01 10:00:00", "1969-04-27 12:00:00", "1969-10-26 11:00:00", 
"1970-04-26 12:00:00", "1970-10-25 11:00:00", "1971-04-25 12:00:00", 
"1971-10-31 11:00:00", "1972-04-30 12:00:00", "1972-10-29 11:00:00", 
"1973-04-29 12:00:00", "1973-10-28 11:00:00", "1974-01-06 12:00:00", 
"1974-10-27 11:00:00", "1975-02-23 12:00:00", "1975-10-26 11:00:00", 
"1976-04-25 12:00:00", "1976-10-31 11:00:00", "1977-04-24 12:00:00", 
"1977-10-30 11:00:00", "1978-04-30 12:00:00", "1978-10-29 11:00:00", 
"1979-04-29 12:00:00", "1979-10-28 11:00:00", "1980-04-27 12:00:00", 
"1980-10-26 11:00:00", "1981-04-26 12:00:00", "1981-10-25 11:00:00", 
"1982-04-25 12:00:00", "1982-10-31 11:00:00", "1983-04-24 12:00:00", 
"1983-10-30 11:00:00", "1984-04-29 11:00:00", "1984-10-28 10:00:00", 
"1985-04-28 11:00:00", "1985-10-27 10:00:00", "1986-04-27 11:00:00", 
"1986-10-26 10:00:00", "1987-04-05 11:00:00", "1987-10-25 10:00:00", 
"1988-04-03 11:00:00", "1988-10-30 10:00:00", "1989-04-02 11:00:00", 
"1989-10-29 10:00:00", "1990-04-01 11:00:00", "1990-10-28 10:00:00", 
"1991-04-07 11:00:00", "1991-10-27 10:00:00", "1992-04-05 11:00:00", 
"1992-10-25 10:00:00", "1993-04-04 11:00:00", "1993-10-31 10:00:00", 
"1994-04-03 11:00:00", "1994-10-30 10:00:00", "1995-04-02 11:00:00", 
"1995-10-29 10:00:00", "1996-04-07 11:00:00", "1996-10-27 10:00:00", 
"1997-04-06 11:00:00", "1997-10-26 10:00:00", "1998-04-05 11:00:00", 
"1998-10-25 10:00:00", "1999-04-04 11:00:00", "1999-10-31 10:00:00", 
"2000-04-02 11:00:00", "2000-10-29 10:00:00", "2001-04-01 11:00:00", 
"2001-10-28 10:00:00", "2002-04-07 11:00:00", "2002-10-27 10:00:00", 
"2003-04-06 11:00:00", "2003-10-26 10:00:00", "2004-04-04 11:00:00", 
"2004-10-31 10:00:00", "2005-04-03 11:00:00", "2005-10-30 10:00:00", 
"2006-04-02 11:00:00", "2006-10-29 10:00:00", "2007-04-01 11:00:00", 
"2007-10-28 10:00:00", "2008-04-06 11:00:00", "2008-10-26 10:00:00", 
"2009-04-05 11:00:00", "2009-10-25 10:00:00", "2010-04-04 11:00:00", 
"2010-10-31 10:00:00", "2011-04-03 11:00:00", "2011-10-30 10:00:00", 
"2012-04-01 11:00:00", "2012-10-28 10:00:00", "2013-04-07 11:00:00", 
"2013-10-27 10:00:00", "2014-04-06 11:00:00", "2014-10-26 10:00:00", 
"2015-04-05 11:00:00", "2015-10-25 10:00:00", "2016-04-03 11:00:00", 
"2016-10-30 10:00:00", "2017-04-02 11:00:00", "2017-10-29 10:00:00", 
"2018-04-01 11:00:00", "2018-10-28 10:00:00", "2019-04-07 11:00:00", 
"2019-10-27 10:00:00", "2020-04-05 11:00:00", "2020-10-25 10:00:00", 
"2021-04-04 11:00:00", "2021-10-31 10:00:00", "2022-04-03 11:00:00", 
"2022-10-30 10:00:00", "2023-04-02 11:00:00", "2023-10-29 10:00:00", 
"2024-04-07 11:00:00", "2024-10-27 10:00:00", "2025-04-06 11:00:00", 
"2025-10-26 10:00:00", "2026-04-05 11:00:00", "2026-10-25 10:00:00", 
"2027-04-04 11:00:00", "2027-10-31 10:00:00", "2028-04-02 11:00:00", 
"2028-10-29 10:00:00", "2029-04-01 11:00:00", "2029-10-28 10:00:00", 
"2030-04-07 11:00:00", "2030-10-27 10:00:00"), class = "factor"), 
offSet = c(-36000, -36000, -32400, -32400, -36000, -36000, 
-36000, -36000, -32400, -36000, -32400, -36000, -32400, -36000, 
-32400, -36000, -32400, -36000, -32400, -36000, -32400, -36000, 
-32400, -36000, -32400, -36000, -32400, -36000, -32400, -36000, 
-32400, -36000, -32400, -36000, -32400, -36000, -32400, -32400, 
-28800, -32400, -28800, -32400, -28800, -32400, -28800, -32400, 
-28800, -32400, -28800, -32400, -28800, -32400, -28800, -32400, 
-28800, -32400, -28800, -32400, -28800, -32400, -28800, -32400, 
-28800, -32400, -28800, -32400, -28800, -32400, -28800, -32400, 
-28800, -32400, -28800, -32400, -28800, -32400, -28800, -32400, 
-28800, -32400, -28800, -32400, -28800, -32400, -28800, -32400, 
-28800, -32400, -28800, -32400, -28800, -32400, -28800, -32400, 
-28800, -32400, -28800, -32400, -28800, -32400, -28800, -32400, 
-28800, -32400, -28800, -32400, -28800, -32400, -28800, -32400, 
-28800, -32400, -28800, -32400, -28800, -32400, -28800, -32400, 
-28800, -32400, -28800, -32400, -28800, -32400, -28800, -32400, 
-28800, -32400, -28800, -32400, -28800, -32400)), .Names = c("Anchorage", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", 
"9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
"20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", 
"31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", 
"42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", 
"53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", 
"64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", 
"75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", 
"86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", 
"97", "98", "99", "100", "101", "102", "103", "104", "105", "106", 
"107", "108", "109", "110", "111", "112", "113", "114", "115", 
"116", "117", "118", "119", "120", "121", "122", "123", "124", 
"125", "126", "127", "128", "129", "130", "131", "132"), class = "data.frame") }


"Bogota" = 
function() {
structure(list(Bogota = structure(as.integer(c(1, 2, 3)), 
.Label = c("1914-11-23 04:56:20", "1992-05-02 05:00:00", 
"1992-12-31 04:00:00"), class = "factor"), offSet = c(-18000, -14400, -18000)), 
.Names = c("Bogota", "offSet"), row.names = c("1", "2", "3"), 
class = "data.frame") }


"BuenosAires" = 
function() {
structure(list(BuenosAires = structure(as.integer(c(1, 2, 3, 
4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 
37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 
53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68
)), .Label = c("1920-05-01 04:16:44", "1930-12-01 04:00:00", 
"1931-04-01 03:00:00", "1931-10-15 04:00:00", "1932-03-01 03:00:00", 
"1932-11-01 04:00:00", "1933-03-01 03:00:00", "1933-11-01 04:00:00", 
"1934-03-01 03:00:00", "1934-11-01 04:00:00", "1935-03-01 03:00:00", 
"1935-11-01 04:00:00", "1936-03-01 03:00:00", "1936-11-01 04:00:00", 
"1937-03-01 03:00:00", "1937-11-01 04:00:00", "1938-03-01 03:00:00", 
"1938-11-01 04:00:00", "1939-03-01 03:00:00", "1939-11-01 04:00:00", 
"1940-03-01 03:00:00", "1940-07-01 04:00:00", "1941-06-15 03:00:00", 
"1941-10-15 04:00:00", "1943-08-01 03:00:00", "1943-10-15 04:00:00", 
"1946-03-01 03:00:00", "1946-10-01 04:00:00", "1963-10-01 03:00:00", 
"1963-12-15 04:00:00", "1964-03-01 03:00:00", "1964-10-15 04:00:00", 
"1965-03-01 03:00:00", "1965-10-15 04:00:00", "1966-03-01 03:00:00", 
"1966-10-15 04:00:00", "1967-04-01 03:00:00", "1967-10-01 04:00:00", 
"1968-04-07 03:00:00", "1968-10-06 04:00:00", "1969-04-06 03:00:00", 
"1969-10-05 04:00:00", "1974-01-23 03:00:00", "1974-05-01 02:00:00", 
"1974-10-06 03:00:00", "1975-04-06 02:00:00", "1975-10-05 03:00:00", 
"1976-04-04 02:00:00", "1976-10-03 03:00:00", "1977-04-03 02:00:00", 
"1985-11-02 03:00:00", "1986-03-14 02:00:00", "1986-10-25 03:00:00", 
"1987-02-13 02:00:00", "1987-10-25 03:00:00", "1988-02-07 02:00:00", 
"1988-12-01 03:00:00", "1989-03-05 02:00:00", "1989-10-15 03:00:00", 
"1990-03-04 02:00:00", "1990-10-21 03:00:00", "1991-03-03 02:00:00", 
"1991-10-20 03:00:00", "1992-03-01 02:00:00", "1992-10-18 03:00:00", 
"1993-03-07 02:00:00", "1999-10-03 03:00:00", "2000-03-03 03:00:00"
), class = "factor"), offSet = c(-14400, -10800, -14400, -10800, 
-14400, -10800, -14400, -10800, -14400, -10800, -14400, -10800, 
-14400, -10800, -14400, -10800, -14400, -10800, -14400, -10800, 
-14400, -10800, -14400, -10800, -14400, -10800, -14400, -10800, 
-14400, -10800, -14400, -10800, -14400, -10800, -14400, -10800, 
-14400, -10800, -14400, -10800, -14400, -10800, -7200, -10800, 
-7200, -10800, -7200, -10800, -7200, -10800, -7200, -10800, -7200, 
-10800, -7200, -10800, -7200, -10800, -7200, -10800, -7200, -10800, 
-7200, -10800, -7200, -10800, -10800, -10800)), .Names = c("Buenos_Aires", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", 
"9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
"20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", 
"31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", 
"42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", 
"53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", 
"64", "65", "66", "67", "68"), class = "data.frame") }


"Caracas" = 
function() {
structure(list(Caracas = structure(as.integer(c(1, 2)), .Label = 
c("1912-02-12 04:27:44", "1965-01-01 04:30:00"), class = "factor"), 
offSet = c(-16200, -14400)), .Names = c("Caracas", "offSet"), 
row.names = c("1", "2"), class = "data.frame") }


"Cayman" = 
function() {
structure(list(Cayman = structure(as.integer(1), .Label = 
"1912-02-01 05:07:12", class = "factor"), offSet = -18000), 
.Names = c("Cayman", "offSet"), row.names = "1", class = "data.frame") }


"Chicago" = 
function() {
structure(list(Chicago = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 
71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 
193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 
206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 
219, 220, 221, 222, 223, 224, 225)), .Label = c("1918-03-31 08:00:00", 
"1918-10-27 07:00:00", "1919-03-30 08:00:00", "1919-10-26 07:00:00", 
"1920-01-01 06:00:00", "1920-06-13 08:00:00", "1920-10-31 07:00:00", 
"1921-03-27 08:00:00", "1921-10-30 07:00:00", "1922-04-30 08:00:00", 
"1922-09-24 07:00:00", "1923-04-29 08:00:00", "1923-09-30 07:00:00", 
"1924-04-27 08:00:00", "1924-09-28 07:00:00", "1925-04-26 08:00:00", 
"1925-09-27 07:00:00", "1926-04-25 08:00:00", "1926-09-26 07:00:00", 
"1927-04-24 08:00:00", "1927-09-25 07:00:00", "1928-04-29 08:00:00", 
"1928-09-30 07:00:00", "1929-04-28 08:00:00", "1929-09-29 07:00:00", 
"1930-04-27 08:00:00", "1930-09-28 07:00:00", "1931-04-26 08:00:00", 
"1931-09-27 07:00:00", "1932-04-24 08:00:00", "1932-09-25 07:00:00", 
"1933-04-30 08:00:00", "1933-09-24 07:00:00", "1934-04-29 08:00:00", 
"1934-09-30 07:00:00", "1935-04-28 08:00:00", "1935-09-29 07:00:00", 
"1936-03-01 08:00:00", "1936-11-15 07:00:00", "1937-04-25 08:00:00", 
"1937-09-26 07:00:00", "1938-04-24 08:00:00", "1938-09-25 07:00:00", 
"1939-04-30 08:00:00", "1939-09-24 07:00:00", "1940-04-28 08:00:00", 
"1940-09-29 07:00:00", "1941-04-27 08:00:00", "1941-09-28 07:00:00", 
"1942-01-01 06:00:00", "1942-02-09 08:00:00", "1945-08-14 23:00:00", 
"1945-09-30 07:00:00", "1946-01-01 06:00:00", "1946-04-28 08:00:00", 
"1946-09-29 07:00:00", "1947-04-27 08:00:00", "1947-09-28 07:00:00", 
"1948-04-25 08:00:00", "1948-09-26 07:00:00", "1949-04-24 08:00:00", 
"1949-09-25 07:00:00", "1950-04-30 08:00:00", "1950-09-24 07:00:00", 
"1951-04-29 08:00:00", "1951-09-30 07:00:00", "1952-04-27 08:00:00", 
"1952-09-28 07:00:00", "1953-04-26 08:00:00", "1953-09-27 07:00:00", 
"1954-04-25 08:00:00", "1954-09-26 07:00:00", "1955-04-24 08:00:00", 
"1955-10-30 07:00:00", "1956-04-29 08:00:00", "1956-10-28 07:00:00", 
"1957-04-28 08:00:00", "1957-10-27 07:00:00", "1958-04-27 08:00:00", 
"1958-10-26 07:00:00", "1959-04-26 08:00:00", "1959-10-25 07:00:00", 
"1960-04-24 08:00:00", "1960-10-30 07:00:00", "1961-04-30 08:00:00", 
"1961-10-29 07:00:00", "1962-04-29 08:00:00", "1962-10-28 07:00:00", 
"1963-04-28 08:00:00", "1963-10-27 07:00:00", "1964-04-26 08:00:00", 
"1964-10-25 07:00:00", "1965-04-25 08:00:00", "1965-10-31 07:00:00", 
"1966-04-24 08:00:00", "1966-10-30 07:00:00", "1967-01-01 06:00:00", 
"1967-04-30 08:00:00", "1967-10-29 07:00:00", "1968-04-28 08:00:00", 
"1968-10-27 07:00:00", "1969-04-27 08:00:00", "1969-10-26 07:00:00", 
"1970-04-26 08:00:00", "1970-10-25 07:00:00", "1971-04-25 08:00:00", 
"1971-10-31 07:00:00", "1972-04-30 08:00:00", "1972-10-29 07:00:00", 
"1973-04-29 08:00:00", "1973-10-28 07:00:00", "1974-01-06 08:00:00", 
"1974-10-27 07:00:00", "1975-02-23 08:00:00", "1975-10-26 07:00:00", 
"1976-04-25 08:00:00", "1976-10-31 07:00:00", "1977-04-24 08:00:00", 
"1977-10-30 07:00:00", "1978-04-30 08:00:00", "1978-10-29 07:00:00", 
"1979-04-29 08:00:00", "1979-10-28 07:00:00", "1980-04-27 08:00:00", 
"1980-10-26 07:00:00", "1981-04-26 08:00:00", "1981-10-25 07:00:00", 
"1982-04-25 08:00:00", "1982-10-31 07:00:00", "1983-04-24 08:00:00", 
"1983-10-30 07:00:00", "1984-04-29 08:00:00", "1984-10-28 07:00:00", 
"1985-04-28 08:00:00", "1985-10-27 07:00:00", "1986-04-27 08:00:00", 
"1986-10-26 07:00:00", "1987-04-05 08:00:00", "1987-10-25 07:00:00", 
"1988-04-03 08:00:00", "1988-10-30 07:00:00", "1989-04-02 08:00:00", 
"1989-10-29 07:00:00", "1990-04-01 08:00:00", "1990-10-28 07:00:00", 
"1991-04-07 08:00:00", "1991-10-27 07:00:00", "1992-04-05 08:00:00", 
"1992-10-25 07:00:00", "1993-04-04 08:00:00", "1993-10-31 07:00:00", 
"1994-04-03 08:00:00", "1994-10-30 07:00:00", "1995-04-02 08:00:00", 
"1995-10-29 07:00:00", "1996-04-07 08:00:00", "1996-10-27 07:00:00", 
"1997-04-06 08:00:00", "1997-10-26 07:00:00", "1998-04-05 08:00:00", 
"1998-10-25 07:00:00", "1999-04-04 08:00:00", "1999-10-31 07:00:00", 
"2000-04-02 08:00:00", "2000-10-29 07:00:00", "2001-04-01 08:00:00", 
"2001-10-28 07:00:00", "2002-04-07 08:00:00", "2002-10-27 07:00:00", 
"2003-04-06 08:00:00", "2003-10-26 07:00:00", "2004-04-04 08:00:00", 
"2004-10-31 07:00:00", "2005-04-03 08:00:00", "2005-10-30 07:00:00", 
"2006-04-02 08:00:00", "2006-10-29 07:00:00", "2007-04-01 08:00:00", 
"2007-10-28 07:00:00", "2008-04-06 08:00:00", "2008-10-26 07:00:00", 
"2009-04-05 08:00:00", "2009-10-25 07:00:00", "2010-04-04 08:00:00", 
"2010-10-31 07:00:00", "2011-04-03 08:00:00", "2011-10-30 07:00:00", 
"2012-04-01 08:00:00", "2012-10-28 07:00:00", "2013-04-07 08:00:00", 
"2013-10-27 07:00:00", "2014-04-06 08:00:00", "2014-10-26 07:00:00", 
"2015-04-05 08:00:00", "2015-10-25 07:00:00", "2016-04-03 08:00:00", 
"2016-10-30 07:00:00", "2017-04-02 08:00:00", "2017-10-29 07:00:00", 
"2018-04-01 08:00:00", "2018-10-28 07:00:00", "2019-04-07 08:00:00", 
"2019-10-27 07:00:00", "2020-04-05 08:00:00", "2020-10-25 07:00:00", 
"2021-04-04 08:00:00", "2021-10-31 07:00:00", "2022-04-03 08:00:00", 
"2022-10-30 07:00:00", "2023-04-02 08:00:00", "2023-10-29 07:00:00", 
"2024-04-07 08:00:00", "2024-10-27 07:00:00", "2025-04-06 08:00:00", 
"2025-10-26 07:00:00", "2026-04-05 08:00:00", "2026-10-25 07:00:00", 
"2027-04-04 08:00:00", "2027-10-31 07:00:00", "2028-04-02 08:00:00", 
"2028-10-29 07:00:00", "2029-04-01 08:00:00", "2029-10-28 07:00:00", 
"2030-04-07 08:00:00", "2030-10-27 07:00:00"), class = "factor"), 
offSet = c(-18000, -21600, -18000, -21600, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -21600, -18000, -18000, -21600, -21600, 
-18000, -21600, -18000, -21600, -18000, -21600, -18000, -21600, 
-18000, -21600, -18000, -21600, -18000, -21600, -18000, -21600, 
-18000, -21600, -18000, -21600, -18000, -21600, -18000, -21600, 
-18000, -21600, -18000, -21600, -18000, -21600, -18000, -21600, 
-18000, -21600, -18000, -21600, -18000, -21600, -18000, -21600, 
-18000, -21600, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600)), .Names = c("Chicago", "offSet"), row.names = c("1", 
"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
"14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
"25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", 
"36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", 
"47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", 
"58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", 
"69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", 
"80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", 
"91", "92", "93", "94", "95", "96", "97", "98", "99", "100", 
"101", "102", "103", "104", "105", "106", "107", "108", "109", 
"110", "111", "112", "113", "114", "115", "116", "117", "118", 
"119", "120", "121", "122", "123", "124", "125", "126", "127", 
"128", "129", "130", "131", "132", "133", "134", "135", "136", 
"137", "138", "139", "140", "141", "142", "143", "144", "145", 
"146", "147", "148", "149", "150", "151", "152", "153", "154", 
"155", "156", "157", "158", "159", "160", "161", "162", "163", 
"164", "165", "166", "167", "168", "169", "170", "171", "172", 
"173", "174", "175", "176", "177", "178", "179", "180", "181", 
"182", "183", "184", "185", "186", "187", "188", "189", "190", 
"191", "192", "193", "194", "195", "196", "197", "198", "199", 
"200", "201", "202", "203", "204", "205", "206", "207", "208", 
"209", "210", "211", "212", "213", "214", "215", "216", "217", 
"218", "219", "220", "221", "222", "223", "224", "225"), 
class = "data.frame") }


"Denver" = 
function() {
structure(list(Denver = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 
71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
141, 142, 143, 144, 145, 146, 147)), .Label = c("1918-03-31 09:00:00", 
"1918-10-27 08:00:00", "1919-03-30 09:00:00", "1919-10-26 08:00:00", 
"1920-01-01 07:00:00", "1920-03-28 09:00:00", "1920-10-31 08:00:00", 
"1921-03-27 09:00:00", "1921-05-22 08:00:00", "1942-01-01 07:00:00", 
"1942-02-09 09:00:00", "1945-08-14 23:00:00", "1945-09-30 08:00:00", 
"1946-01-01 07:00:00", "1965-04-25 09:00:00", "1965-10-31 08:00:00", 
"1966-04-24 09:00:00", "1966-10-30 08:00:00", "1967-01-01 07:00:00", 
"1967-04-30 09:00:00", "1967-10-29 08:00:00", "1968-04-28 09:00:00", 
"1968-10-27 08:00:00", "1969-04-27 09:00:00", "1969-10-26 08:00:00", 
"1970-04-26 09:00:00", "1970-10-25 08:00:00", "1971-04-25 09:00:00", 
"1971-10-31 08:00:00", "1972-04-30 09:00:00", "1972-10-29 08:00:00", 
"1973-04-29 09:00:00", "1973-10-28 08:00:00", "1974-01-06 09:00:00", 
"1974-10-27 08:00:00", "1975-02-23 09:00:00", "1975-10-26 08:00:00", 
"1976-04-25 09:00:00", "1976-10-31 08:00:00", "1977-04-24 09:00:00", 
"1977-10-30 08:00:00", "1978-04-30 09:00:00", "1978-10-29 08:00:00", 
"1979-04-29 09:00:00", "1979-10-28 08:00:00", "1980-04-27 09:00:00", 
"1980-10-26 08:00:00", "1981-04-26 09:00:00", "1981-10-25 08:00:00", 
"1982-04-25 09:00:00", "1982-10-31 08:00:00", "1983-04-24 09:00:00", 
"1983-10-30 08:00:00", "1984-04-29 09:00:00", "1984-10-28 08:00:00", 
"1985-04-28 09:00:00", "1985-10-27 08:00:00", "1986-04-27 09:00:00", 
"1986-10-26 08:00:00", "1987-04-05 09:00:00", "1987-10-25 08:00:00", 
"1988-04-03 09:00:00", "1988-10-30 08:00:00", "1989-04-02 09:00:00", 
"1989-10-29 08:00:00", "1990-04-01 09:00:00", "1990-10-28 08:00:00", 
"1991-04-07 09:00:00", "1991-10-27 08:00:00", "1992-04-05 09:00:00", 
"1992-10-25 08:00:00", "1993-04-04 09:00:00", "1993-10-31 08:00:00", 
"1994-04-03 09:00:00", "1994-10-30 08:00:00", "1995-04-02 09:00:00", 
"1995-10-29 08:00:00", "1996-04-07 09:00:00", "1996-10-27 08:00:00", 
"1997-04-06 09:00:00", "1997-10-26 08:00:00", "1998-04-05 09:00:00", 
"1998-10-25 08:00:00", "1999-04-04 09:00:00", "1999-10-31 08:00:00", 
"2000-04-02 09:00:00", "2000-10-29 08:00:00", "2001-04-01 09:00:00", 
"2001-10-28 08:00:00", "2002-04-07 09:00:00", "2002-10-27 08:00:00", 
"2003-04-06 09:00:00", "2003-10-26 08:00:00", "2004-04-04 09:00:00", 
"2004-10-31 08:00:00", "2005-04-03 09:00:00", "2005-10-30 08:00:00", 
"2006-04-02 09:00:00", "2006-10-29 08:00:00", "2007-04-01 09:00:00", 
"2007-10-28 08:00:00", "2008-04-06 09:00:00", "2008-10-26 08:00:00", 
"2009-04-05 09:00:00", "2009-10-25 08:00:00", "2010-04-04 09:00:00", 
"2010-10-31 08:00:00", "2011-04-03 09:00:00", "2011-10-30 08:00:00", 
"2012-04-01 09:00:00", "2012-10-28 08:00:00", "2013-04-07 09:00:00", 
"2013-10-27 08:00:00", "2014-04-06 09:00:00", "2014-10-26 08:00:00", 
"2015-04-05 09:00:00", "2015-10-25 08:00:00", "2016-04-03 09:00:00", 
"2016-10-30 08:00:00", "2017-04-02 09:00:00", "2017-10-29 08:00:00", 
"2018-04-01 09:00:00", "2018-10-28 08:00:00", "2019-04-07 09:00:00", 
"2019-10-27 08:00:00", "2020-04-05 09:00:00", "2020-10-25 08:00:00", 
"2021-04-04 09:00:00", "2021-10-31 08:00:00", "2022-04-03 09:00:00", 
"2022-10-30 08:00:00", "2023-04-02 09:00:00", "2023-10-29 08:00:00", 
"2024-04-07 09:00:00", "2024-10-27 08:00:00", "2025-04-06 09:00:00", 
"2025-10-26 08:00:00", "2026-04-05 09:00:00", "2026-10-25 08:00:00", 
"2027-04-04 09:00:00", "2027-10-31 08:00:00", "2028-04-02 09:00:00", 
"2028-10-29 08:00:00", "2029-04-01 09:00:00", "2029-10-28 08:00:00", 
"2030-04-07 09:00:00", "2030-10-27 08:00:00"), class = "factor"), 
offSet = c(-21600, -25200, -21600, -25200, -25200, -21600, 
-25200, -21600, -25200, -25200, -21600, -21600, -25200, -25200, 
-21600, -25200, -21600, -25200, -25200, -21600, -25200, -21600, 
-25200, -21600, -25200, -21600, -25200, -21600, -25200, -21600, 
-25200, -21600, -25200, -21600, -25200, -21600, -25200, -21600, 
-25200, -21600, -25200, -21600, -25200, -21600, -25200, -21600, 
-25200, -21600, -25200, -21600, -25200, -21600, -25200, -21600, 
-25200, -21600, -25200, -21600, -25200, -21600, -25200, -21600, 
-25200, -21600, -25200, -21600, -25200, -21600, -25200, -21600, 
-25200, -21600, -25200, -21600, -25200, -21600, -25200, -21600, 
-25200, -21600, -25200, -21600, -25200, -21600, -25200, -21600, 
-25200, -21600, -25200, -21600, -25200, -21600, -25200, -21600, 
-25200, -21600, -25200, -21600, -25200, -21600, -25200, -21600, 
-25200, -21600, -25200, -21600, -25200, -21600, -25200, -21600, 
-25200, -21600, -25200, -21600, -25200, -21600, -25200, -21600, 
-25200, -21600, -25200, -21600, -25200, -21600, -25200, -21600, 
-25200, -21600, -25200, -21600, -25200, -21600, -25200, -21600, 
-25200, -21600, -25200, -21600, -25200, -21600, -25200, -21600, 
-25200, -21600, -25200, -21600, -25200)), .Names = c("Denver", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", 
"9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
"20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", 
"31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", 
"42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", 
"53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", 
"64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", 
"75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", 
"86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", 
"97", "98", "99", "100", "101", "102", "103", "104", "105", "106", 
"107", "108", "109", "110", "111", "112", "113", "114", "115", 
"116", "117", "118", "119", "120", "121", "122", "123", "124", 
"125", "126", "127", "128", "129", "130", "131", "132", "133", 
"134", "135", "136", "137", "138", "139", "140", "141", "142", 
"143", "144", "145", "146", "147"), class = "data.frame") }


"Detroit" = 
function() {
structure(list(Detroit = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 
71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
128)), .Label = c("1915-05-15 08:00:00", "1942-01-01 05:00:00", 
"1942-02-09 07:00:00", "1945-08-14 23:00:00", "1945-09-30 06:00:00", 
"1946-01-01 05:00:00", "1948-04-25 07:00:00", "1948-09-26 06:00:00", 
"1967-06-14 07:00:00", "1967-10-29 06:00:00", "1973-01-01 05:00:00", 
"1973-04-29 07:00:00", "1973-10-28 06:00:00", "1974-01-06 07:00:00", 
"1974-10-27 06:00:00", "1975-01-01 05:00:00", "1975-04-27 07:00:00", 
"1975-10-26 07:00:00", "1976-04-25 07:00:00", "1976-10-31 06:00:00", 
"1977-04-24 07:00:00", "1977-10-30 06:00:00", "1978-04-30 07:00:00", 
"1978-10-29 06:00:00", "1979-04-29 07:00:00", "1979-10-28 06:00:00", 
"1980-04-27 07:00:00", "1980-10-26 06:00:00", "1981-04-26 07:00:00", 
"1981-10-25 06:00:00", "1982-04-25 07:00:00", "1982-10-31 06:00:00", 
"1983-04-24 07:00:00", "1983-10-30 06:00:00", "1984-04-29 07:00:00", 
"1984-10-28 06:00:00", "1985-04-28 07:00:00", "1985-10-27 06:00:00", 
"1986-04-27 07:00:00", "1986-10-26 06:00:00", "1987-04-05 07:00:00", 
"1987-10-25 06:00:00", "1988-04-03 07:00:00", "1988-10-30 06:00:00", 
"1989-04-02 07:00:00", "1989-10-29 06:00:00", "1990-04-01 07:00:00", 
"1990-10-28 06:00:00", "1991-04-07 07:00:00", "1991-10-27 06:00:00", 
"1992-04-05 07:00:00", "1992-10-25 06:00:00", "1993-04-04 07:00:00", 
"1993-10-31 06:00:00", "1994-04-03 07:00:00", "1994-10-30 06:00:00", 
"1995-04-02 07:00:00", "1995-10-29 06:00:00", "1996-04-07 07:00:00", 
"1996-10-27 06:00:00", "1997-04-06 07:00:00", "1997-10-26 06:00:00", 
"1998-04-05 07:00:00", "1998-10-25 06:00:00", "1999-04-04 07:00:00", 
"1999-10-31 06:00:00", "2000-04-02 07:00:00", "2000-10-29 06:00:00", 
"2001-04-01 07:00:00", "2001-10-28 06:00:00", "2002-04-07 07:00:00", 
"2002-10-27 06:00:00", "2003-04-06 07:00:00", "2003-10-26 06:00:00", 
"2004-04-04 07:00:00", "2004-10-31 06:00:00", "2005-04-03 07:00:00", 
"2005-10-30 06:00:00", "2006-04-02 07:00:00", "2006-10-29 06:00:00", 
"2007-04-01 07:00:00", "2007-10-28 06:00:00", "2008-04-06 07:00:00", 
"2008-10-26 06:00:00", "2009-04-05 07:00:00", "2009-10-25 06:00:00", 
"2010-04-04 07:00:00", "2010-10-31 06:00:00", "2011-04-03 07:00:00", 
"2011-10-30 06:00:00", "2012-04-01 07:00:00", "2012-10-28 06:00:00", 
"2013-04-07 07:00:00", "2013-10-27 06:00:00", "2014-04-06 07:00:00", 
"2014-10-26 06:00:00", "2015-04-05 07:00:00", "2015-10-25 06:00:00", 
"2016-04-03 07:00:00", "2016-10-30 06:00:00", "2017-04-02 07:00:00", 
"2017-10-29 06:00:00", "2018-04-01 07:00:00", "2018-10-28 06:00:00", 
"2019-04-07 07:00:00", "2019-10-27 06:00:00", "2020-04-05 07:00:00", 
"2020-10-25 06:00:00", "2021-04-04 07:00:00", "2021-10-31 06:00:00", 
"2022-04-03 07:00:00", "2022-10-30 06:00:00", "2023-04-02 07:00:00", 
"2023-10-29 06:00:00", "2024-04-07 07:00:00", "2024-10-27 06:00:00", 
"2025-04-06 07:00:00", "2025-10-26 06:00:00", "2026-04-05 07:00:00", 
"2026-10-25 06:00:00", "2027-04-04 07:00:00", "2027-10-31 06:00:00", 
"2028-04-02 07:00:00", "2028-10-29 06:00:00", "2029-04-01 07:00:00", 
"2029-10-28 06:00:00", "2030-04-07 07:00:00", "2030-10-27 06:00:00"
), class = "factor"), offSet = c(-18000, -18000, -14400, -14400, 
-18000, -18000, -14400, -18000, -14400, -18000, -18000, -14400, 
-18000, -14400, -18000, -18000, -18000, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000)), .Names = c("Detroit", "offSet"
), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", "9", 
"10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", 
"21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", 
"32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", 
"43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", 
"54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", 
"65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", 
"76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", 
"87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", 
"98", "99", "100", "101", "102", "103", "104", "105", "106", 
"107", "108", "109", "110", "111", "112", "113", "114", "115", 
"116", "117", "118", "119", "120", "121", "122", "123", "124", 
"125", "126", "127", "128"), class = "data.frame") }



"Edmonton" = 
function() {
structure(list(Edmonton = structure(as.integer(c(1, 2, 3, 4, 
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 
38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 
54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138)), 
.Label = c("1918-04-14 09:00:00", 
"1918-10-31 08:00:00", "1919-04-13 09:00:00", "1919-05-27 08:00:00", 
"1920-04-25 09:00:00", "1920-10-31 08:00:00", "1921-04-24 09:00:00", 
"1921-09-25 08:00:00", "1922-04-30 09:00:00", "1922-09-24 08:00:00", 
"1923-04-29 09:00:00", "1923-09-30 08:00:00", "1942-02-09 09:00:00", 
"1945-09-30 08:00:00", "1947-04-27 09:00:00", "1947-09-28 08:00:00", 
"1967-04-30 09:00:00", "1967-10-29 08:00:00", "1969-04-27 09:00:00", 
"1969-10-26 08:00:00", "1972-04-30 09:00:00", "1972-10-29 08:00:00", 
"1973-04-29 09:00:00", "1973-10-28 08:00:00", "1974-04-28 09:00:00", 
"1974-10-27 08:00:00", "1975-04-27 09:00:00", "1975-10-26 08:00:00", 
"1976-04-25 09:00:00", "1976-10-31 08:00:00", "1977-04-24 09:00:00", 
"1977-10-30 08:00:00", "1978-04-30 09:00:00", "1978-10-29 08:00:00", 
"1979-04-29 09:00:00", "1979-10-28 08:00:00", "1980-04-27 09:00:00", 
"1980-10-26 08:00:00", "1981-04-26 09:00:00", "1981-10-25 08:00:00", 
"1982-04-25 09:00:00", "1982-10-31 08:00:00", "1983-04-24 09:00:00", 
"1983-10-30 08:00:00", "1984-04-29 09:00:00", "1984-10-28 08:00:00", 
"1985-04-28 09:00:00", "1985-10-27 08:00:00", "1986-04-27 09:00:00", 
"1986-10-26 08:00:00", "1987-04-05 09:00:00", "1987-10-25 08:00:00", 
"1988-04-03 09:00:00", "1988-10-30 08:00:00", "1989-04-02 09:00:00", 
"1989-10-29 08:00:00", "1990-04-01 09:00:00", "1990-10-28 08:00:00", 
"1991-04-07 09:00:00", "1991-10-27 08:00:00", "1992-04-05 09:00:00", 
"1992-10-25 08:00:00", "1993-04-04 09:00:00", "1993-10-31 08:00:00", 
"1994-04-03 09:00:00", "1994-10-30 08:00:00", "1995-04-02 09:00:00", 
"1995-10-29 08:00:00", "1996-04-07 09:00:00", "1996-10-27 08:00:00", 
"1997-04-06 09:00:00", "1997-10-26 08:00:00", "1998-04-05 09:00:00", 
"1998-10-25 08:00:00", "1999-04-04 09:00:00", "1999-10-31 08:00:00", 
"2000-04-02 09:00:00", "2000-10-29 08:00:00", "2001-04-01 09:00:00", 
"2001-10-28 08:00:00", "2002-04-07 09:00:00", "2002-10-27 08:00:00", 
"2003-04-06 09:00:00", "2003-10-26 08:00:00", "2004-04-04 09:00:00", 
"2004-10-31 08:00:00", "2005-04-03 09:00:00", "2005-10-30 08:00:00", 
"2006-04-02 09:00:00", "2006-10-29 08:00:00", "2007-04-01 09:00:00", 
"2007-10-28 08:00:00", "2008-04-06 09:00:00", "2008-10-26 08:00:00", 
"2009-04-05 09:00:00", "2009-10-25 08:00:00", "2010-04-04 09:00:00", 
"2010-10-31 08:00:00", "2011-04-03 09:00:00", "2011-10-30 08:00:00", 
"2012-04-01 09:00:00", "2012-10-28 08:00:00", "2013-04-07 09:00:00", 
"2013-10-27 08:00:00", "2014-04-06 09:00:00", "2014-10-26 08:00:00", 
"2015-04-05 09:00:00", "2015-10-25 08:00:00", "2016-04-03 09:00:00", 
"2016-10-30 08:00:00", "2017-04-02 09:00:00", "2017-10-29 08:00:00", 
"2018-04-01 09:00:00", "2018-10-28 08:00:00", "2019-04-07 09:00:00", 
"2019-10-27 08:00:00", "2020-04-05 09:00:00", "2020-10-25 08:00:00", 
"2021-04-04 09:00:00", "2021-10-31 08:00:00", "2022-04-03 09:00:00", 
"2022-10-30 08:00:00", "2023-04-02 09:00:00", "2023-10-29 08:00:00", 
"2024-04-07 09:00:00", "2024-10-27 08:00:00", "2025-04-06 09:00:00", 
"2025-10-26 08:00:00", "2026-04-05 09:00:00", "2026-10-25 08:00:00", 
"2027-04-04 09:00:00", "2027-10-31 08:00:00", "2028-04-02 09:00:00", 
"2028-10-29 08:00:00", "2029-04-01 09:00:00", "2029-10-28 08:00:00", 
"2030-04-07 09:00:00", "2030-10-27 08:00:00"), class = "factor"), 
offSet = c(-21600, -25200, -21600, -25200, -21600, -25200, 
-21600, -25200, -21600, -25200, -21600, -25200, -21600, -25200, 
-21600, -25200, -21600, -25200, -21600, -25200, -21600, -25200, 
-21600, -25200, -21600, -25200, -21600, -25200, -21600, -25200, 
-21600, -25200, -21600, -25200, -21600, -25200, -21600, -25200, 
-21600, -25200, -21600, -25200, -21600, -25200, -21600, -25200, 
-21600, -25200, -21600, -25200, -21600, -25200, -21600, -25200, 
-21600, -25200, -21600, -25200, -21600, -25200, -21600, -25200, 
-21600, -25200, -21600, -25200, -21600, -25200, -21600, -25200, 
-21600, -25200, -21600, -25200, -21600, -25200, -21600, -25200, 
-21600, -25200, -21600, -25200, -21600, -25200, -21600, -25200, 
-21600, -25200, -21600, -25200, -21600, -25200, -21600, -25200, 
-21600, -25200, -21600, -25200, -21600, -25200, -21600, -25200, 
-21600, -25200, -21600, -25200, -21600, -25200, -21600, -25200, 
-21600, -25200, -21600, -25200, -21600, -25200, -21600, -25200, 
-21600, -25200, -21600, -25200, -21600, -25200, -21600, -25200, 
-21600, -25200, -21600, -25200, -21600, -25200, -21600, -25200, 
-21600, -25200, -21600, -25200)), .Names = c("Edmonton", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", 
"9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
"20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", 
"31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", 
"42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", 
"53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", 
"64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", 
"75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", 
"86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", 
"97", "98", "99", "100", "101", "102", "103", "104", "105", "106", 
"107", "108", "109", "110", "111", "112", "113", "114", "115", 
"116", "117", "118", "119", "120", "121", "122", "123", "124", 
"125", "126", "127", "128", "129", "130", "131", "132", "133", 
"134", "135", "136", "137", "138"), class = "data.frame") }


"Indianapolis" = 
function() {
structure(list(Indianapolis = structure(as.integer(c(1, 2, 3, 
4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 
37, 38, 39)), .Label = c("1918-03-31 08:00:00", "1918-10-27 07:00:00", 
"1919-03-30 08:00:00", "1919-10-26 07:00:00", "1920-01-01 06:00:00", 
"1941-06-22 08:00:00", "1941-09-28 07:00:00", "1942-01-01 06:00:00", 
"1942-02-09 08:00:00", "1945-08-14 23:00:00", "1945-09-30 07:00:00", 
"1946-01-01 06:00:00", "1946-04-28 08:00:00", "1946-09-29 07:00:00", 
"1947-04-27 08:00:00", "1947-09-28 07:00:00", "1948-04-25 08:00:00", 
"1948-09-26 07:00:00", "1949-04-24 08:00:00", "1949-09-25 07:00:00", 
"1950-04-30 08:00:00", "1950-09-24 07:00:00", "1951-04-29 08:00:00", 
"1951-09-30 07:00:00", "1952-04-27 08:00:00", "1952-09-28 07:00:00", 
"1953-04-26 08:00:00", "1953-09-27 07:00:00", "1954-04-25 08:00:00", 
"1954-09-26 07:00:00", "1955-04-24 08:00:00", "1957-09-29 07:00:00", 
"1958-04-27 08:00:00", "1969-01-01 05:00:00", "1969-04-27 07:00:00", 
"1969-10-26 06:00:00", "1970-04-26 07:00:00", "1970-10-25 06:00:00", 
"1971-01-01 05:00:00"), class = "factor"), offSet = c(-18000, 
-21600, -18000, -21600, -21600, -18000, -21600, -21600, -18000, 
-18000, -21600, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-18000, -14400, -18000, -14400, -18000, -18000)), .Names = c("Indianapolis", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", 
"9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
"20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", 
"31", "32", "33", "34", "35", "36", "37", "38", "39"), class = "data.frame") }


"LosAngeles" = "Pacific" = 
function() {
structure(list(LosAngeles = structure(as.integer(c(1, 2, 3, 
4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 
37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 
53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 
85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 
140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 
153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 
166, 167, 168, 169, 170, 171, 172, 173)), .Label = c("1918-03-31 10:00:00", 
"1918-10-27 09:00:00", "1919-03-30 10:00:00", "1919-10-26 09:00:00", 
"1942-02-09 10:00:00", "1945-08-14 23:00:00", "1945-09-30 09:00:00", 
"1946-01-01 08:00:00", "1948-03-14 10:00:00", "1949-01-01 09:00:00", 
"1950-04-30 10:00:00", "1950-09-24 09:00:00", "1951-04-29 10:00:00", 
"1951-09-30 09:00:00", "1952-04-27 10:00:00", "1952-09-28 09:00:00", 
"1953-04-26 10:00:00", "1953-09-27 09:00:00", "1954-04-25 10:00:00", 
"1954-09-26 09:00:00", "1955-04-24 10:00:00", "1955-09-25 09:00:00", 
"1956-04-29 10:00:00", "1956-09-30 09:00:00", "1957-04-28 10:00:00", 
"1957-09-29 09:00:00", "1958-04-27 10:00:00", "1958-09-28 09:00:00", 
"1959-04-26 10:00:00", "1959-09-27 09:00:00", "1960-04-24 10:00:00", 
"1960-09-25 09:00:00", "1961-04-30 10:00:00", "1961-09-24 09:00:00", 
"1962-04-29 10:00:00", "1962-10-28 09:00:00", "1963-04-28 10:00:00", 
"1963-10-27 09:00:00", "1964-04-26 10:00:00", "1964-10-25 09:00:00", 
"1965-04-25 10:00:00", "1965-10-31 09:00:00", "1966-04-24 10:00:00", 
"1966-10-30 09:00:00", "1967-01-01 08:00:00", "1967-04-30 10:00:00", 
"1967-10-29 09:00:00", "1968-04-28 10:00:00", "1968-10-27 09:00:00", 
"1969-04-27 10:00:00", "1969-10-26 09:00:00", "1970-04-26 10:00:00", 
"1970-10-25 09:00:00", "1971-04-25 10:00:00", "1971-10-31 09:00:00", 
"1972-04-30 10:00:00", "1972-10-29 09:00:00", "1973-04-29 10:00:00", 
"1973-10-28 09:00:00", "1974-01-06 10:00:00", "1974-10-27 09:00:00", 
"1975-02-23 10:00:00", "1975-10-26 09:00:00", "1976-04-25 10:00:00", 
"1976-10-31 09:00:00", "1977-04-24 10:00:00", "1977-10-30 09:00:00", 
"1978-04-30 10:00:00", "1978-10-29 09:00:00", "1979-04-29 10:00:00", 
"1979-10-28 09:00:00", "1980-04-27 10:00:00", "1980-10-26 09:00:00", 
"1981-04-26 10:00:00", "1981-10-25 09:00:00", "1982-04-25 10:00:00", 
"1982-10-31 09:00:00", "1983-04-24 10:00:00", "1983-10-30 09:00:00", 
"1984-04-29 10:00:00", "1984-10-28 09:00:00", "1985-04-28 10:00:00", 
"1985-10-27 09:00:00", "1986-04-27 10:00:00", "1986-10-26 09:00:00", 
"1987-04-05 10:00:00", "1987-10-25 09:00:00", "1988-04-03 10:00:00", 
"1988-10-30 09:00:00", "1989-04-02 10:00:00", "1989-10-29 09:00:00", 
"1990-04-01 10:00:00", "1990-10-28 09:00:00", "1991-04-07 10:00:00", 
"1991-10-27 09:00:00", "1992-04-05 10:00:00", "1992-10-25 09:00:00", 
"1993-04-04 10:00:00", "1993-10-31 09:00:00", "1994-04-03 10:00:00", 
"1994-10-30 09:00:00", "1995-04-02 10:00:00", "1995-10-29 09:00:00", 
"1996-04-07 10:00:00", "1996-10-27 09:00:00", "1997-04-06 10:00:00", 
"1997-10-26 09:00:00", "1998-04-05 10:00:00", "1998-10-25 09:00:00", 
"1999-04-04 10:00:00", "1999-10-31 09:00:00", "2000-04-02 10:00:00", 
"2000-10-29 09:00:00", "2001-04-01 10:00:00", "2001-10-28 09:00:00", 
"2002-04-07 10:00:00", "2002-10-27 09:00:00", "2003-04-06 10:00:00", 
"2003-10-26 09:00:00", "2004-04-04 10:00:00", "2004-10-31 09:00:00", 
"2005-04-03 10:00:00", "2005-10-30 09:00:00", "2006-04-02 10:00:00", 
"2006-10-29 09:00:00", "2007-04-01 10:00:00", "2007-10-28 09:00:00", 
"2008-04-06 10:00:00", "2008-10-26 09:00:00", "2009-04-05 10:00:00", 
"2009-10-25 09:00:00", "2010-04-04 10:00:00", "2010-10-31 09:00:00", 
"2011-04-03 10:00:00", "2011-10-30 09:00:00", "2012-04-01 10:00:00", 
"2012-10-28 09:00:00", "2013-04-07 10:00:00", "2013-10-27 09:00:00", 
"2014-04-06 10:00:00", "2014-10-26 09:00:00", "2015-04-05 10:00:00", 
"2015-10-25 09:00:00", "2016-04-03 10:00:00", "2016-10-30 09:00:00", 
"2017-04-02 10:00:00", "2017-10-29 09:00:00", "2018-04-01 10:00:00", 
"2018-10-28 09:00:00", "2019-04-07 10:00:00", "2019-10-27 09:00:00", 
"2020-04-05 10:00:00", "2020-10-25 09:00:00", "2021-04-04 10:00:00", 
"2021-10-31 09:00:00", "2022-04-03 10:00:00", "2022-10-30 09:00:00", 
"2023-04-02 10:00:00", "2023-10-29 09:00:00", "2024-04-07 10:00:00", 
"2024-10-27 09:00:00", "2025-04-06 10:00:00", "2025-10-26 09:00:00", 
"2026-04-05 10:00:00", "2026-10-25 09:00:00", "2027-04-04 10:00:00", 
"2027-10-31 09:00:00", "2028-04-02 10:00:00", "2028-10-29 09:00:00", 
"2029-04-01 10:00:00", "2029-10-28 09:00:00", "2030-04-07 10:00:00", 
"2030-10-27 09:00:00"), class = "factor"), offSet = c(-25200, 
-28800, -25200, -28800, -25200, -25200, -28800, -28800, -25200, 
-28800, -25200, -28800, -25200, -28800, -25200, -28800, -25200, 
-28800, -25200, -28800, -25200, -28800, -25200, -28800, -25200, 
-28800, -25200, -28800, -25200, -28800, -25200, -28800, -25200, 
-28800, -25200, -28800, -25200, -28800, -25200, -28800, -25200, 
-28800, -25200, -28800, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800)), .Names = c("Los_Angeles", "offSet"
), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", "9", 
"10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", 
"21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", 
"32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", 
"43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", 
"54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", 
"65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", 
"76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", 
"87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", 
"98", "99", "100", "101", "102", "103", "104", "105", "106", 
"107", "108", "109", "110", "111", "112", "113", "114", "115", 
"116", "117", "118", "119", "120", "121", "122", "123", "124", 
"125", "126", "127", "128", "129", "130", "131", "132", "133", 
"134", "135", "136", "137", "138", "139", "140", "141", "142", 
"143", "144", "145", "146", "147", "148", "149", "150", "151", 
"152", "153", "154", "155", "156", "157", "158", "159", "160", 
"161", "162", "163", "164", "165", "166", "167", "168", "169", 
"170", "171", "172", "173"), class = "data.frame") }


"MexicoCity" = 
function() {
structure(list(MexicoCity = structure(as.integer(c(1, 2, 3, 
4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 
37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 
53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83)), 
.Label = c("1927-06-11 06:00:00", 
"1930-11-15 06:00:00", "1931-05-02 06:00:00", "1931-10-01 06:00:00", 
"1932-04-01 07:00:00", "1939-02-05 06:00:00", "1939-06-25 05:00:00", 
"1940-12-09 06:00:00", "1941-04-01 05:00:00", "1943-12-16 06:00:00", 
"1944-05-01 05:00:00", "1950-02-12 06:00:00", "1950-07-30 05:00:00", 
"1996-04-07 08:00:00", "1996-10-27 07:00:00", "1997-04-06 08:00:00", 
"1997-10-26 07:00:00", "1998-04-05 08:00:00", "1998-10-25 07:00:00", 
"1999-04-04 08:00:00", "1999-10-31 07:00:00", "2000-04-02 08:00:00", 
"2000-10-29 07:00:00", "2001-05-06 08:00:00", "2001-09-30 07:00:00", 
"2002-05-05 08:00:00", "2002-09-29 07:00:00", "2003-05-04 08:00:00", 
"2003-09-28 07:00:00", "2004-05-02 08:00:00", "2004-09-26 07:00:00", 
"2005-05-01 08:00:00", "2005-09-25 07:00:00", "2006-05-07 08:00:00", 
"2006-09-24 07:00:00", "2007-05-06 08:00:00", "2007-09-30 07:00:00", 
"2008-05-04 08:00:00", "2008-09-28 07:00:00", "2009-05-03 08:00:00", 
"2009-09-27 07:00:00", "2010-05-02 08:00:00", "2010-09-26 07:00:00", 
"2011-05-01 08:00:00", "2011-09-25 07:00:00", "2012-05-06 08:00:00", 
"2012-09-30 07:00:00", "2013-05-05 08:00:00", "2013-09-29 07:00:00", 
"2014-05-04 08:00:00", "2014-09-28 07:00:00", "2015-05-03 08:00:00", 
"2015-09-27 07:00:00", "2016-05-01 08:00:00", "2016-09-25 07:00:00", 
"2017-05-07 08:00:00", "2017-09-24 07:00:00", "2018-05-06 08:00:00", 
"2018-09-30 07:00:00", "2019-05-05 08:00:00", "2019-09-29 07:00:00", 
"2020-05-03 08:00:00", "2020-09-27 07:00:00", "2021-05-02 08:00:00", 
"2021-09-26 07:00:00", "2022-05-01 08:00:00", "2022-09-25 07:00:00", 
"2023-05-07 08:00:00", "2023-09-24 07:00:00", "2024-05-05 08:00:00", 
"2024-09-29 07:00:00", "2025-05-04 08:00:00", "2025-09-28 07:00:00", 
"2026-05-03 08:00:00", "2026-09-27 07:00:00", "2027-05-02 08:00:00", 
"2027-09-26 07:00:00", "2028-05-07 08:00:00", "2028-09-24 07:00:00", 
"2029-05-06 08:00:00", "2029-09-30 07:00:00", "2030-05-05 08:00:00", 
"2030-09-29 07:00:00"), class = "factor"), offSet = c(-21600, 
-25200, -21600, -25200, -21600, -18000, -21600, -18000, -21600, 
-18000, -21600, -18000, -21600, -18000, -21600, -18000, -21600, 
-18000, -21600, -18000, -21600, -18000, -21600, -18000, -21600, 
-18000, -21600, -18000, -21600, -18000, -21600, -18000, -21600, 
-18000, -21600, -18000, -21600, -18000, -21600, -18000, -21600, 
-18000, -21600, -18000, -21600, -18000, -21600, -18000, -21600, 
-18000, -21600, -18000, -21600, -18000, -21600, -18000, -21600, 
-18000, -21600, -18000, -21600, -18000, -21600, -18000, -21600, 
-18000, -21600, -18000, -21600, -18000, -21600, -18000, -21600, 
-18000, -21600, -18000, -21600, -18000, -21600, -18000, -21600, 
-18000, -21600)), .Names = c("Mexico_City", "offSet"), row.names = c("1", 
"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
"14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
"25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", 
"36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", 
"47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", 
"58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", 
"69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", 
"80", "81", "82", "83"), class = "data.frame") }


"Montreal" = 
function() {
structure(list(Montreal = structure(as.integer(c(1, 2, 3, 4, 
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 
38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 
54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 
140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 
153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 
166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 
179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 
192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 
205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216)), 
.Label = c("1917-03-25 07:00:00", 
"1917-04-24 04:00:00", "1918-04-14 07:00:00", "1918-10-31 06:00:00", 
"1919-03-31 07:30:00", "1919-10-25 06:30:00", "1920-05-02 07:30:00", 
"1920-10-03 06:30:00", "1921-05-01 07:00:00", "1921-10-02 06:30:00", 
"1922-04-30 07:00:00", "1922-10-01 06:30:00", "1924-05-17 07:00:00", 
"1924-09-28 06:30:00", "1925-05-03 07:00:00", "1925-09-27 06:30:00", 
"1926-05-02 07:00:00", "1926-09-26 06:30:00", "1927-05-01 05:00:00", 
"1927-09-25 04:00:00", "1928-04-29 05:00:00", "1928-09-30 04:00:00", 
"1929-04-28 05:00:00", "1929-09-29 04:00:00", "1930-04-27 05:00:00", 
"1930-09-28 04:00:00", "1931-04-26 05:00:00", "1931-09-27 04:00:00", 
"1932-05-01 05:00:00", "1932-09-25 04:00:00", "1933-04-30 05:00:00", 
"1933-10-01 04:00:00", "1934-04-29 05:00:00", "1934-09-30 04:00:00", 
"1935-04-28 05:00:00", "1935-09-29 04:00:00", "1936-04-26 05:00:00", 
"1936-09-27 04:00:00", "1937-04-25 05:00:00", "1937-09-26 04:00:00", 
"1938-04-24 05:00:00", "1938-09-25 04:00:00", "1939-04-30 05:00:00", 
"1939-09-24 04:00:00", "1940-04-28 05:00:00", "1945-09-30 06:00:00", 
"1946-04-28 07:00:00", "1946-09-29 06:00:00", "1947-04-27 07:00:00", 
"1947-09-28 06:00:00", "1948-04-25 07:00:00", "1948-09-26 06:00:00", 
"1949-04-24 07:00:00", "1949-10-30 06:00:00", "1950-04-30 07:00:00", 
"1950-10-29 06:00:00", "1951-04-29 07:00:00", "1951-09-30 06:00:00", 
"1952-04-27 07:00:00", "1952-09-28 06:00:00", "1953-04-26 07:00:00", 
"1953-09-27 06:00:00", "1954-04-25 07:00:00", "1954-09-26 06:00:00", 
"1955-04-24 07:00:00", "1955-09-25 06:00:00", "1956-04-29 07:00:00", 
"1956-09-30 06:00:00", "1957-04-28 07:00:00", "1957-10-27 06:00:00", 
"1958-04-27 07:00:00", "1958-10-26 06:00:00", "1959-04-26 07:00:00", 
"1959-10-25 06:00:00", "1960-04-24 07:00:00", "1960-10-30 06:00:00", 
"1961-04-30 07:00:00", "1961-10-29 06:00:00", "1962-04-29 07:00:00", 
"1962-10-28 06:00:00", "1963-04-28 07:00:00", "1963-10-27 06:00:00", 
"1964-04-26 07:00:00", "1964-10-25 06:00:00", "1965-04-25 07:00:00", 
"1965-10-31 06:00:00", "1966-04-24 07:00:00", "1966-10-30 06:00:00", 
"1967-04-30 07:00:00", "1967-10-29 06:00:00", "1968-04-28 07:00:00", 
"1968-10-27 06:00:00", "1969-04-27 07:00:00", "1969-10-26 06:00:00", 
"1970-04-26 07:00:00", "1970-10-25 06:00:00", "1971-04-25 07:00:00", 
"1971-10-31 06:00:00", "1972-04-30 07:00:00", "1972-10-29 06:00:00", 
"1973-04-29 07:00:00", "1973-10-28 06:00:00", "1974-04-28 07:00:00", 
"1974-10-27 06:00:00", "1975-04-27 07:00:00", "1975-10-26 06:00:00", 
"1976-04-25 07:00:00", "1976-10-31 06:00:00", "1977-04-24 07:00:00", 
"1977-10-30 06:00:00", "1978-04-30 07:00:00", "1978-10-29 06:00:00", 
"1979-04-29 07:00:00", "1979-10-28 06:00:00", "1980-04-27 07:00:00", 
"1980-10-26 06:00:00", "1981-04-26 07:00:00", "1981-10-25 06:00:00", 
"1982-04-25 07:00:00", "1982-10-31 06:00:00", "1983-04-24 07:00:00", 
"1983-10-30 06:00:00", "1984-04-29 07:00:00", "1984-10-28 06:00:00", 
"1985-04-28 07:00:00", "1985-10-27 06:00:00", "1986-04-27 07:00:00", 
"1986-10-26 06:00:00", "1987-04-05 07:00:00", "1987-10-25 06:00:00", 
"1988-04-03 07:00:00", "1988-10-30 06:00:00", "1989-04-02 07:00:00", 
"1989-10-29 06:00:00", "1990-04-01 07:00:00", "1990-10-28 06:00:00", 
"1991-04-07 07:00:00", "1991-10-27 06:00:00", "1992-04-05 07:00:00", 
"1992-10-25 06:00:00", "1993-04-04 07:00:00", "1993-10-31 06:00:00", 
"1994-04-03 07:00:00", "1994-10-30 06:00:00", "1995-04-02 07:00:00", 
"1995-10-29 06:00:00", "1996-04-07 07:00:00", "1996-10-27 06:00:00", 
"1997-04-06 07:00:00", "1997-10-26 06:00:00", "1998-04-05 07:00:00", 
"1998-10-25 06:00:00", "1999-04-04 07:00:00", "1999-10-31 06:00:00", 
"2000-04-02 07:00:00", "2000-10-29 06:00:00", "2001-04-01 07:00:00", 
"2001-10-28 06:00:00", "2002-04-07 07:00:00", "2002-10-27 06:00:00", 
"2003-04-06 07:00:00", "2003-10-26 06:00:00", "2004-04-04 07:00:00", 
"2004-10-31 06:00:00", "2005-04-03 07:00:00", "2005-10-30 06:00:00", 
"2006-04-02 07:00:00", "2006-10-29 06:00:00", "2007-04-01 07:00:00", 
"2007-10-28 06:00:00", "2008-04-06 07:00:00", "2008-10-26 06:00:00", 
"2009-04-05 07:00:00", "2009-10-25 06:00:00", "2010-04-04 07:00:00", 
"2010-10-31 06:00:00", "2011-04-03 07:00:00", "2011-10-30 06:00:00", 
"2012-04-01 07:00:00", "2012-10-28 06:00:00", "2013-04-07 07:00:00", 
"2013-10-27 06:00:00", "2014-04-06 07:00:00", "2014-10-26 06:00:00", 
"2015-04-05 07:00:00", "2015-10-25 06:00:00", "2016-04-03 07:00:00", 
"2016-10-30 06:00:00", "2017-04-02 07:00:00", "2017-10-29 06:00:00", 
"2018-04-01 07:00:00", "2018-10-28 06:00:00", "2019-04-07 07:00:00", 
"2019-10-27 06:00:00", "2020-04-05 07:00:00", "2020-10-25 06:00:00", 
"2021-04-04 07:00:00", "2021-10-31 06:00:00", "2022-04-03 07:00:00", 
"2022-10-30 06:00:00", "2023-04-02 07:00:00", "2023-10-29 06:00:00", 
"2024-04-07 07:00:00", "2024-10-27 06:00:00", "2025-04-06 07:00:00", 
"2025-10-26 06:00:00", "2026-04-05 07:00:00", "2026-10-25 06:00:00", 
"2027-04-04 07:00:00", "2027-10-31 06:00:00", "2028-04-02 07:00:00", 
"2028-10-29 06:00:00", "2029-04-01 07:00:00", "2029-10-28 06:00:00", 
"2030-04-07 07:00:00", "2030-10-27 06:00:00"), class = "factor"), 
offSet = c(-14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000)), .Names = c("Montreal", "offSet"), row.names = c("1", 
"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
"14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
"25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", 
"36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", 
"47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", 
"58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", 
"69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", 
"80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", 
"91", "92", "93", "94", "95", "96", "97", "98", "99", "100", 
"101", "102", "103", "104", "105", "106", "107", "108", "109", 
"110", "111", "112", "113", "114", "115", "116", "117", "118", 
"119", "120", "121", "122", "123", "124", "125", "126", "127", 
"128", "129", "130", "131", "132", "133", "134", "135", "136", 
"137", "138", "139", "140", "141", "142", "143", "144", "145", 
"146", "147", "148", "149", "150", "151", "152", "153", "154", 
"155", "156", "157", "158", "159", "160", "161", "162", "163", 
"164", "165", "166", "167", "168", "169", "170", "171", "172", 
"173", "174", "175", "176", "177", "178", "179", "180", "181", 
"182", "183", "184", "185", "186", "187", "188", "189", "190", 
"191", "192", "193", "194", "195", "196", "197", "198", "199", 
"200", "201", "202", "203", "204", "205", "206", "207", "208", 
"209", "210", "211", "212", "213", "214", "215", "216"), class = "data.frame") }


"Nassau" = 
function() {
structure(list(Nassau = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 
71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
128, 129, 130, 131, 132, 133, 134)), .Label = c("1964-04-26 07:00:00", 
"1964-10-25 06:00:00", "1965-04-25 07:00:00", "1965-10-31 06:00:00", 
"1966-04-24 07:00:00", "1966-10-30 06:00:00", "1967-04-30 07:00:00", 
"1967-10-29 06:00:00", "1968-04-28 07:00:00", "1968-10-27 06:00:00", 
"1969-04-27 07:00:00", "1969-10-26 06:00:00", "1970-04-26 07:00:00", 
"1970-10-25 06:00:00", "1971-04-25 07:00:00", "1971-10-31 06:00:00", 
"1972-04-30 07:00:00", "1972-10-29 06:00:00", "1973-04-29 07:00:00", 
"1973-10-28 06:00:00", "1974-04-28 07:00:00", "1974-10-27 06:00:00", 
"1975-04-27 07:00:00", "1975-10-26 06:00:00", "1976-04-25 07:00:00", 
"1976-10-31 06:00:00", "1977-04-24 07:00:00", "1977-10-30 06:00:00", 
"1978-04-30 07:00:00", "1978-10-29 06:00:00", "1979-04-29 07:00:00", 
"1979-10-28 06:00:00", "1980-04-27 07:00:00", "1980-10-26 06:00:00", 
"1981-04-26 07:00:00", "1981-10-25 06:00:00", "1982-04-25 07:00:00", 
"1982-10-31 06:00:00", "1983-04-24 07:00:00", "1983-10-30 06:00:00", 
"1984-04-29 07:00:00", "1984-10-28 06:00:00", "1985-04-28 07:00:00", 
"1985-10-27 06:00:00", "1986-04-27 07:00:00", "1986-10-26 06:00:00", 
"1987-04-05 07:00:00", "1987-10-25 06:00:00", "1988-04-03 07:00:00", 
"1988-10-30 06:00:00", "1989-04-02 07:00:00", "1989-10-29 06:00:00", 
"1990-04-01 07:00:00", "1990-10-28 06:00:00", "1991-04-07 07:00:00", 
"1991-10-27 06:00:00", "1992-04-05 07:00:00", "1992-10-25 06:00:00", 
"1993-04-04 07:00:00", "1993-10-31 06:00:00", "1994-04-03 07:00:00", 
"1994-10-30 06:00:00", "1995-04-02 07:00:00", "1995-10-29 06:00:00", 
"1996-04-07 07:00:00", "1996-10-27 06:00:00", "1997-04-06 07:00:00", 
"1997-10-26 06:00:00", "1998-04-05 07:00:00", "1998-10-25 06:00:00", 
"1999-04-04 07:00:00", "1999-10-31 06:00:00", "2000-04-02 07:00:00", 
"2000-10-29 06:00:00", "2001-04-01 07:00:00", "2001-10-28 06:00:00", 
"2002-04-07 07:00:00", "2002-10-27 06:00:00", "2003-04-06 07:00:00", 
"2003-10-26 06:00:00", "2004-04-04 07:00:00", "2004-10-31 06:00:00", 
"2005-04-03 07:00:00", "2005-10-30 06:00:00", "2006-04-02 07:00:00", 
"2006-10-29 06:00:00", "2007-04-01 07:00:00", "2007-10-28 06:00:00", 
"2008-04-06 07:00:00", "2008-10-26 06:00:00", "2009-04-05 07:00:00", 
"2009-10-25 06:00:00", "2010-04-04 07:00:00", "2010-10-31 06:00:00", 
"2011-04-03 07:00:00", "2011-10-30 06:00:00", "2012-04-01 07:00:00", 
"2012-10-28 06:00:00", "2013-04-07 07:00:00", "2013-10-27 06:00:00", 
"2014-04-06 07:00:00", "2014-10-26 06:00:00", "2015-04-05 07:00:00", 
"2015-10-25 06:00:00", "2016-04-03 07:00:00", "2016-10-30 06:00:00", 
"2017-04-02 07:00:00", "2017-10-29 06:00:00", "2018-04-01 07:00:00", 
"2018-10-28 06:00:00", "2019-04-07 07:00:00", "2019-10-27 06:00:00", 
"2020-04-05 07:00:00", "2020-10-25 06:00:00", "2021-04-04 07:00:00", 
"2021-10-31 06:00:00", "2022-04-03 07:00:00", "2022-10-30 06:00:00", 
"2023-04-02 07:00:00", "2023-10-29 06:00:00", "2024-04-07 07:00:00", 
"2024-10-27 06:00:00", "2025-04-06 07:00:00", "2025-10-26 06:00:00", 
"2026-04-05 07:00:00", "2026-10-25 06:00:00", "2027-04-04 07:00:00", 
"2027-10-31 06:00:00", "2028-04-02 07:00:00", "2028-10-29 06:00:00", 
"2029-04-01 07:00:00", "2029-10-28 06:00:00", "2030-04-07 07:00:00", 
"2030-10-27 06:00:00"), class = "factor"), offSet = c(-14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000)), .Names = c("Nassau", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", 
"9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
"20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", 
"31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", 
"42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", 
"53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", 
"64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", 
"75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", 
"86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", 
"97", "98", "99", "100", "101", "102", "103", "104", "105", "106", 
"107", "108", "109", "110", "111", "112", "113", "114", "115", 
"116", "117", "118", "119", "120", "121", "122", "123", "124", 
"125", "126", "127", "128", "129", "130", "131", "132", "133", 
"134"), class = "data.frame") }


"NewYork" = "Eastern" = 
function() {
structure(list(NewYork = structure(as.integer(c(1, 2, 3, 4, 
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 
38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 
54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 
140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 
153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 
166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 
179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 
192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 
205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 
218, 219, 220, 221, 222, 223, 224, 225)), .Label = c("1918-03-31 07:00:00", 
"1918-10-27 06:00:00", "1919-03-30 07:00:00", "1919-10-26 06:00:00", 
"1920-01-01 05:00:00", "1920-03-28 07:00:00", "1920-10-31 06:00:00", 
"1921-04-24 07:00:00", "1921-09-25 06:00:00", "1922-04-30 07:00:00", 
"1922-09-24 06:00:00", "1923-04-29 07:00:00", "1923-09-30 06:00:00", 
"1924-04-27 07:00:00", "1924-09-28 06:00:00", "1925-04-26 07:00:00", 
"1925-09-27 06:00:00", "1926-04-25 07:00:00", "1926-09-26 06:00:00", 
"1927-04-24 07:00:00", "1927-09-25 06:00:00", "1928-04-29 07:00:00", 
"1928-09-30 06:00:00", "1929-04-28 07:00:00", "1929-09-29 06:00:00", 
"1930-04-27 07:00:00", "1930-09-28 06:00:00", "1931-04-26 07:00:00", 
"1931-09-27 06:00:00", "1932-04-24 07:00:00", "1932-09-25 06:00:00", 
"1933-04-30 07:00:00", "1933-09-24 06:00:00", "1934-04-29 07:00:00", 
"1934-09-30 06:00:00", "1935-04-28 07:00:00", "1935-09-29 06:00:00", 
"1936-04-26 07:00:00", "1936-09-27 06:00:00", "1937-04-25 07:00:00", 
"1937-09-26 06:00:00", "1938-04-24 07:00:00", "1938-09-25 06:00:00", 
"1939-04-30 07:00:00", "1939-09-24 06:00:00", "1940-04-28 07:00:00", 
"1940-09-29 06:00:00", "1941-04-27 07:00:00", "1941-09-28 06:00:00", 
"1942-01-01 05:00:00", "1942-02-09 07:00:00", "1945-08-14 23:00:00", 
"1945-09-30 06:00:00", "1946-01-01 05:00:00", "1946-04-28 07:00:00", 
"1946-09-29 06:00:00", "1947-04-27 07:00:00", "1947-09-28 06:00:00", 
"1948-04-25 07:00:00", "1948-09-26 06:00:00", "1949-04-24 07:00:00", 
"1949-09-25 06:00:00", "1950-04-30 07:00:00", "1950-09-24 06:00:00", 
"1951-04-29 07:00:00", "1951-09-30 06:00:00", "1952-04-27 07:00:00", 
"1952-09-28 06:00:00", "1953-04-26 07:00:00", "1953-09-27 06:00:00", 
"1954-04-25 07:00:00", "1954-09-26 06:00:00", "1955-04-24 07:00:00", 
"1955-10-30 06:00:00", "1956-04-29 07:00:00", "1956-10-28 06:00:00", 
"1957-04-28 07:00:00", "1957-10-27 06:00:00", "1958-04-27 07:00:00", 
"1958-10-26 06:00:00", "1959-04-26 07:00:00", "1959-10-25 06:00:00", 
"1960-04-24 07:00:00", "1960-10-30 06:00:00", "1961-04-30 07:00:00", 
"1961-10-29 06:00:00", "1962-04-29 07:00:00", "1962-10-28 06:00:00", 
"1963-04-28 07:00:00", "1963-10-27 06:00:00", "1964-04-26 07:00:00", 
"1964-10-25 06:00:00", "1965-04-25 07:00:00", "1965-10-31 06:00:00", 
"1966-04-24 07:00:00", "1966-10-30 06:00:00", "1967-01-01 05:00:00", 
"1967-04-30 07:00:00", "1967-10-29 06:00:00", "1968-04-28 07:00:00", 
"1968-10-27 06:00:00", "1969-04-27 07:00:00", "1969-10-26 06:00:00", 
"1970-04-26 07:00:00", "1970-10-25 06:00:00", "1971-04-25 07:00:00", 
"1971-10-31 06:00:00", "1972-04-30 07:00:00", "1972-10-29 06:00:00", 
"1973-04-29 07:00:00", "1973-10-28 06:00:00", "1974-01-06 07:00:00", 
"1974-10-27 06:00:00", "1975-02-23 07:00:00", "1975-10-26 06:00:00", 
"1976-04-25 07:00:00", "1976-10-31 06:00:00", "1977-04-24 07:00:00", 
"1977-10-30 06:00:00", "1978-04-30 07:00:00", "1978-10-29 06:00:00", 
"1979-04-29 07:00:00", "1979-10-28 06:00:00", "1980-04-27 07:00:00", 
"1980-10-26 06:00:00", "1981-04-26 07:00:00", "1981-10-25 06:00:00", 
"1982-04-25 07:00:00", "1982-10-31 06:00:00", "1983-04-24 07:00:00", 
"1983-10-30 06:00:00", "1984-04-29 07:00:00", "1984-10-28 06:00:00", 
"1985-04-28 07:00:00", "1985-10-27 06:00:00", "1986-04-27 07:00:00", 
"1986-10-26 06:00:00", "1987-04-05 07:00:00", "1987-10-25 06:00:00", 
"1988-04-03 07:00:00", "1988-10-30 06:00:00", "1989-04-02 07:00:00", 
"1989-10-29 06:00:00", "1990-04-01 07:00:00", "1990-10-28 06:00:00", 
"1991-04-07 07:00:00", "1991-10-27 06:00:00", "1992-04-05 07:00:00", 
"1992-10-25 06:00:00", "1993-04-04 07:00:00", "1993-10-31 06:00:00", 
"1994-04-03 07:00:00", "1994-10-30 06:00:00", "1995-04-02 07:00:00", 
"1995-10-29 06:00:00", "1996-04-07 07:00:00", "1996-10-27 06:00:00", 
"1997-04-06 07:00:00", "1997-10-26 06:00:00", "1998-04-05 07:00:00", 
"1998-10-25 06:00:00", "1999-04-04 07:00:00", "1999-10-31 06:00:00", 
"2000-04-02 07:00:00", "2000-10-29 06:00:00", "2001-04-01 07:00:00", 
"2001-10-28 06:00:00", "2002-04-07 07:00:00", "2002-10-27 06:00:00", 
"2003-04-06 07:00:00", "2003-10-26 06:00:00", "2004-04-04 07:00:00", 
"2004-10-31 06:00:00", "2005-04-03 07:00:00", "2005-10-30 06:00:00", 
"2006-04-02 07:00:00", "2006-10-29 06:00:00", "2007-04-01 07:00:00", 
"2007-10-28 06:00:00", "2008-04-06 07:00:00", "2008-10-26 06:00:00", 
"2009-04-05 07:00:00", "2009-10-25 06:00:00", "2010-04-04 07:00:00", 
"2010-10-31 06:00:00", "2011-04-03 07:00:00", "2011-10-30 06:00:00", 
"2012-04-01 07:00:00", "2012-10-28 06:00:00", "2013-04-07 07:00:00", 
"2013-10-27 06:00:00", "2014-04-06 07:00:00", "2014-10-26 06:00:00", 
"2015-04-05 07:00:00", "2015-10-25 06:00:00", "2016-04-03 07:00:00", 
"2016-10-30 06:00:00", "2017-04-02 07:00:00", "2017-10-29 06:00:00", 
"2018-04-01 07:00:00", "2018-10-28 06:00:00", "2019-04-07 07:00:00", 
"2019-10-27 06:00:00", "2020-04-05 07:00:00", "2020-10-25 06:00:00", 
"2021-04-04 07:00:00", "2021-10-31 06:00:00", "2022-04-03 07:00:00", 
"2022-10-30 06:00:00", "2023-04-02 07:00:00", "2023-10-29 06:00:00", 
"2024-04-07 07:00:00", "2024-10-27 06:00:00", "2025-04-06 07:00:00", 
"2025-10-26 06:00:00", "2026-04-05 07:00:00", "2026-10-25 06:00:00", 
"2027-04-04 07:00:00", "2027-10-31 06:00:00", "2028-04-02 07:00:00", 
"2028-10-29 06:00:00", "2029-04-01 07:00:00", "2029-10-28 06:00:00", 
"2030-04-07 07:00:00", "2030-10-27 06:00:00"), class = "factor"), 
offSet = c(-14400, -18000, -14400, -18000, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -18000, -14400, -14400, -18000, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -14400, -18000, -14400, -18000, -14400, -18000, 
-14400, -18000, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000, -14400, -18000, -14400, -18000, -14400, 
-18000, -14400, -18000)), .Names = c("New_York", "offSet"
), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", "9", 
"10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", 
"21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", 
"32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", 
"43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", 
"54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", 
"65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", 
"76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", 
"87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", 
"98", "99", "100", "101", "102", "103", "104", "105", "106", 
"107", "108", "109", "110", "111", "112", "113", "114", "115", 
"116", "117", "118", "119", "120", "121", "122", "123", "124", 
"125", "126", "127", "128", "129", "130", "131", "132", "133", 
"134", "135", "136", "137", "138", "139", "140", "141", "142", 
"143", "144", "145", "146", "147", "148", "149", "150", "151", 
"152", "153", "154", "155", "156", "157", "158", "159", "160", 
"161", "162", "163", "164", "165", "166", "167", "168", "169", 
"170", "171", "172", "173", "174", "175", "176", "177", "178", 
"179", "180", "181", "182", "183", "184", "185", "186", "187", 
"188", "189", "190", "191", "192", "193", "194", "195", "196", 
"197", "198", "199", "200", "201", "202", "203", "204", "205", 
"206", "207", "208", "209", "210", "211", "212", "213", "214", 
"215", "216", "217", "218", "219", "220", "221", "222", "223", 
"224", "225"), class = "data.frame") }


"Vancouver" = 
function() {
structure(list(Vancouver = structure(as.integer(c(1, 2, 3, 4, 
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 
38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 
54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 
140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 
153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 
166, 167, 168, 169, 170, 171, 172, 173, 174)), 
.Label = c("1918-04-14 10:00:00", 
"1918-10-31 09:00:00", "1942-02-09 10:00:00", "1945-09-30 09:00:00", 
"1946-04-28 10:00:00", "1946-10-13 09:00:00", "1947-04-27 10:00:00", 
"1947-09-28 09:00:00", "1948-04-25 10:00:00", "1948-09-26 09:00:00", 
"1949-04-24 10:00:00", "1949-09-25 09:00:00", "1950-04-30 10:00:00", 
"1950-09-24 09:00:00", "1951-04-29 10:00:00", "1951-09-30 09:00:00", 
"1952-04-27 10:00:00", "1952-09-28 09:00:00", "1953-04-26 10:00:00", 
"1953-09-27 09:00:00", "1954-04-25 10:00:00", "1954-09-26 09:00:00", 
"1955-04-24 10:00:00", "1955-09-25 09:00:00", "1956-04-29 10:00:00", 
"1956-09-30 09:00:00", "1957-04-28 10:00:00", "1957-09-29 09:00:00", 
"1958-04-27 10:00:00", "1958-09-28 09:00:00", "1959-04-26 10:00:00", 
"1959-09-27 09:00:00", "1960-04-24 10:00:00", "1960-09-25 09:00:00", 
"1961-04-30 10:00:00", "1961-09-24 09:00:00", "1962-04-29 10:00:00", 
"1962-10-28 09:00:00", "1963-04-28 10:00:00", "1963-10-27 09:00:00", 
"1964-04-26 10:00:00", "1964-10-25 09:00:00", "1965-04-25 10:00:00", 
"1965-10-31 09:00:00", "1966-04-24 10:00:00", "1966-10-30 09:00:00", 
"1967-04-30 10:00:00", "1967-10-29 09:00:00", "1968-04-28 10:00:00", 
"1968-10-27 09:00:00", "1969-04-27 10:00:00", "1969-10-26 09:00:00", 
"1970-04-26 10:00:00", "1970-10-25 09:00:00", "1971-04-25 10:00:00", 
"1971-10-31 09:00:00", "1972-04-30 10:00:00", "1972-10-29 09:00:00", 
"1973-04-29 10:00:00", "1973-10-28 09:00:00", "1974-04-28 10:00:00", 
"1974-10-27 09:00:00", "1975-04-27 10:00:00", "1975-10-26 09:00:00", 
"1976-04-25 10:00:00", "1976-10-31 09:00:00", "1977-04-24 10:00:00", 
"1977-10-30 09:00:00", "1978-04-30 10:00:00", "1978-10-29 09:00:00", 
"1979-04-29 10:00:00", "1979-10-28 09:00:00", "1980-04-27 10:00:00", 
"1980-10-26 09:00:00", "1981-04-26 10:00:00", "1981-10-25 09:00:00", 
"1982-04-25 10:00:00", "1982-10-31 09:00:00", "1983-04-24 10:00:00", 
"1983-10-30 09:00:00", "1984-04-29 10:00:00", "1984-10-28 09:00:00", 
"1985-04-28 10:00:00", "1985-10-27 09:00:00", "1986-04-27 10:00:00", 
"1986-10-26 09:00:00", "1987-04-05 10:00:00", "1987-10-25 09:00:00", 
"1988-04-03 10:00:00", "1988-10-30 09:00:00", "1989-04-02 10:00:00", 
"1989-10-29 09:00:00", "1990-04-01 10:00:00", "1990-10-28 09:00:00", 
"1991-04-07 10:00:00", "1991-10-27 09:00:00", "1992-04-05 10:00:00", 
"1992-10-25 09:00:00", "1993-04-04 10:00:00", "1993-10-31 09:00:00", 
"1994-04-03 10:00:00", "1994-10-30 09:00:00", "1995-04-02 10:00:00", 
"1995-10-29 09:00:00", "1996-04-07 10:00:00", "1996-10-27 09:00:00", 
"1997-04-06 10:00:00", "1997-10-26 09:00:00", "1998-04-05 10:00:00", 
"1998-10-25 09:00:00", "1999-04-04 10:00:00", "1999-10-31 09:00:00", 
"2000-04-02 10:00:00", "2000-10-29 09:00:00", "2001-04-01 10:00:00", 
"2001-10-28 09:00:00", "2002-04-07 10:00:00", "2002-10-27 09:00:00", 
"2003-04-06 10:00:00", "2003-10-26 09:00:00", "2004-04-04 10:00:00", 
"2004-10-31 09:00:00", "2005-04-03 10:00:00", "2005-10-30 09:00:00", 
"2006-04-02 10:00:00", "2006-10-29 09:00:00", "2007-04-01 10:00:00", 
"2007-10-28 09:00:00", "2008-04-06 10:00:00", "2008-10-26 09:00:00", 
"2009-04-05 10:00:00", "2009-10-25 09:00:00", "2010-04-04 10:00:00", 
"2010-10-31 09:00:00", "2011-04-03 10:00:00", "2011-10-30 09:00:00", 
"2012-04-01 10:00:00", "2012-10-28 09:00:00", "2013-04-07 10:00:00", 
"2013-10-27 09:00:00", "2014-04-06 10:00:00", "2014-10-26 09:00:00", 
"2015-04-05 10:00:00", "2015-10-25 09:00:00", "2016-04-03 10:00:00", 
"2016-10-30 09:00:00", "2017-04-02 10:00:00", "2017-10-29 09:00:00", 
"2018-04-01 10:00:00", "2018-10-28 09:00:00", "2019-04-07 10:00:00", 
"2019-10-27 09:00:00", "2020-04-05 10:00:00", "2020-10-25 09:00:00", 
"2021-04-04 10:00:00", "2021-10-31 09:00:00", "2022-04-03 10:00:00", 
"2022-10-30 09:00:00", "2023-04-02 10:00:00", "2023-10-29 09:00:00", 
"2024-04-07 10:00:00", "2024-10-27 09:00:00", "2025-04-06 10:00:00", 
"2025-10-26 09:00:00", "2026-04-05 10:00:00", "2026-10-25 09:00:00", 
"2027-04-04 10:00:00", "2027-10-31 09:00:00", "2028-04-02 10:00:00", 
"2028-10-29 09:00:00", "2029-04-01 10:00:00", "2029-10-28 09:00:00", 
"2030-04-07 10:00:00", "2030-10-27 09:00:00"), class = "factor"), 
offSet = c(-25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800, 
-25200, -28800, -25200, -28800, -25200, -28800, -25200, -28800
)), .Names = c("Vancouver", "offSet"), row.names = c("1", 
"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
"14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
"25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", 
"36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", 
"47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", 
"58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", 
"69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", 
"80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", 
"91", "92", "93", "94", "95", "96", "97", "98", "99", "100", 
"101", "102", "103", "104", "105", "106", "107", "108", "109", 
"110", "111", "112", "113", "114", "115", "116", "117", "118", 
"119", "120", "121", "122", "123", "124", "125", "126", "127", 
"128", "129", "130", "131", "132", "133", "134", "135", "136", 
"137", "138", "139", "140", "141", "142", "143", "144", "145", 
"146", "147", "148", "149", "150", "151", "152", "153", "154", 
"155", "156", "157", "158", "159", "160", "161", "162", "163", 
"164", "165", "166", "167", "168", "169", "170", "171", "172", 
"173", "174"), class = "data.frame") }


"Winnipeg" = 
function() {
structure(list(Winnipeg = structure(as.integer(c(1, 2, 3, 4, 
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 
38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 
54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 
140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 
153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 
166, 167, 168, 169, 170)), .Label = c("1916-04-23 06:00:00", 
"1916-09-17 05:00:00", "1918-04-14 08:00:00", "1918-10-31 07:00:00", 
"1937-05-16 08:00:00", "1937-09-26 07:00:00", "1942-02-09 08:00:00", 
"1945-09-30 07:00:00", "1946-05-12 08:00:00", "1946-10-13 07:00:00", 
"1947-04-27 08:00:00", "1947-09-28 07:00:00", "1948-04-25 08:00:00", 
"1948-09-26 07:00:00", "1949-04-24 08:00:00", "1949-09-25 07:00:00", 
"1950-05-01 08:00:00", "1950-09-30 07:00:00", "1951-04-29 08:00:00", 
"1951-09-30 07:00:00", "1952-04-27 08:00:00", "1952-09-28 07:00:00", 
"1953-04-26 08:00:00", "1953-09-27 07:00:00", "1954-04-25 08:00:00", 
"1954-09-26 07:00:00", "1955-04-24 08:00:00", "1955-09-25 07:00:00", 
"1956-04-29 08:00:00", "1956-09-30 07:00:00", "1957-04-28 08:00:00", 
"1957-09-29 07:00:00", "1958-04-27 08:00:00", "1958-09-28 07:00:00", 
"1959-04-26 08:00:00", "1959-10-25 07:00:00", "1960-04-24 08:00:00", 
"1960-09-25 07:00:00", "1963-04-28 08:00:00", "1963-09-22 07:00:00", 
"1966-04-24 08:00:00", "1966-10-30 07:00:00", "1967-04-30 08:00:00", 
"1967-10-29 07:00:00", "1968-04-28 08:00:00", "1968-10-27 07:00:00", 
"1969-04-27 08:00:00", "1969-10-26 07:00:00", "1970-04-26 08:00:00", 
"1970-10-25 07:00:00", "1971-04-25 08:00:00", "1971-10-31 07:00:00", 
"1972-04-30 08:00:00", "1972-10-29 07:00:00", "1973-04-29 08:00:00", 
"1973-10-28 07:00:00", "1974-04-28 08:00:00", "1974-10-27 07:00:00", 
"1975-04-27 08:00:00", "1975-10-26 07:00:00", "1976-04-25 08:00:00", 
"1976-10-31 07:00:00", "1977-04-24 08:00:00", "1977-10-30 07:00:00", 
"1978-04-30 08:00:00", "1978-10-29 07:00:00", "1979-04-29 08:00:00", 
"1979-10-28 07:00:00", "1980-04-27 08:00:00", "1980-10-26 07:00:00", 
"1981-04-26 08:00:00", "1981-10-25 07:00:00", "1982-04-25 08:00:00", 
"1982-10-31 07:00:00", "1983-04-24 08:00:00", "1983-10-30 07:00:00", 
"1984-04-29 08:00:00", "1984-10-28 07:00:00", "1985-04-28 08:00:00", 
"1985-10-27 07:00:00", "1986-04-27 08:00:00", "1986-10-26 07:00:00", 
"1987-04-05 08:00:00", "1987-10-25 08:00:00", "1988-04-03 08:00:00", 
"1988-10-30 08:00:00", "1989-04-02 08:00:00", "1989-10-29 08:00:00", 
"1990-04-01 08:00:00", "1990-10-28 08:00:00", "1991-04-07 08:00:00", 
"1991-10-27 08:00:00", "1992-04-05 08:00:00", "1992-10-25 08:00:00", 
"1993-04-04 08:00:00", "1993-10-31 08:00:00", "1994-04-03 08:00:00", 
"1994-10-30 08:00:00", "1995-04-02 08:00:00", "1995-10-29 08:00:00", 
"1996-04-07 08:00:00", "1996-10-27 08:00:00", "1997-04-06 08:00:00", 
"1997-10-26 08:00:00", "1998-04-05 08:00:00", "1998-10-25 08:00:00", 
"1999-04-04 08:00:00", "1999-10-31 08:00:00", "2000-04-02 08:00:00", 
"2000-10-29 08:00:00", "2001-04-01 08:00:00", "2001-10-28 08:00:00", 
"2002-04-07 08:00:00", "2002-10-27 08:00:00", "2003-04-06 08:00:00", 
"2003-10-26 08:00:00", "2004-04-04 08:00:00", "2004-10-31 08:00:00", 
"2005-04-03 08:00:00", "2005-10-30 08:00:00", "2006-04-02 08:00:00", 
"2006-10-29 08:00:00", "2007-04-01 08:00:00", "2007-10-28 08:00:00", 
"2008-04-06 08:00:00", "2008-10-26 08:00:00", "2009-04-05 08:00:00", 
"2009-10-25 08:00:00", "2010-04-04 08:00:00", "2010-10-31 08:00:00", 
"2011-04-03 08:00:00", "2011-10-30 08:00:00", "2012-04-01 08:00:00", 
"2012-10-28 08:00:00", "2013-04-07 08:00:00", "2013-10-27 08:00:00", 
"2014-04-06 08:00:00", "2014-10-26 08:00:00", "2015-04-05 08:00:00", 
"2015-10-25 08:00:00", "2016-04-03 08:00:00", "2016-10-30 08:00:00", 
"2017-04-02 08:00:00", "2017-10-29 08:00:00", "2018-04-01 08:00:00", 
"2018-10-28 08:00:00", "2019-04-07 08:00:00", "2019-10-27 08:00:00", 
"2020-04-05 08:00:00", "2020-10-25 08:00:00", "2021-04-04 08:00:00", 
"2021-10-31 08:00:00", "2022-04-03 08:00:00", "2022-10-30 08:00:00", 
"2023-04-02 08:00:00", "2023-10-29 08:00:00", "2024-04-07 08:00:00", 
"2024-10-27 08:00:00", "2025-04-06 08:00:00", "2025-10-26 08:00:00", 
"2026-04-05 08:00:00", "2026-10-25 08:00:00", "2027-04-04 08:00:00", 
"2027-10-31 08:00:00", "2028-04-02 08:00:00", "2028-10-29 08:00:00", 
"2029-04-01 08:00:00", "2029-10-28 08:00:00", "2030-04-07 08:00:00", 
"2030-10-27 08:00:00"), class = "factor"), offSet = c(-18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600, -18000, -21600, -18000, -21600, -18000, -21600, -18000, 
-21600)), .Names = c("Winnipeg", "offSet"), row.names = c("1", 
"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
"14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
"25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", 
"36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", 
"47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", 
"58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", 
"69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", 
"80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", 
"91", "92", "93", "94", "95", "96", "97", "98", "99", "100", 
"101", "102", "103", "104", "105", "106", "107", "108", "109", 
"110", "111", "112", "113", "114", "115", "116", "117", "118", 
"119", "120", "121", "122", "123", "124", "125", "126", "127", 
"128", "129", "130", "131", "132", "133", "134", "135", "136", 
"137", "138", "139", "140", "141", "142", "143", "144", "145", 
"146", "147", "148", "149", "150", "151", "152", "153", "154", 
"155", "156", "157", "158", "159", "160", "161", "162", "163", 
"164", "165", "166", "167", "168", "169", "170"), class = "data.frame") }


# ASIA -------------------------------------------------------------------------



"Bahrain" = 
function() {
structure(list(Bahrain = structure(as.integer(1), 
.Label = "1972-05-31 20:00:00", class = "factor"), offSet = 10800), 
.Names = c("Bahrain", "offSet"), row.names = "1", class = "data.frame") }


"Bangkok" = 
function() {
structure(list(Bangkok = structure(as.integer(1), 
.Label = "1920-03-31 17:17:56", class = "factor"), offSet = 25200), 
.Names = c("Bangkok", "offSet"), row.names = "1", class = "data.frame") }


"Beirut" = 
function() {
structure(list(Beirut = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 
71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126)), 
.Label = c("1920-03-27 22:00:00", 
"1920-10-24 21:00:00", "1921-04-02 22:00:00", "1921-10-02 21:00:00", 
"1922-03-25 22:00:00", "1922-10-07 21:00:00", "1923-04-21 22:00:00", 
"1923-09-15 21:00:00", "1957-04-30 22:00:00", "1957-09-30 21:00:00", 
"1958-04-30 22:00:00", "1958-09-30 21:00:00", "1959-04-30 22:00:00", 
"1959-09-30 21:00:00", "1960-04-30 22:00:00", "1960-09-30 21:00:00", 
"1961-04-30 22:00:00", "1961-09-30 21:00:00", "1972-06-21 22:00:00", 
"1972-09-30 21:00:00", "1973-04-30 22:00:00", "1973-09-30 21:00:00", 
"1974-04-30 22:00:00", "1974-09-30 21:00:00", "1975-04-30 22:00:00", 
"1975-09-30 21:00:00", "1976-04-30 22:00:00", "1976-09-30 21:00:00", 
"1977-04-30 22:00:00", "1977-09-30 21:00:00", "1978-04-29 22:00:00", 
"1978-09-29 21:00:00", "1984-04-30 22:00:00", "1984-10-15 21:00:00", 
"1985-04-30 22:00:00", "1985-10-15 21:00:00", "1986-04-30 22:00:00", 
"1986-10-15 21:00:00", "1987-04-30 22:00:00", "1987-10-15 21:00:00", 
"1988-05-31 22:00:00", "1988-10-15 21:00:00", "1989-05-09 22:00:00", 
"1989-10-15 21:00:00", "1990-04-30 22:00:00", "1990-10-15 21:00:00", 
"1991-04-30 22:00:00", "1991-10-15 21:00:00", "1992-04-30 22:00:00", 
"1992-10-03 21:00:00", "1993-03-27 22:00:00", "1993-09-25 21:00:00", 
"1994-03-26 22:00:00", "1994-09-24 21:00:00", "1995-03-25 22:00:00", 
"1995-09-23 21:00:00", "1996-03-30 22:00:00", "1996-09-28 21:00:00", 
"1997-03-29 22:00:00", "1997-09-27 21:00:00", "1998-03-28 22:00:00", 
"1998-09-26 21:00:00", "1999-03-27 22:00:00", "1999-10-30 21:00:00", 
"2000-03-25 22:00:00", "2000-10-28 21:00:00", "2001-03-24 22:00:00", 
"2001-10-27 21:00:00", "2002-03-30 22:00:00", "2002-10-26 21:00:00", 
"2003-03-29 22:00:00", "2003-10-25 21:00:00", "2004-03-27 22:00:00", 
"2004-10-30 21:00:00", "2005-03-26 22:00:00", "2005-10-29 21:00:00", 
"2006-03-25 22:00:00", "2006-10-28 21:00:00", "2007-03-24 22:00:00", 
"2007-10-27 21:00:00", "2008-03-29 22:00:00", "2008-10-25 21:00:00", 
"2009-03-28 22:00:00", "2009-10-24 21:00:00", "2010-03-27 22:00:00", 
"2010-10-30 21:00:00", "2011-03-26 22:00:00", "2011-10-29 21:00:00", 
"2012-03-24 22:00:00", "2012-10-27 21:00:00", "2013-03-30 22:00:00", 
"2013-10-26 21:00:00", "2014-03-29 22:00:00", "2014-10-25 21:00:00", 
"2015-03-28 22:00:00", "2015-10-24 21:00:00", "2016-03-26 22:00:00", 
"2016-10-29 21:00:00", "2017-03-25 22:00:00", "2017-10-28 21:00:00", 
"2018-03-24 22:00:00", "2018-10-27 21:00:00", "2019-03-30 22:00:00", 
"2019-10-26 21:00:00", "2020-03-28 22:00:00", "2020-10-24 21:00:00", 
"2021-03-27 22:00:00", "2021-10-30 21:00:00", "2022-03-26 22:00:00", 
"2022-10-29 21:00:00", "2023-03-25 22:00:00", "2023-10-28 21:00:00", 
"2024-03-30 22:00:00", "2024-10-26 21:00:00", "2025-03-29 22:00:00", 
"2025-10-25 21:00:00", "2026-03-28 22:00:00", "2026-10-24 21:00:00", 
"2027-03-27 22:00:00", "2027-10-30 21:00:00", "2028-03-25 22:00:00", 
"2028-10-28 21:00:00", "2029-03-24 22:00:00", "2029-10-27 21:00:00", 
"2030-03-30 22:00:00", "2030-10-26 21:00:00"), class = "factor"), 
offSet = c(10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200)), .Names = c("Beirut", "offSet"), row.names = c("1", 
"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
"14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
"25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", 
"36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", 
"47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", 
"58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", 
"69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", 
"80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", 
"91", "92", "93", "94", "95", "96", "97", "98", "99", "100", 
"101", "102", "103", "104", "105", "106", "107", "108", "109", 
"110", "111", "112", "113", "114", "115", "116", "117", "118", 
"119", "120", "121", "122", "123", "124", "125", "126"), class = "data.frame") }


"Calcutta" = 
function() {
structure(list(Calcutta = structure(as.integer(c(1, 2, 3, 4)), 
.Label = c("1941-09-30 18:06:40", 
"1942-05-14 17:30:00", "1942-08-31 18:30:00", "1945-10-14 17:30:00"
), class = "factor"), offSet = c(23400, 19800, 23400, 19800)), 
.Names = c("Calcutta", 
"offSet"), row.names = c("1", "2", "3", "4"), class = "data.frame") }


"Dubai" = 
function() {
structure(list(Dubai = structure(as.integer(1), 
.Label = "1919-12-31 20:18:48", class = "factor"), offSet = 14400), 
.Names = c("Dubai", "offSet"), row.names = "1", class = "data.frame") }


"HongKong" = 
function() {
structure(list(HongKong = structure(as.integer(c(1, 2, 3, 4, 
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 
38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 
54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68)), 
.Label = c("1946-04-19 19:30:00", 
"1946-11-30 18:30:00", "1947-04-12 19:30:00", "1947-12-29 18:30:00", 
"1948-05-01 19:30:00", "1948-10-30 18:30:00", "1949-04-02 19:30:00", 
"1949-10-29 18:30:00", "1950-04-01 19:30:00", "1950-10-28 18:30:00", 
"1951-03-31 19:30:00", "1951-10-27 18:30:00", "1952-04-05 19:30:00", 
"1952-10-25 18:30:00", "1953-04-04 19:30:00", "1953-10-31 18:30:00", 
"1954-03-20 19:30:00", "1954-10-30 18:30:00", "1955-03-19 19:30:00", 
"1955-11-05 18:30:00", "1956-03-17 19:30:00", "1956-11-03 18:30:00", 
"1957-03-23 19:30:00", "1957-11-02 18:30:00", "1958-03-22 19:30:00", 
"1958-11-01 18:30:00", "1959-03-21 19:30:00", "1959-10-31 18:30:00", 
"1960-03-19 19:30:00", "1960-11-05 18:30:00", "1961-03-18 19:30:00", 
"1961-11-04 18:30:00", "1962-03-17 19:30:00", "1962-11-03 18:30:00", 
"1963-03-23 19:30:00", "1963-11-02 18:30:00", "1964-03-21 19:30:00", 
"1964-10-31 18:30:00", "1965-04-17 19:30:00", "1965-10-16 18:30:00", 
"1966-04-16 19:30:00", "1966-10-15 18:30:00", "1967-04-15 19:30:00", 
"1967-10-21 18:30:00", "1968-04-20 19:30:00", "1968-10-19 18:30:00", 
"1969-04-19 19:30:00", "1969-10-18 18:30:00", "1970-04-18 19:30:00", 
"1970-10-17 18:30:00", "1971-04-17 19:30:00", "1971-10-16 18:30:00", 
"1972-04-15 19:30:00", "1972-10-21 18:30:00", "1973-04-21 19:30:00", 
"1973-10-20 18:30:00", "1974-04-20 19:30:00", "1974-10-19 18:30:00", 
"1975-04-19 19:30:00", "1975-10-18 18:30:00", "1976-04-17 19:30:00", 
"1976-10-16 18:30:00", "1977-04-16 19:30:00", "1977-10-15 18:30:00", 
"1979-05-12 19:30:00", "1979-10-20 18:30:00", "1980-05-10 19:30:00", 
"1980-10-18 18:30:00"), class = "factor"), offSet = c(32400, 
28800, 32400, 28800, 32400, 28800, 32400, 28800, 32400, 28800, 
32400, 28800, 32400, 28800, 32400, 28800, 32400, 28800, 32400, 
28800, 32400, 28800, 32400, 28800, 32400, 28800, 32400, 28800, 
32400, 28800, 32400, 28800, 32400, 28800, 32400, 28800, 32400, 
28800, 32400, 28800, 32400, 28800, 32400, 28800, 32400, 28800, 
32400, 28800, 32400, 28800, 32400, 28800, 32400, 28800, 32400, 
28800, 32400, 28800, 32400, 28800, 32400, 28800, 32400, 28800, 
32400, 28800, 32400, 28800)), .Names = c("Hong_Kong", "offSet"
), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", "9", 
"10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", 
"21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", 
"32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", 
"43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", 
"54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", 
"65", "66", "67", "68"), class = "data.frame") }


"Jakarta" = 
function() {
structure(list(Jakarta = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7)), .Label = c("1923-12-31 16:40:00", "1932-10-31 16:40:00", 
"1942-03-22 16:30:00", "1945-07-31 15:00:00", "1948-04-30 16:30:00", 
"1950-04-30 16:00:00", "1963-12-31 16:30:00"), class = "factor"), 
offSet = c(26400, 27000, 32400, 27000, 28800, 27000, 25200
)), .Names = c("Jakarta", "offSet"), row.names = c("1", "2", 
"3", "4", "5", "6", "7"), class = "data.frame") }


"Jerusalem" = 
function() {
structure(list(Jerusalem = structure(as.integer(c(1, 2, 3, NA, 
4, 5, 6, 7, 8, NA, 9, 10, 11, 12, 13, 14, 15, NA, 16, NA, NA, 
NA, NA, NA, 17, 18, NA, 19, 20, NA, NA, 21, 22, 23, 24, 25, 26, 
27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 
43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, NA, 54, NA, 55, 56, 
57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 
73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 
89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 
104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115)), 
.Label = c("1917-12-31 21:39:20", 
"1940-05-31 22:00:00", "1942-10-31 21:00:00", "1943-10-31 21:00:00", 
"1944-03-31 22:00:00", "1944-10-31 21:00:00", "1945-04-15 22:00:00", 
"1945-10-31 23:00:00", "1946-10-31 21:00:00", "1948-05-22 22:00:00", 
"1948-08-31 20:00:00", "1948-10-31 23:00:00", "1949-04-30 22:00:00", 
"1949-10-31 23:00:00", "1950-04-15 22:00:00", "1951-03-31 22:00:00", 
"1954-06-12 22:00:00", "1954-09-11 21:00:00", "1955-09-10 21:00:00", 
"1956-06-02 22:00:00", "1957-09-21 21:00:00", "1974-07-06 22:00:00", 
"1974-10-12 21:00:00", "1975-04-19 22:00:00", "1975-08-30 21:00:00", 
"1985-04-13 22:00:00", "1985-09-14 21:00:00", "1986-05-17 22:00:00", 
"1986-09-06 21:00:00", "1987-04-14 22:00:00", "1987-09-12 21:00:00", 
"1988-04-08 22:00:00", "1988-09-02 21:00:00", "1989-04-29 22:00:00", 
"1989-09-02 21:00:00", "1990-03-24 22:00:00", "1990-08-25 21:00:00", 
"1991-03-23 22:00:00", "1991-08-31 21:00:00", "1992-03-28 22:00:00", 
"1992-09-05 21:00:00", "1993-04-01 22:00:00", "1993-09-04 21:00:00", 
"1994-03-31 22:00:00", "1994-08-27 21:00:00", "1995-03-30 22:00:00", 
"1995-09-02 21:00:00", "1996-03-14 22:00:00", "1996-09-15 21:00:00", 
"1997-03-20 22:00:00", "1997-09-13 21:00:00", "1998-03-19 22:00:00", 
"1998-09-05 21:00:00", "1999-09-02 23:00:00", "2000-10-05 22:00:00", 
"2001-04-08 23:00:00", "2001-09-23 22:00:00", "2002-03-28 23:00:00", 
"2002-10-06 22:00:00", "2003-03-27 23:00:00", "2003-10-02 22:00:00", 
"2004-04-06 23:00:00", "2004-09-21 22:00:00", "2005-03-31 23:00:00", 
"2005-09-30 22:00:00", "2006-03-31 23:00:00", "2006-09-30 22:00:00", 
"2007-03-31 23:00:00", "2007-09-30 22:00:00", "2008-03-31 23:00:00", 
"2008-09-30 22:00:00", "2009-03-31 23:00:00", "2009-09-30 22:00:00", 
"2010-03-31 23:00:00", "2010-09-30 22:00:00", "2011-03-31 23:00:00", 
"2011-09-30 22:00:00", "2012-03-31 23:00:00", "2012-09-30 22:00:00", 
"2013-03-31 23:00:00", "2013-09-30 22:00:00", "2014-03-31 23:00:00", 
"2014-09-30 22:00:00", "2015-03-31 23:00:00", "2015-09-30 22:00:00", 
"2016-03-31 23:00:00", "2016-09-30 22:00:00", "2017-03-31 23:00:00", 
"2017-09-30 22:00:00", "2018-03-31 23:00:00", "2018-09-30 22:00:00", 
"2019-03-31 23:00:00", "2019-09-30 22:00:00", "2020-03-31 23:00:00", 
"2020-09-30 22:00:00", "2021-03-31 23:00:00", "2021-09-30 22:00:00", 
"2022-03-31 23:00:00", "2022-09-30 22:00:00", "2023-03-31 23:00:00", 
"2023-09-30 22:00:00", "2024-03-31 23:00:00", "2024-09-30 22:00:00", 
"2025-03-31 23:00:00", "2025-09-30 22:00:00", "2026-03-31 23:00:00", 
"2026-09-30 22:00:00", "2027-03-31 23:00:00", "2027-09-30 22:00:00", 
"2028-03-31 23:00:00", "2028-09-30 22:00:00", "2029-03-31 23:00:00", 
"2029-09-30 22:00:00", "2030-03-31 23:00:00", "2030-09-30 22:00:00"
), class = "factor"), offSet = c(7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 14400, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200)), .Names = c("Jerusalem", "offSet"), row.names = c("1", 
"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
"14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
"25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", 
"36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", 
"47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", 
"58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", 
"69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", 
"80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", 
"91", "92", "93", "94", "95", "96", "97", "98", "99", "100", 
"101", "102", "103", "104", "105", "106", "107", "108", "109", 
"110", "111", "112", "113", "114", "115", "116", "117", "118", 
"119", "120", "121", "122", "123", "124", "125", "126", "127", 
"128"), class = "data.frame") }


"KualaLumpur" = 
function() {
structure(list(KualaLumpur = structure(as.integer(c(1, 2, 3, 
4, 5, 6)), .Label = c("1905-05-31 17:04:36", "1932-12-31 17:00:00", 
"1942-02-14 16:40:00", "1945-09-01 15:00:00", "1949-12-31 16:40:00", 
"1982-04-30 16:30:00"), class = "factor"), offSet = c(25200, 
26400, 32400, 26400, 27000, 28800)), .Names = c("Kuala_Lumpur", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6"), class = "data.frame") }


"Kuwait" = 
function() {
structure(list(Kuwait = structure(as.integer(1), 
.Label = "1949-12-31 20:48:04", class = "factor"), offSet = 10800), 
.Names = c("Kuwait", "offSet"), row.names = "1", class = "data.frame") }


"Manila" = 
function() {
structure(list(Manila = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9)), .Label = c("1899-05-10 15:56:00", "1936-10-31 16:00:00", 
"1937-01-31 15:00:00", "1942-04-30 16:00:00", "1944-10-31 15:00:00", 
"1954-04-11 16:00:00", "1954-06-30 15:00:00", "1978-03-21 16:00:00", 
"1978-09-20 15:00:00"), class = "factor"), offSet = c(28800, 
32400, 28800, 32400, 28800, 32400, 28800, 32400, 28800)), .Names = c("Manila", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", 
"9"), class = "data.frame") }


"Riyadh" = 
function() {
structure(list(Riyadh = structure(as.integer(1), 
.Label = "1949-12-31 20:53:08", class = "factor"), offSet = 10800), 
.Names = c("Riyadh", "offSet"), row.names = "1", class = "data.frame") }


"Seoul" = 
function() {
structure(list(Seoul = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12)), 
.Label = c("1904-11-30 15:30:00", "1927-12-31 15:00:00", 
"1931-12-31 15:30:00", "1954-03-20 15:00:00", "1960-05-14 16:00:00", 
"1960-09-12 15:00:00", "1961-08-09 16:00:00", "1968-09-30 15:30:00", 
"1987-05-09 15:00:00", "1987-10-10 14:00:00", "1988-05-07 15:00:00", 
"1988-10-08 14:00:00"), class = "factor"), offSet = c(32400, 
30600, 32400, 28800, 32400, 28800, 30600, 32400, 36000, 32400, 
36000, 32400)), .Names = c("Seoul", "offSet"), row.names = c("1", 
"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"), 
class = "data.frame") }


"Shanghai" = 
function() {
structure(list(Shanghai = structure(as.integer(c(1, 2, 3, 4, 
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17)), 
.Label = c("1940-06-02 16:00:00", 
"1940-09-30 15:00:00", "1941-03-15 16:00:00", "1941-09-30 15:00:00", 
"1948-12-31 16:00:00", "1986-05-03 16:00:00", "1986-09-13 15:00:00", 
"1987-04-11 16:00:00", "1987-09-12 15:00:00", "1988-04-09 16:00:00", 
"1988-09-10 15:00:00", "1989-04-15 16:00:00", "1989-09-16 15:00:00", 
"1990-04-14 16:00:00", "1990-09-15 15:00:00", "1991-04-13 16:00:00", 
"1991-09-14 15:00:00"), class = "factor"), offSet = c(32400, 
28800, 32400, 28800, 28800, 32400, 28800, 32400, 28800, 32400, 
28800, 32400, 28800, 32400, 28800, 32400, 28800)), .Names = c("Shanghai", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", 
"9", "10", "11", "12", "13", "14", "15", "16", "17"), class = "data.frame") }


"Singapore" = 
function() {
structure(list(Singapore = structure(as.integer(c(1, 2, 3, 4, 
5, 6, 7)), .Label = c("1905-05-31 17:04:36", "1932-12-31 17:00:00", 
"1942-02-14 16:40:00", "1945-09-01 15:00:00", "1949-12-31 16:40:00", 
"1965-08-08 16:30:00", "1982-04-30 16:30:00"), class = "factor"), 
offSet = c(25200, 26400, 32400, 26400, 27000, 27000, 28800
)), .Names = c("Singapore", "offSet"), row.names = c("1", 
"2", "3", "4", "5", "6", "7"), class = "data.frame") }


"Taipei" = 
function() {
structure(list(Taipei = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
39, 40)), .Label = c("1945-04-30 16:00:00", "1945-09-30 15:00:00", 
"1946-04-30 16:00:00", "1946-09-30 15:00:00", "1947-04-30 16:00:00", 
"1947-09-30 15:00:00", "1948-04-30 16:00:00", "1948-09-30 15:00:00", 
"1949-04-30 16:00:00", "1949-09-30 15:00:00", "1950-04-30 16:00:00", 
"1950-09-30 15:00:00", "1951-04-30 16:00:00", "1951-09-30 15:00:00", 
"1952-02-29 16:00:00", "1952-10-31 15:00:00", "1953-03-31 16:00:00", 
"1953-10-31 15:00:00", "1954-03-31 16:00:00", "1954-10-31 15:00:00", 
"1955-03-31 16:00:00", "1955-09-30 15:00:00", "1956-03-31 16:00:00", 
"1956-09-30 15:00:00", "1957-03-31 16:00:00", "1957-09-30 15:00:00", 
"1958-03-31 16:00:00", "1958-09-30 15:00:00", "1959-03-31 16:00:00", 
"1959-09-30 15:00:00", "1960-05-31 16:00:00", "1960-09-30 15:00:00", 
"1961-05-31 16:00:00", "1961-09-30 15:00:00", "1974-03-31 16:00:00", 
"1974-09-30 15:00:00", "1975-03-31 16:00:00", "1975-09-30 15:00:00", 
"1980-06-29 16:00:00", "1980-09-29 15:00:00"), class = "factor"), 
offSet = c(32400, 28800, 32400, 28800, 32400, 28800, 32400, 
28800, 32400, 28800, 32400, 28800, 32400, 28800, 32400, 28800, 
32400, 28800, 32400, 28800, 32400, 28800, 32400, 28800, 32400, 
28800, 32400, 28800, 32400, 28800, 32400, 28800, 32400, 28800, 
32400, 28800, 32400, 28800, 32400, 28800)), .Names = c("Taipei", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", 
"9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
"20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", 
"31", "32", "33", "34", "35", "36", "37", "38", "39", "40"), 
class = "data.frame") }


"Tehran" = 
function() {
structure(list(Tehran = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 
71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
87, 88, 89)), .Label = c("1945-12-31 20:34:16", "1977-10-31 20:30:00", 
"1978-03-20 20:00:00", "1978-10-20 19:00:00", "1978-12-31 20:00:00", 
"1979-03-20 20:30:00", "1979-09-18 19:30:00", "1980-03-20 20:30:00", 
"1980-09-22 19:30:00", "1991-05-02 20:30:00", "1991-09-19 20:30:00", 
"1992-03-20 20:30:00", "1992-09-22 19:30:00", "1993-03-20 20:30:00", 
"1993-09-22 19:30:00", "1994-03-20 20:30:00", "1994-09-22 19:30:00", 
"1995-03-20 20:30:00", "1995-09-22 19:30:00", "1996-03-19 20:30:00", 
"1996-09-21 19:30:00", "1997-03-20 20:30:00", "1997-09-22 19:30:00", 
"1998-03-20 20:30:00", "1998-09-22 19:30:00", "1999-03-20 20:30:00", 
"1999-09-22 19:30:00", "2000-03-19 20:30:00", "2000-09-21 19:30:00", 
"2001-03-20 20:30:00", "2001-09-22 19:30:00", "2002-03-20 20:30:00", 
"2002-09-22 19:30:00", "2003-03-20 20:30:00", "2003-09-22 19:30:00", 
"2004-03-19 20:30:00", "2004-09-21 19:30:00", "2005-03-20 20:30:00", 
"2005-09-22 19:30:00", "2006-03-20 20:30:00", "2006-09-22 19:30:00", 
"2007-03-20 20:30:00", "2007-09-22 19:30:00", "2008-03-19 20:30:00", 
"2008-09-21 19:30:00", "2009-03-20 20:30:00", "2009-09-22 19:30:00", 
"2010-03-20 20:30:00", "2010-09-22 19:30:00", "2011-03-20 20:30:00", 
"2011-09-22 19:30:00", "2012-03-19 20:30:00", "2012-09-21 19:30:00", 
"2013-03-20 20:30:00", "2013-09-22 19:30:00", "2014-03-20 20:30:00", 
"2014-09-22 19:30:00", "2015-03-20 20:30:00", "2015-09-22 19:30:00", 
"2016-03-19 20:30:00", "2016-09-21 19:30:00", "2017-03-20 20:30:00", 
"2017-09-22 19:30:00", "2018-03-20 20:30:00", "2018-09-22 19:30:00", 
"2019-03-20 20:30:00", "2019-09-22 19:30:00", "2020-03-19 20:30:00", 
"2020-09-21 19:30:00", "2021-03-20 20:30:00", "2021-09-22 19:30:00", 
"2022-03-20 20:30:00", "2022-09-22 19:30:00", "2023-03-20 20:30:00", 
"2023-09-22 19:30:00", "2024-03-19 20:30:00", "2024-09-21 19:30:00", 
"2025-03-19 20:30:00", "2025-09-21 19:30:00", "2026-03-20 20:30:00", 
"2026-09-22 19:30:00", "2027-03-20 20:30:00", "2027-09-22 19:30:00", 
"2028-03-19 20:30:00", "2028-09-21 19:30:00", "2029-03-19 20:30:00", 
"2029-09-21 19:30:00", "2030-03-20 20:30:00", "2030-09-22 19:30:00"
), class = "factor"), offSet = c(12600, 14400, 18000, 14400, 
12600, 16200, 12600, 16200, 12600, 16200, 12600, 16200, 12600, 
16200, 12600, 16200, 12600, 16200, 12600, 16200, 12600, 16200, 
12600, 16200, 12600, 16200, 12600, 16200, 12600, 16200, 12600, 
16200, 12600, 16200, 12600, 16200, 12600, 16200, 12600, 16200, 
12600, 16200, 12600, 16200, 12600, 16200, 12600, 16200, 12600, 
16200, 12600, 16200, 12600, 16200, 12600, 16200, 12600, 16200, 
12600, 16200, 12600, 16200, 12600, 16200, 12600, 16200, 12600, 
16200, 12600, 16200, 12600, 16200, 12600, 16200, 12600, 16200, 
12600, 16200, 12600, 16200, 12600, 16200, 12600, 16200, 12600, 
16200, 12600, 16200, 12600)), .Names = c("Tehran", "offSet"), 
row.names = c("1", 
"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
"14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
"25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", 
"36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", 
"47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", 
"58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", 
"69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", 
"80", "81", "82", "83", "84", "85", "86", "87", "88", "89"), 
class = "data.frame") }


"Tokyo" = 
function() {
structure(list(Tokyo = structure(as.integer(c(1, 2)), 
.Label = c("1895-12-31 15:00:00", 
"1937-12-31 15:00:00"), class = "factor"), offSet = c(32400, 
32400)), .Names = c("Tokyo", "offSet"), row.names = c("1", "2"
), class = "data.frame") }


# AUSTRALIA --------------------------------------------------------------------


"Adelaide" = 
function() {
structure(list(Adelaide = structure(as.integer(c(1, 2, 3, 4, 
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 
38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 
54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
127, 128, 129)), .Label = c("1899-04-30 15:00:00", "1916-12-31 14:31:00", 
"1917-03-24 15:30:00", "1941-12-31 16:30:00", "1942-03-28 15:30:00", 
"1942-09-26 16:30:00", "1943-03-27 15:30:00", "1943-10-02 16:30:00", 
"1944-03-25 15:30:00", "1970-12-31 14:30:00", "1971-10-30 16:30:00", 
"1972-02-26 16:30:00", "1972-10-28 16:30:00", "1973-03-03 16:30:00", 
"1973-10-27 16:30:00", "1974-03-02 16:30:00", "1974-10-26 16:30:00", 
"1975-03-01 16:30:00", "1975-10-25 16:30:00", "1976-03-06 16:30:00", 
"1976-10-30 16:30:00", "1977-03-05 16:30:00", "1977-10-29 16:30:00", 
"1978-03-04 16:30:00", "1978-10-28 16:30:00", "1979-03-03 16:30:00", 
"1979-10-27 16:30:00", "1980-03-01 16:30:00", "1980-10-25 16:30:00", 
"1981-02-28 16:30:00", "1981-10-24 16:30:00", "1982-03-06 16:30:00", 
"1982-10-30 16:30:00", "1983-03-05 16:30:00", "1983-10-29 16:30:00", 
"1984-03-03 16:30:00", "1984-10-27 16:30:00", "1985-03-02 16:30:00", 
"1985-10-26 16:30:00", "1986-03-15 16:30:00", "1986-10-18 16:30:00", 
"1987-03-14 16:30:00", "1987-10-24 16:30:00", "1988-03-19 16:30:00", 
"1988-10-29 16:30:00", "1989-03-18 16:30:00", "1989-10-28 16:30:00", 
"1990-03-17 16:30:00", "1990-10-27 16:30:00", "1991-03-02 16:30:00", 
"1991-10-26 16:30:00", "1992-03-21 16:30:00", "1992-10-24 16:30:00", 
"1993-03-06 16:30:00", "1993-10-30 16:30:00", "1994-03-19 16:30:00", 
"1994-10-29 16:30:00", "1995-03-25 16:30:00", "1995-10-28 16:30:00", 
"1996-03-30 16:30:00", "1996-10-26 16:30:00", "1997-03-29 16:30:00", 
"1997-10-25 16:30:00", "1998-03-28 16:30:00", "1998-10-24 16:30:00", 
"1999-03-27 16:30:00", "1999-10-30 16:30:00", "2000-03-25 16:30:00", 
"2000-10-28 16:30:00", "2001-03-24 16:30:00", "2001-10-27 16:30:00", 
"2002-03-30 16:30:00", "2002-10-26 16:30:00", "2003-03-29 16:30:00", 
"2003-10-25 16:30:00", "2004-03-27 16:30:00", "2004-10-30 16:30:00", 
"2005-03-26 16:30:00", "2005-10-29 16:30:00", "2006-03-25 16:30:00", 
"2006-10-28 16:30:00", "2007-03-24 16:30:00", "2007-10-27 16:30:00", 
"2008-03-29 16:30:00", "2008-10-25 16:30:00", "2009-03-28 16:30:00", 
"2009-10-24 16:30:00", "2010-03-27 16:30:00", "2010-10-30 16:30:00", 
"2011-03-26 16:30:00", "2011-10-29 16:30:00", "2012-03-24 16:30:00", 
"2012-10-27 16:30:00", "2013-03-30 16:30:00", "2013-10-26 16:30:00", 
"2014-03-29 16:30:00", "2014-10-25 16:30:00", "2015-03-28 16:30:00", 
"2015-10-24 16:30:00", "2016-03-26 16:30:00", "2016-10-29 16:30:00", 
"2017-03-25 16:30:00", "2017-10-28 16:30:00", "2018-03-24 16:30:00", 
"2018-10-27 16:30:00", "2019-03-30 16:30:00", "2019-10-26 16:30:00", 
"2020-03-28 16:30:00", "2020-10-24 16:30:00", "2021-03-27 16:30:00", 
"2021-10-30 16:30:00", "2022-03-26 16:30:00", "2022-10-29 16:30:00", 
"2023-03-25 16:30:00", "2023-10-28 16:30:00", "2024-03-30 16:30:00", 
"2024-10-26 16:30:00", "2025-03-29 16:30:00", "2025-10-25 16:30:00", 
"2026-03-28 16:30:00", "2026-10-24 16:30:00", "2027-03-27 16:30:00", 
"2027-10-30 16:30:00", "2028-03-25 16:30:00", "2028-10-28 16:30:00", 
"2029-03-24 16:30:00", "2029-10-27 16:30:00", "2030-03-30 16:30:00", 
"2030-10-26 16:30:00"), class = "factor"), offSet = c(34200, 
37800, 34200, 37800, 34200, 37800, 34200, 37800, 34200, 34200, 
37800, 34200, 37800, 34200, 37800, 34200, 37800, 34200, 37800, 
34200, 37800, 34200, 37800, 34200, 37800, 34200, 37800, 34200, 
37800, 34200, 37800, 34200, 37800, 34200, 37800, 34200, 37800, 
34200, 37800, 34200, 37800, 34200, 37800, 34200, 37800, 34200, 
37800, 34200, 37800, 34200, 37800, 34200, 37800, 34200, 37800, 
34200, 37800, 34200, 37800, 34200, 37800, 34200, 37800, 34200, 
37800, 34200, 37800, 34200, 37800, 34200, 37800, 34200, 37800, 
34200, 37800, 34200, 37800, 34200, 37800, 34200, 37800, 34200, 
37800, 34200, 37800, 34200, 37800, 34200, 37800, 34200, 37800, 
34200, 37800, 34200, 37800, 34200, 37800, 34200, 37800, 34200, 
37800, 34200, 37800, 34200, 37800, 34200, 37800, 34200, 37800, 
34200, 37800, 34200, 37800, 34200, 37800, 34200, 37800, 34200, 
37800, 34200, 37800, 34200, 37800, 34200, 37800, 34200, 37800, 
34200, 37800)), .Names = c("Adelaide", "offSet"), row.names = c("1", 
"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
"14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
"25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", 
"36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", 
"47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", 
"58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", 
"69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", 
"80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", 
"91", "92", "93", "94", "95", "96", "97", "98", "99", "100", 
"101", "102", "103", "104", "105", "106", "107", "108", "109", 
"110", "111", "112", "113", "114", "115", "116", "117", "118", 
"119", "120", "121", "122", "123", "124", "125", "126", "127", 
"128", "129"), class = "data.frame") }


"Brisbane" = 
function() {
structure(list(Brisbane = structure(as.integer(c(1, 2, 3, 4, 
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17)), 
.Label = c("1916-12-31 14:01:00", 
"1917-03-24 15:00:00", "1941-12-31 16:00:00", "1942-03-28 15:00:00", 
"1942-09-26 16:00:00", "1943-03-27 15:00:00", "1943-10-02 16:00:00", 
"1944-03-25 15:00:00", "1970-12-31 14:00:00", "1971-10-30 16:00:00", 
"1972-02-26 16:00:00", "1989-10-28 16:00:00", "1990-03-03 16:00:00", 
"1990-10-27 16:00:00", "1991-03-02 16:00:00", "1991-10-26 16:00:00", 
"1992-02-29 16:00:00"), class = "factor"), offSet = c(39600, 
36000, 39600, 36000, 39600, 36000, 39600, 36000, 36000, 39600, 
36000, 39600, 36000, 39600, 36000, 39600, 36000)), .Names = c("Brisbane", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", 
"9", "10", "11", "12", "13", "14", "15", "16", "17"), class = "data.frame") }


"Darwin" = 
function() {
structure(list(Darwin = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9)), .Label = c("1899-04-30 15:00:00", "1916-12-31 14:31:00", 
"1917-03-24 15:30:00", "1941-12-31 16:30:00", "1942-03-28 15:30:00", 
"1942-09-26 16:30:00", "1943-03-27 15:30:00", "1943-10-02 16:30:00", 
"1944-03-25 15:30:00"), class = "factor"), offSet = c(34200, 
37800, 34200, 37800, 34200, 37800, 34200, 37800, 34200)), 
.Names = c("Darwin", "offSet"), row.names = c("1", "2", "3", "4", "5", 
"6", "7", "8", "9"), class = "data.frame") }


"Melbourne" = 
function() {
structure(list(Melbourne = structure(as.integer(c(1, 2, 3, 4, 
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 
38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 
54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
127, 128)), .Label = c("1916-12-31 14:01:00", "1917-03-24 15:00:00", 
"1941-12-31 16:00:00", "1942-03-28 15:00:00", "1942-09-26 16:00:00", 
"1943-03-27 15:00:00", "1943-10-02 16:00:00", "1944-03-25 15:00:00", 
"1970-12-31 14:00:00", "1971-10-30 16:00:00", "1972-02-26 16:00:00", 
"1972-10-28 16:00:00", "1973-03-03 16:00:00", "1973-10-27 16:00:00", 
"1974-03-02 16:00:00", "1974-10-26 16:00:00", "1975-03-01 16:00:00", 
"1975-10-25 16:00:00", "1976-03-06 16:00:00", "1976-10-30 16:00:00", 
"1977-03-05 16:00:00", "1977-10-29 16:00:00", "1978-03-04 16:00:00", 
"1978-10-28 16:00:00", "1979-03-03 16:00:00", "1979-10-27 16:00:00", 
"1980-03-01 16:00:00", "1980-10-25 16:00:00", "1981-02-28 16:00:00", 
"1981-10-24 16:00:00", "1982-03-06 16:00:00", "1982-10-30 16:00:00", 
"1983-03-05 16:00:00", "1983-10-29 16:00:00", "1984-03-03 16:00:00", 
"1984-10-27 16:00:00", "1985-03-02 16:00:00", "1985-10-26 16:00:00", 
"1986-03-15 16:00:00", "1986-10-18 16:00:00", "1987-03-14 16:00:00", 
"1987-10-17 16:00:00", "1988-03-19 16:00:00", "1988-10-29 16:00:00", 
"1989-03-18 16:00:00", "1989-10-28 16:00:00", "1990-03-17 16:00:00", 
"1990-10-27 16:00:00", "1991-03-02 16:00:00", "1991-10-26 16:00:00", 
"1992-02-29 16:00:00", "1992-10-24 16:00:00", "1993-03-06 16:00:00", 
"1993-10-30 16:00:00", "1994-03-05 16:00:00", "1994-10-29 16:00:00", 
"1995-03-25 16:00:00", "1995-10-28 16:00:00", "1996-03-30 16:00:00", 
"1996-10-26 16:00:00", "1997-03-29 16:00:00", "1997-10-25 16:00:00", 
"1998-03-28 16:00:00", "1998-10-24 16:00:00", "1999-03-27 16:00:00", 
"1999-10-30 16:00:00", "2000-03-25 16:00:00", "2000-08-26 16:00:00", 
"2001-03-24 16:00:00", "2001-10-27 16:00:00", "2002-03-30 16:00:00", 
"2002-10-26 16:00:00", "2003-03-29 16:00:00", "2003-10-25 16:00:00", 
"2004-03-27 16:00:00", "2004-10-30 16:00:00", "2005-03-26 16:00:00", 
"2005-10-29 16:00:00", "2006-03-25 16:00:00", "2006-10-28 16:00:00", 
"2007-03-24 16:00:00", "2007-10-27 16:00:00", "2008-03-29 16:00:00", 
"2008-10-25 16:00:00", "2009-03-28 16:00:00", "2009-10-24 16:00:00", 
"2010-03-27 16:00:00", "2010-10-30 16:00:00", "2011-03-26 16:00:00", 
"2011-10-29 16:00:00", "2012-03-24 16:00:00", "2012-10-27 16:00:00", 
"2013-03-30 16:00:00", "2013-10-26 16:00:00", "2014-03-29 16:00:00", 
"2014-10-25 16:00:00", "2015-03-28 16:00:00", "2015-10-24 16:00:00", 
"2016-03-26 16:00:00", "2016-10-29 16:00:00", "2017-03-25 16:00:00", 
"2017-10-28 16:00:00", "2018-03-24 16:00:00", "2018-10-27 16:00:00", 
"2019-03-30 16:00:00", "2019-10-26 16:00:00", "2020-03-28 16:00:00", 
"2020-10-24 16:00:00", "2021-03-27 16:00:00", "2021-10-30 16:00:00", 
"2022-03-26 16:00:00", "2022-10-29 16:00:00", "2023-03-25 16:00:00", 
"2023-10-28 16:00:00", "2024-03-30 16:00:00", "2024-10-26 16:00:00", 
"2025-03-29 16:00:00", "2025-10-25 16:00:00", "2026-03-28 16:00:00", 
"2026-10-24 16:00:00", "2027-03-27 16:00:00", "2027-10-30 16:00:00", 
"2028-03-25 16:00:00", "2028-10-28 16:00:00", "2029-03-24 16:00:00", 
"2029-10-27 16:00:00", "2030-03-30 16:00:00", "2030-10-26 16:00:00"
), class = "factor"), offSet = c(39600, 36000, 39600, 36000, 
39600, 36000, 39600, 36000, 36000, 39600, 36000, 39600, 36000, 
39600, 36000, 39600, 36000, 39600, 36000, 39600, 36000, 39600, 
36000, 39600, 36000, 39600, 36000, 39600, 36000, 39600, 36000, 
39600, 36000, 39600, 36000, 39600, 36000, 39600, 36000, 39600, 
36000, 39600, 36000, 39600, 36000, 39600, 36000, 39600, 36000, 
39600, 36000, 39600, 36000, 39600, 36000, 39600, 36000, 39600, 
36000, 39600, 36000, 39600, 36000, 39600, 36000, 39600, 36000, 
39600, 36000, 39600, 36000, 39600, 36000, 39600, 36000, 39600, 
36000, 39600, 36000, 39600, 36000, 39600, 36000, 39600, 36000, 
39600, 36000, 39600, 36000, 39600, 36000, 39600, 36000, 39600, 
36000, 39600, 36000, 39600, 36000, 39600, 36000, 39600, 36000, 
39600, 36000, 39600, 36000, 39600, 36000, 39600, 36000, 39600, 
36000, 39600, 36000, 39600, 36000, 39600, 36000, 39600, 36000, 
39600, 36000, 39600, 36000, 39600, 36000, 39600)), .Names = c("Melbourne", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", 
"9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
"20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", 
"31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", 
"42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", 
"53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", 
"64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", 
"75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", 
"86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", 
"97", "98", "99", "100", "101", "102", "103", "104", "105", "106", 
"107", "108", "109", "110", "111", "112", "113", "114", "115", 
"116", "117", "118", "119", "120", "121", "122", "123", "124", 
"125", "126", "127", "128"), class = "data.frame") }


"Perth" = 
function() {
structure(list(Perth = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13)), .Label = c("1916-12-31 16:01:00", 
"1917-03-24 17:00:00", "1941-12-31 18:00:00", "1942-03-28 17:00:00", 
"1942-09-26 18:00:00", "1943-03-27 17:00:00", "1943-06-30 16:00:00", 
"1974-10-26 18:00:00", "1975-03-01 18:00:00", "1983-10-29 18:00:00", 
"1984-03-03 18:00:00", "1991-11-16 18:00:00", "1992-02-29 18:00:00"
), class = "factor"), offSet = c(32400, 28800, 32400, 28800, 
32400, 28800, 28800, 32400, 28800, 32400, 28800, 32400, 28800
)), .Names = c("Perth", "offSet"), row.names = c("1", "2", "3", 
"4", "5", "6", "7", "8", "9", "10", "11", "12", "13"), class = "data.frame") }


"Sydney" = 
function() {
structure(list(Sydney = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 
71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
128)), .Label = c("1916-12-31 14:01:00", "1917-03-24 15:00:00", 
"1941-12-31 16:00:00", "1942-03-28 15:00:00", "1942-09-26 16:00:00", 
"1943-03-27 15:00:00", "1943-10-02 16:00:00", "1944-03-25 15:00:00", 
"1970-12-31 14:00:00", "1971-10-30 16:00:00", "1972-02-26 16:00:00", 
"1972-10-28 16:00:00", "1973-03-03 16:00:00", "1973-10-27 16:00:00", 
"1974-03-02 16:00:00", "1974-10-26 16:00:00", "1975-03-01 16:00:00", 
"1975-10-25 16:00:00", "1976-03-06 16:00:00", "1976-10-30 16:00:00", 
"1977-03-05 16:00:00", "1977-10-29 16:00:00", "1978-03-04 16:00:00", 
"1978-10-28 16:00:00", "1979-03-03 16:00:00", "1979-10-27 16:00:00", 
"1980-03-01 16:00:00", "1980-10-25 16:00:00", "1981-02-28 16:00:00", 
"1981-10-24 16:00:00", "1982-04-03 16:00:00", "1982-10-30 16:00:00", 
"1983-03-05 16:00:00", "1983-10-29 16:00:00", "1984-03-03 16:00:00", 
"1984-10-27 16:00:00", "1985-03-02 16:00:00", "1985-10-26 16:00:00", 
"1986-03-15 16:00:00", "1986-10-18 16:00:00", "1987-03-14 16:00:00", 
"1987-10-24 16:00:00", "1988-03-19 16:00:00", "1988-10-29 16:00:00", 
"1989-03-18 16:00:00", "1989-10-28 16:00:00", "1990-03-03 16:00:00", 
"1990-10-27 16:00:00", "1991-03-02 16:00:00", "1991-10-26 16:00:00", 
"1992-02-29 16:00:00", "1992-10-24 16:00:00", "1993-03-06 16:00:00", 
"1993-10-30 16:00:00", "1994-03-05 16:00:00", "1994-10-29 16:00:00", 
"1995-03-04 16:00:00", "1995-10-28 16:00:00", "1996-03-30 16:00:00", 
"1996-10-26 16:00:00", "1997-03-29 16:00:00", "1997-10-25 16:00:00", 
"1998-03-28 16:00:00", "1998-10-24 16:00:00", "1999-03-27 16:00:00", 
"1999-10-30 16:00:00", "2000-03-25 16:00:00", "2000-08-26 16:00:00", 
"2001-03-24 16:00:00", "2001-10-27 16:00:00", "2002-03-30 16:00:00", 
"2002-10-26 16:00:00", "2003-03-29 16:00:00", "2003-10-25 16:00:00", 
"2004-03-27 16:00:00", "2004-10-30 16:00:00", "2005-03-26 16:00:00", 
"2005-10-29 16:00:00", "2006-03-25 16:00:00", "2006-10-28 16:00:00", 
"2007-03-24 16:00:00", "2007-10-27 16:00:00", "2008-03-29 16:00:00", 
"2008-10-25 16:00:00", "2009-03-28 16:00:00", "2009-10-24 16:00:00", 
"2010-03-27 16:00:00", "2010-10-30 16:00:00", "2011-03-26 16:00:00", 
"2011-10-29 16:00:00", "2012-03-24 16:00:00", "2012-10-27 16:00:00", 
"2013-03-30 16:00:00", "2013-10-26 16:00:00", "2014-03-29 16:00:00", 
"2014-10-25 16:00:00", "2015-03-28 16:00:00", "2015-10-24 16:00:00", 
"2016-03-26 16:00:00", "2016-10-29 16:00:00", "2017-03-25 16:00:00", 
"2017-10-28 16:00:00", "2018-03-24 16:00:00", "2018-10-27 16:00:00", 
"2019-03-30 16:00:00", "2019-10-26 16:00:00", "2020-03-28 16:00:00", 
"2020-10-24 16:00:00", "2021-03-27 16:00:00", "2021-10-30 16:00:00", 
"2022-03-26 16:00:00", "2022-10-29 16:00:00", "2023-03-25 16:00:00", 
"2023-10-28 16:00:00", "2024-03-30 16:00:00", "2024-10-26 16:00:00", 
"2025-03-29 16:00:00", "2025-10-25 16:00:00", "2026-03-28 16:00:00", 
"2026-10-24 16:00:00", "2027-03-27 16:00:00", "2027-10-30 16:00:00", 
"2028-03-25 16:00:00", "2028-10-28 16:00:00", "2029-03-24 16:00:00", 
"2029-10-27 16:00:00", "2030-03-30 16:00:00", "2030-10-26 16:00:00"
), class = "factor"), offSet = c(39600, 36000, 39600, 36000, 
39600, 36000, 39600, 36000, 36000, 39600, 36000, 39600, 36000, 
39600, 36000, 39600, 36000, 39600, 36000, 39600, 36000, 39600, 
36000, 39600, 36000, 39600, 36000, 39600, 36000, 39600, 36000, 
39600, 36000, 39600, 36000, 39600, 36000, 39600, 36000, 39600, 
36000, 39600, 36000, 39600, 36000, 39600, 36000, 39600, 36000, 
39600, 36000, 39600, 36000, 39600, 36000, 39600, 36000, 39600, 
36000, 39600, 36000, 39600, 36000, 39600, 36000, 39600, 36000, 
39600, 36000, 39600, 36000, 39600, 36000, 39600, 36000, 39600, 
36000, 39600, 36000, 39600, 36000, 39600, 36000, 39600, 36000, 
39600, 36000, 39600, 36000, 39600, 36000, 39600, 36000, 39600, 
36000, 39600, 36000, 39600, 36000, 39600, 36000, 39600, 36000, 
39600, 36000, 39600, 36000, 39600, 36000, 39600, 36000, 39600, 
36000, 39600, 36000, 39600, 36000, 39600, 36000, 39600, 36000, 
39600, 36000, 39600, 36000, 39600, 36000, 39600)), .Names = c("Sydney", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", 
"9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
"20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", 
"31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", 
"42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", 
"53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", 
"64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", 
"75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", 
"86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", 
"97", "98", "99", "100", "101", "102", "103", "104", "105", "106", 
"107", "108", "109", "110", "111", "112", "113", "114", "115", 
"116", "117", "118", "119", "120", "121", "122", "123", "124", 
"125", "126", "127", "128"), class = "data.frame") }


# EUROPE -----------------------------------------------------------------------


"Amsterdam" = 
function() {
structure(list(Amsterdam = structure(as.integer(c(1, 2, 3, 4, 
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 
38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 
54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 
140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 
153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 
166)), .Label = c("1916-04-30 23:40:28", "1916-09-30 22:40:28", 
"1917-04-16 01:40:28", "1917-09-17 01:40:28", "1918-04-01 01:40:28", 
"1918-09-30 01:40:28", "1919-04-07 01:40:28", "1919-09-29 01:40:28", 
"1920-04-05 01:40:28", "1920-09-27 01:40:28", "1921-04-04 01:40:28", 
"1921-09-26 01:40:28", "1922-03-26 01:40:28", "1922-10-08 01:40:28", 
"1923-06-01 01:40:28", "1923-10-07 01:40:28", "1924-03-30 01:40:28", 
"1924-10-05 01:40:28", "1925-06-05 01:40:28", "1925-10-04 01:40:28", 
"1926-05-15 01:40:28", "1926-10-03 01:40:28", "1927-05-15 01:40:28", 
"1927-10-02 01:40:28", "1928-05-15 01:40:28", "1928-10-07 01:40:28", 
"1929-05-15 01:40:28", "1929-10-06 01:40:28", "1930-05-15 01:40:28", 
"1930-10-05 01:40:28", "1931-05-15 01:40:28", "1931-10-04 01:40:28", 
"1932-05-22 01:40:28", "1932-10-02 01:40:28", "1933-05-15 01:40:28", 
"1933-10-08 01:40:28", "1934-05-15 01:40:28", "1934-10-07 01:40:28", 
"1935-05-15 01:40:28", "1935-10-06 01:40:28", "1936-05-15 01:40:28", 
"1936-10-04 01:40:28", "1937-05-22 01:40:28", "1937-06-30 22:40:28", 
"1937-10-03 01:40:00", "1938-05-15 01:40:00", "1938-10-02 01:40:00", 
"1939-05-15 01:40:00", "1939-10-08 01:40:00", "1940-05-16 23:40:00", 
"1942-11-02 01:00:00", "1943-03-29 01:00:00", "1943-10-04 01:00:00", 
"1944-04-03 01:00:00", "1944-10-02 01:00:00", "1945-04-02 01:00:00", 
"1945-09-16 01:00:00", "1976-12-31 23:00:00", "1977-04-03 01:00:00", 
"1977-09-25 01:00:00", "1978-04-02 01:00:00", "1978-10-01 01:00:00", 
"1979-04-01 01:00:00", "1979-09-30 01:00:00", "1980-04-06 01:00:00", 
"1980-09-28 01:00:00", "1981-03-29 01:00:00", "1981-09-27 01:00:00", 
"1982-03-28 01:00:00", "1982-09-26 01:00:00", "1983-03-27 01:00:00", 
"1983-09-25 01:00:00", "1984-03-25 01:00:00", "1984-09-30 01:00:00", 
"1985-03-31 01:00:00", "1985-09-29 01:00:00", "1986-03-30 01:00:00", 
"1986-09-28 01:00:00", "1987-03-29 01:00:00", "1987-09-27 01:00:00", 
"1988-03-27 01:00:00", "1988-09-25 01:00:00", "1989-03-26 01:00:00", 
"1989-09-24 01:00:00", "1990-03-25 01:00:00", "1990-09-30 01:00:00", 
"1991-03-31 01:00:00", "1991-09-29 01:00:00", "1992-03-29 01:00:00", 
"1992-09-27 01:00:00", "1993-03-28 01:00:00", "1993-09-26 01:00:00", 
"1994-03-27 01:00:00", "1994-09-25 01:00:00", "1995-03-26 01:00:00", 
"1995-09-24 01:00:00", "1996-03-31 01:00:00", "1996-10-27 01:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00"), class = "factor"), 
offSet = c(430320, 70320, 430320, 70320, 430320, 70320, 430320, 
70320, 430320, 70320, 430320, 70320, 430320, 70320, 430320, 
70320, 430320, 70320, 430320, 70320, 430320, 70320, 430320, 
70320, 430320, 70320, 430320, 70320, 430320, 70320, 430320, 
70320, 430320, 70320, 430320, 70320, 430320, 70320, 430320, 
70320, 430320, 70320, 430320, 4800, 1200, 4800, 1200, 4800, 
1200, 3600, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600)), .Names = c("Amsterdam", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", 
"9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
"20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", 
"31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", 
"42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", 
"53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", 
"64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", 
"75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", 
"86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", 
"97", "98", "99", "100", "101", "102", "103", "104", "105", "106", 
"107", "108", "109", "110", "111", "112", "113", "114", "115", 
"116", "117", "118", "119", "120", "121", "122", "123", "124", 
"125", "126", "127", "128", "129", "130", "131", "132", "133", 
"134", "135", "136", "137", "138", "139", "140", "141", "142", 
"143", "144", "145", "146", "147", "148", "149", "150", "151", 
"152", "153", "154", "155", "156", "157", "158", "159", "160", 
"161", "162", "163", "164", "165", "166"), class = "data.frame") }


"Andorra" = 
function() {
structure(list(Andorra = structure(as.integer(c(NA, 1, 2, 3, 
4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 
37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 
53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 
85, 86, 87, 88, 89, 90, 91, 92)), .Label = c("1985-03-31 01:00:00", 
"1985-09-29 01:00:00", "1986-03-30 01:00:00", "1986-09-28 01:00:00", 
"1987-03-29 01:00:00", "1987-09-27 01:00:00", "1988-03-27 01:00:00", 
"1988-09-25 01:00:00", "1989-03-26 01:00:00", "1989-09-24 01:00:00", 
"1990-03-25 01:00:00", "1990-09-30 01:00:00", "1991-03-31 01:00:00", 
"1991-09-29 01:00:00", "1992-03-29 01:00:00", "1992-09-27 01:00:00", 
"1993-03-28 01:00:00", "1993-09-26 01:00:00", "1994-03-27 01:00:00", 
"1994-09-25 01:00:00", "1995-03-26 01:00:00", "1995-09-24 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00"), class = "factor"), offSet = c(3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600)), .Names = c("Andorra", "offSet"), row.names = c("1", 
"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
"14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
"25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", 
"36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", 
"47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", 
"58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", 
"69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", 
"80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", 
"91", "92", "93"), class = "data.frame") }


"Athens" = 
function() {
structure(list(Athens = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13, NA, NA, NA, NA, NA, 14, 15, 16, 17, 
18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 
34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 
50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 
66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 
98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 
111, 112, 113, 114, 115, 116, 117, 118, 119)), .Label = c("1916-07-27 22:26:08", 
"1932-07-06 22:00:00", "1932-08-31 21:00:00", "1941-04-06 22:00:00", 
"1941-04-29 21:00:00", "1942-11-02 02:00:00", "1943-03-29 23:00:00", 
"1943-10-03 22:00:00", "1944-04-03 23:00:00", "1952-06-30 22:00:00", 
"1952-11-01 21:00:00", "1975-04-11 22:00:00", "1975-11-25 22:00:00", 
"1978-09-24 01:00:00", "1979-04-01 07:00:00", "1979-09-28 23:00:00", 
"1980-03-31 22:00:00", "1980-09-27 21:00:00", "1980-12-31 22:00:00", 
"1981-03-29 01:00:00", "1981-09-27 01:00:00", "1982-03-28 01:00:00", 
"1982-09-26 01:00:00", "1983-03-27 01:00:00", "1983-09-25 01:00:00", 
"1984-03-25 01:00:00", "1984-09-30 01:00:00", "1985-03-31 01:00:00", 
"1985-09-29 01:00:00", "1986-03-30 01:00:00", "1986-09-28 01:00:00", 
"1987-03-29 01:00:00", "1987-09-27 01:00:00", "1988-03-27 01:00:00", 
"1988-09-25 01:00:00", "1989-03-26 01:00:00", "1989-09-24 01:00:00", 
"1990-03-25 01:00:00", "1990-09-30 01:00:00", "1991-03-31 01:00:00", 
"1991-09-29 01:00:00", "1992-03-29 01:00:00", "1992-09-27 01:00:00", 
"1993-03-28 01:00:00", "1993-09-26 01:00:00", "1994-03-27 01:00:00", 
"1994-09-25 01:00:00", "1995-03-26 01:00:00", "1995-09-24 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00"), class = "factor"), offSet = c(7200, 10800, 
7200, 10800, 3600, 3600, 7200, 3600, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200)), .Names = c("Athens", "offSet"), row.names = c("1", 
"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
"14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
"25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", 
"36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", 
"47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", 
"58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", 
"69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", 
"80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", 
"91", "92", "93", "94", "95", "96", "97", "98", "99", "100", 
"101", "102", "103", "104", "105", "106", "107", "108", "109", 
"110", "111", "112", "113", "114", "115", "116", "117", "118", 
"119", "120", "121", "122", "123", "124"), class = "data.frame") }


"Belfast" = 
function() {
structure(list(Belfast = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 
71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
154, 155, 156, 157, NA, 158, 159, 160, 161, 162, 163, 164, 165, 
166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 
179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 
192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 
205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 
218, 219, 220, 221, 222, 223, 224, 225, 226, 227)), .Label = c("1916-05-21 02:25:21", 
"1916-10-01 02:25:21", "1917-04-08 02:00:00", "1917-09-17 02:00:00", 
"1918-03-24 02:00:00", "1918-09-30 02:00:00", "1919-03-30 02:00:00", 
"1919-09-29 02:00:00", "1920-03-28 02:00:00", "1920-10-25 02:00:00", 
"1921-04-03 02:00:00", "1921-10-03 02:00:00", "1922-03-26 02:00:00", 
"1922-10-08 02:00:00", "1923-04-22 02:00:00", "1923-09-16 02:00:00", 
"1924-04-13 02:00:00", "1924-09-21 02:00:00", "1925-04-19 02:00:00", 
"1925-10-04 02:00:00", "1926-04-18 02:00:00", "1926-10-03 02:00:00", 
"1927-04-10 02:00:00", "1927-10-02 02:00:00", "1928-04-22 02:00:00", 
"1928-10-07 02:00:00", "1929-04-21 02:00:00", "1929-10-06 02:00:00", 
"1930-04-13 02:00:00", "1930-10-05 02:00:00", "1931-04-19 02:00:00", 
"1931-10-04 02:00:00", "1932-04-17 02:00:00", "1932-10-02 02:00:00", 
"1933-04-09 02:00:00", "1933-10-08 02:00:00", "1934-04-22 02:00:00", 
"1934-10-07 02:00:00", "1935-04-14 02:00:00", "1935-10-06 02:00:00", 
"1936-04-19 02:00:00", "1936-10-04 02:00:00", "1937-04-18 02:00:00", 
"1937-10-03 02:00:00", "1938-04-10 02:00:00", "1938-10-02 02:00:00", 
"1939-04-16 02:00:00", "1939-11-19 02:00:00", "1940-02-25 02:00:00", 
"1941-05-04 01:00:00", "1941-08-10 01:00:00", "1942-04-05 01:00:00", 
"1942-08-09 01:00:00", "1943-04-04 01:00:00", "1943-08-15 01:00:00", 
"1944-04-02 01:00:00", "1944-09-17 01:00:00", "1945-04-02 01:00:00", 
"1945-07-15 01:00:00", "1945-10-07 02:00:00", "1946-04-14 02:00:00", 
"1946-10-06 02:00:00", "1947-03-16 02:00:00", "1947-04-13 01:00:00", 
"1947-08-10 01:00:00", "1947-11-02 02:00:00", "1948-03-14 02:00:00", 
"1948-10-31 02:00:00", "1949-04-03 02:00:00", "1949-10-30 02:00:00", 
"1950-04-16 02:00:00", "1950-10-22 02:00:00", "1951-04-15 02:00:00", 
"1951-10-21 02:00:00", "1952-04-20 02:00:00", "1952-10-26 02:00:00", 
"1953-04-19 02:00:00", "1953-10-04 02:00:00", "1954-04-11 02:00:00", 
"1954-10-03 02:00:00", "1955-04-17 02:00:00", "1955-10-02 02:00:00", 
"1956-04-22 02:00:00", "1956-10-07 02:00:00", "1957-04-14 02:00:00", 
"1957-10-06 02:00:00", "1958-04-20 02:00:00", "1958-10-05 02:00:00", 
"1959-04-19 02:00:00", "1959-10-04 02:00:00", "1960-04-10 02:00:00", 
"1960-10-02 02:00:00", "1961-03-26 02:00:00", "1961-10-29 02:00:00", 
"1962-03-25 02:00:00", "1962-10-28 02:00:00", "1963-03-31 02:00:00", 
"1963-10-27 02:00:00", "1964-03-22 02:00:00", "1964-10-25 02:00:00", 
"1965-03-21 02:00:00", "1965-10-24 02:00:00", "1966-03-20 02:00:00", 
"1966-10-23 02:00:00", "1967-03-19 02:00:00", "1967-10-29 02:00:00", 
"1968-02-18 02:00:00", "1968-10-26 23:00:00", "1971-10-31 02:00:00", 
"1972-03-19 02:00:00", "1972-10-29 02:00:00", "1973-03-18 02:00:00", 
"1973-10-28 02:00:00", "1974-03-17 02:00:00", "1974-10-27 02:00:00", 
"1975-03-16 02:00:00", "1975-10-26 02:00:00", "1976-03-21 02:00:00", 
"1976-10-24 02:00:00", "1977-03-20 02:00:00", "1977-10-23 02:00:00", 
"1978-03-19 02:00:00", "1978-10-29 02:00:00", "1979-03-18 02:00:00", 
"1979-10-28 02:00:00", "1980-03-16 02:00:00", "1980-10-26 02:00:00", 
"1981-03-29 01:00:00", "1981-10-25 01:00:00", "1982-03-28 01:00:00", 
"1982-10-24 01:00:00", "1983-03-27 01:00:00", "1983-10-23 01:00:00", 
"1984-03-25 01:00:00", "1984-10-28 01:00:00", "1985-03-31 01:00:00", 
"1985-10-27 01:00:00", "1986-03-30 01:00:00", "1986-10-26 01:00:00", 
"1987-03-29 01:00:00", "1987-10-25 01:00:00", "1988-03-27 01:00:00", 
"1988-10-23 01:00:00", "1989-03-26 01:00:00", "1989-10-29 01:00:00", 
"1990-03-25 01:00:00", "1990-10-28 01:00:00", "1991-03-31 01:00:00", 
"1991-10-27 01:00:00", "1992-03-29 01:00:00", "1992-10-25 01:00:00", 
"1993-03-28 01:00:00", "1993-10-24 01:00:00", "1994-03-27 01:00:00", 
"1994-10-23 01:00:00", "1995-03-26 01:00:00", "1995-10-22 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00"), class = "factor"), offSet = c(124740, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 0, 3600, 0, 3600, 7200, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 3600, 0, 
3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 3600, 0, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0)), .Names = c("Belfast", "offSet"
), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", "9", 
"10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", 
"21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", 
"32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", 
"43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", 
"54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", 
"65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", 
"76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", 
"87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", 
"98", "99", "100", "101", "102", "103", "104", "105", "106", 
"107", "108", "109", "110", "111", "112", "113", "114", "115", 
"116", "117", "118", "119", "120", "121", "122", "123", "124", 
"125", "126", "127", "128", "129", "130", "131", "132", "133", 
"134", "135", "136", "137", "138", "139", "140", "141", "142", 
"143", "144", "145", "146", "147", "148", "149", "150", "151", 
"152", "153", "154", "155", "156", "157", "158", "159", "160", 
"161", "162", "163", "164", "165", "166", "167", "168", "169", 
"170", "171", "172", "173", "174", "175", "176", "177", "178", 
"179", "180", "181", "182", "183", "184", "185", "186", "187", 
"188", "189", "190", "191", "192", "193", "194", "195", "196", 
"197", "198", "199", "200", "201", "202", "203", "204", "205", 
"206", "207", "208", "209", "210", "211", "212", "213", "214", 
"215", "216", "217", "218", "219", "220", "221", "222", "223", 
"224", "225", "226", "227", "228"), class = "data.frame") }


"Belgrade" = 
function() {
structure(list(Belgrade = structure(as.integer(c(1, 2, 3, 4, 
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 
38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 
54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
101, 102, 103, 104, 105)), .Label = c("1941-04-18 22:00:00", 
"1942-11-02 01:00:00", "1943-03-29 01:00:00", "1943-10-04 01:00:00", 
"1944-04-03 01:00:00", "1944-10-02 01:00:00", "1945-05-08 01:00:00", 
"1945-09-16 01:00:00", "1982-11-26 23:00:00", "1983-03-27 01:00:00", 
"1983-09-25 01:00:00", "1984-03-25 01:00:00", "1984-09-30 01:00:00", 
"1985-03-31 01:00:00", "1985-09-29 01:00:00", "1986-03-30 01:00:00", 
"1986-09-28 01:00:00", "1987-03-29 01:00:00", "1987-09-27 01:00:00", 
"1988-03-27 01:00:00", "1988-09-25 01:00:00", "1989-03-26 01:00:00", 
"1989-09-24 01:00:00", "1990-03-25 01:00:00", "1990-09-30 01:00:00", 
"1991-03-31 01:00:00", "1991-09-29 01:00:00", "1992-03-29 01:00:00", 
"1992-09-27 01:00:00", "1993-03-28 01:00:00", "1993-09-26 01:00:00", 
"1994-03-27 01:00:00", "1994-09-25 01:00:00", "1995-03-26 01:00:00", 
"1995-09-24 01:00:00", "1996-03-31 01:00:00", "1996-10-27 01:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00"), class = "factor"), 
offSet = c(3600, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600)), .Names = c("Belgrade", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", 
"9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
"20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", 
"31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", 
"42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", 
"53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", 
"64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", 
"75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", 
"86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", 
"97", "98", "99", "100", "101", "102", "103", "104", "105"), 
class = "data.frame") }


"Berlin" = "Frankfurt" = 
function() {
structure(list(Berlin = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13, 14, NA, 15, 16, 17, 18, 19, NA, 20, 
21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 
37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 
53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 
85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
127)), .Label = c("1916-04-30 22:00:00", "1916-09-30 23:00:00", 
"1917-04-16 01:00:00", "1917-09-17 01:00:00", "1918-04-15 01:00:00", 
"1918-09-16 01:00:00", "1940-04-01 01:00:00", "1942-11-02 01:00:00", 
"1943-03-29 01:00:00", "1943-10-04 01:00:00", "1944-04-03 01:00:00", 
"1944-10-02 01:00:00", "1945-04-02 01:00:00", "1945-05-31 01:00:00", 
"1945-11-18 01:00:00", "1946-04-14 01:00:00", "1946-10-07 01:00:00", 
"1947-04-06 01:00:00", "1947-05-11 01:00:00", "1947-10-05 01:00:00", 
"1948-04-18 01:00:00", "1948-10-03 01:00:00", "1949-04-10 01:00:00", 
"1949-10-02 01:00:00", "1979-12-31 23:00:00", "1980-04-06 01:00:00", 
"1980-09-28 01:00:00", "1981-03-29 01:00:00", "1981-09-27 01:00:00", 
"1982-03-28 01:00:00", "1982-09-26 01:00:00", "1983-03-27 01:00:00", 
"1983-09-25 01:00:00", "1984-03-25 01:00:00", "1984-09-30 01:00:00", 
"1985-03-31 01:00:00", "1985-09-29 01:00:00", "1986-03-30 01:00:00", 
"1986-09-28 01:00:00", "1987-03-29 01:00:00", "1987-09-27 01:00:00", 
"1988-03-27 01:00:00", "1988-09-25 01:00:00", "1989-03-26 01:00:00", 
"1989-09-24 01:00:00", "1990-03-25 01:00:00", "1990-09-30 01:00:00", 
"1991-03-31 01:00:00", "1991-09-29 01:00:00", "1992-03-29 01:00:00", 
"1992-09-27 01:00:00", "1993-03-28 01:00:00", "1993-09-26 01:00:00", 
"1994-03-27 01:00:00", "1994-09-25 01:00:00", "1995-03-26 01:00:00", 
"1995-09-24 01:00:00", "1996-03-31 01:00:00", "1996-10-27 01:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00"), class = "factor"), 
offSet = c(7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 10800, 7200, 3600, 7200, 3600, 
7200, 10800, 7200, 3600, 7200, 3600, 7200, 3600, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600)), .Names = c("Berlin", "offSet"), row.names = c("1", 
"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
"14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
"25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", 
"36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", 
"47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", 
"58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", 
"69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", 
"80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", 
"91", "92", "93", "94", "95", "96", "97", "98", "99", "100", 
"101", "102", "103", "104", "105", "106", "107", "108", "109", 
"110", "111", "112", "113", "114", "115", "116", "117", "118", 
"119", "120", "121", "122", "123", "124", "125", "126", "127", 
"128", "129"), class = "data.frame") }


"Bratislava" = 
function() {
structure(list(Bratislava = structure(as.integer(c(1, 2, 3, 4, 
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 
38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 
54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
127, 128)), .Label = c("1891-09-30 23:02:16", "1916-04-30 22:00:00", 
"1916-09-30 23:00:00", "1917-04-16 01:00:00", "1917-09-17 01:00:00", 
"1918-04-15 01:00:00", "1918-09-16 01:00:00", "1940-04-01 01:00:00", 
"1942-11-02 01:00:00", "1943-03-29 01:00:00", "1943-10-04 01:00:00", 
"1944-04-03 01:00:00", "1944-09-17 01:00:00", "1945-04-08 01:00:00", 
"1945-11-18 01:00:00", "1946-05-06 01:00:00", "1946-10-06 01:00:00", 
"1947-04-20 01:00:00", "1947-10-05 01:00:00", "1948-04-18 01:00:00", 
"1948-10-03 01:00:00", "1949-04-09 01:00:00", "1949-10-02 01:00:00", 
"1978-12-31 23:00:00", "1979-04-01 01:00:00", "1979-09-30 01:00:00", 
"1980-04-06 01:00:00", "1980-09-28 01:00:00", "1981-03-29 01:00:00", 
"1981-09-27 01:00:00", "1982-03-28 01:00:00", "1982-09-26 01:00:00", 
"1983-03-27 01:00:00", "1983-09-25 01:00:00", "1984-03-25 01:00:00", 
"1984-09-30 01:00:00", "1985-03-31 01:00:00", "1985-09-29 01:00:00", 
"1986-03-30 01:00:00", "1986-09-28 01:00:00", "1987-03-29 01:00:00", 
"1987-09-27 01:00:00", "1988-03-27 01:00:00", "1988-09-25 01:00:00", 
"1989-03-26 01:00:00", "1989-09-24 01:00:00", "1990-03-25 01:00:00", 
"1990-09-30 01:00:00", "1991-03-31 01:00:00", "1991-09-29 01:00:00", 
"1992-03-29 01:00:00", "1992-09-27 01:00:00", "1993-03-28 01:00:00", 
"1993-09-26 01:00:00", "1994-03-27 01:00:00", "1994-09-25 01:00:00", 
"1995-03-26 01:00:00", "1995-09-24 01:00:00", "1996-03-31 01:00:00", 
"1996-10-27 01:00:00", "1997-03-30 01:00:00", "1997-10-26 01:00:00", 
"1998-03-29 01:00:00", "1998-10-25 01:00:00", "1999-03-28 01:00:00", 
"1999-10-31 01:00:00", "2000-03-26 01:00:00", "2000-10-29 01:00:00", 
"2001-03-25 01:00:00", "2001-10-28 01:00:00", "2002-03-31 01:00:00", 
"2002-10-27 01:00:00", "2003-03-30 01:00:00", "2003-10-26 01:00:00", 
"2004-03-28 01:00:00", "2004-10-31 01:00:00", "2005-03-27 01:00:00", 
"2005-10-30 01:00:00", "2006-03-26 01:00:00", "2006-10-29 01:00:00", 
"2007-03-25 01:00:00", "2007-10-28 01:00:00", "2008-03-30 01:00:00", 
"2008-10-26 01:00:00", "2009-03-29 01:00:00", "2009-10-25 01:00:00", 
"2010-03-28 01:00:00", "2010-10-31 01:00:00", "2011-03-27 01:00:00", 
"2011-10-30 01:00:00", "2012-03-25 01:00:00", "2012-10-28 01:00:00", 
"2013-03-31 01:00:00", "2013-10-27 01:00:00", "2014-03-30 01:00:00", 
"2014-10-26 01:00:00", "2015-03-29 01:00:00", "2015-10-25 01:00:00", 
"2016-03-27 01:00:00", "2016-10-30 01:00:00", "2017-03-26 01:00:00", 
"2017-10-29 01:00:00", "2018-03-25 01:00:00", "2018-10-28 01:00:00", 
"2019-03-31 01:00:00", "2019-10-27 01:00:00", "2020-03-29 01:00:00", 
"2020-10-25 01:00:00", "2021-03-28 01:00:00", "2021-10-31 01:00:00", 
"2022-03-27 01:00:00", "2022-10-30 01:00:00", "2023-03-26 01:00:00", 
"2023-10-29 01:00:00", "2024-03-31 01:00:00", "2024-10-27 01:00:00", 
"2025-03-30 01:00:00", "2025-10-26 01:00:00", "2026-03-29 01:00:00", 
"2026-10-25 01:00:00", "2027-03-28 01:00:00", "2027-10-31 01:00:00", 
"2028-03-26 01:00:00", "2028-10-29 01:00:00", "2029-03-25 01:00:00", 
"2029-10-28 01:00:00", "2030-03-31 01:00:00", "2030-10-27 01:00:00"
), class = "factor"), offSet = c(3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600)), .Names = c("Bratislava", "offSet"), row.names = c("1", 
"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
"14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
"25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", 
"36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", 
"47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", 
"58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", 
"69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", 
"80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", 
"91", "92", "93", "94", "95", "96", "97", "98", "99", "100", 
"101", "102", "103", "104", "105", "106", "107", "108", "109", 
"110", "111", "112", "113", "114", "115", "116", "117", "118", 
"119", "120", "121", "122", "123", "124", "125", "126", "127", 
"128"), class = "data.frame") }


"Brussels" = 
function() {
structure(list(Brussels = structure(as.integer(c(1, NA, 2, NA, 
3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 
20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 
68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 
84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 
100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 
113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 
126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 
139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 
152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 
165, 166, 167, 168, 169, 170)), .Label = c("1892-05-01 11:42:30", 
"1916-04-30 23:00:00", "1917-04-16 01:00:00", "1917-09-17 01:00:00", 
"1918-04-15 01:00:00", "1918-09-16 01:00:00", "1918-11-11 11:00:00", 
"1919-03-01 23:00:00", "1919-10-04 23:00:00", "1920-02-14 23:00:00", 
"1920-10-23 23:00:00", "1921-03-14 23:00:00", "1921-10-25 23:00:00", 
"1922-03-25 23:00:00", "1922-10-07 23:00:00", "1923-04-21 23:00:00", 
"1923-10-06 23:00:00", "1924-03-29 23:00:00", "1924-10-04 23:00:00", 
"1925-04-04 23:00:00", "1925-10-03 23:00:00", "1926-04-17 23:00:00", 
"1926-10-02 23:00:00", "1927-04-09 23:00:00", "1927-10-01 23:00:00", 
"1928-04-14 23:00:00", "1928-10-07 02:00:00", "1929-04-21 02:00:00", 
"1929-10-06 02:00:00", "1930-04-13 02:00:00", "1930-10-05 02:00:00", 
"1931-04-19 02:00:00", "1931-10-04 02:00:00", "1932-04-03 02:00:00", 
"1932-10-02 02:00:00", "1933-03-26 02:00:00", "1933-10-08 02:00:00", 
"1934-04-08 02:00:00", "1934-10-07 02:00:00", "1935-03-31 02:00:00", 
"1935-10-06 02:00:00", "1936-04-19 02:00:00", "1936-10-04 02:00:00", 
"1937-04-04 02:00:00", "1937-10-03 02:00:00", "1938-03-27 02:00:00", 
"1938-10-02 02:00:00", "1939-04-16 02:00:00", "1939-11-19 02:00:00", 
"1940-02-25 02:00:00", "1940-05-20 02:00:00", "1942-11-02 01:00:00", 
"1943-03-29 01:00:00", "1943-10-04 01:00:00", "1944-04-03 01:00:00", 
"1944-09-02 22:00:00", "1944-09-17 01:00:00", "1945-04-02 01:00:00", 
"1945-09-16 01:00:00", "1946-05-19 01:00:00", "1946-10-07 01:00:00", 
"1976-12-31 23:00:00", "1977-04-03 01:00:00", "1977-09-25 01:00:00", 
"1978-04-02 01:00:00", "1978-10-01 01:00:00", "1979-04-01 01:00:00", 
"1979-09-30 01:00:00", "1980-04-06 01:00:00", "1980-09-28 01:00:00", 
"1981-03-29 01:00:00", "1981-09-27 01:00:00", "1982-03-28 01:00:00", 
"1982-09-26 01:00:00", "1983-03-27 01:00:00", "1983-09-25 01:00:00", 
"1984-03-25 01:00:00", "1984-09-30 01:00:00", "1985-03-31 01:00:00", 
"1985-09-29 01:00:00", "1986-03-30 01:00:00", "1986-09-28 01:00:00", 
"1987-03-29 01:00:00", "1987-09-27 01:00:00", "1988-03-27 01:00:00", 
"1988-09-25 01:00:00", "1989-03-26 01:00:00", "1989-09-24 01:00:00", 
"1990-03-25 01:00:00", "1990-09-30 01:00:00", "1991-03-31 01:00:00", 
"1991-09-29 01:00:00", "1992-03-29 01:00:00", "1992-09-27 01:00:00", 
"1993-03-28 01:00:00", "1993-09-26 01:00:00", "1994-03-27 01:00:00", 
"1994-09-25 01:00:00", "1995-03-26 01:00:00", "1995-09-24 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00"), class = "factor"), offSet = c(0, 3600, 
3600, 3600, 7200, 3600, 7200, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 3600, 3600, 7200, 
3600, 7200, 3600, 3600, 7200, 3600, 7200, 3600, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600)), .Names = c("Brussels", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", 
"9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
"20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", 
"31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", 
"42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", 
"53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", 
"64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", 
"75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", 
"86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", 
"97", "98", "99", "100", "101", "102", "103", "104", "105", "106", 
"107", "108", "109", "110", "111", "112", "113", "114", "115", 
"116", "117", "118", "119", "120", "121", "122", "123", "124", 
"125", "126", "127", "128", "129", "130", "131", "132", "133", 
"134", "135", "136", "137", "138", "139", "140", "141", "142", 
"143", "144", "145", "146", "147", "148", "149", "150", "151", 
"152", "153", "154", "155", "156", "157", "158", "159", "160", 
"161", "162", "163", "164", "165", "166", "167", "168", "169", 
"170", "171", "172"), class = "data.frame") }


"Bucharest" = 
function() {
structure(list(Bucharest = structure(as.integer(c(1, 2, 3, 4, 
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 
NA, NA, NA, NA, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 
34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 
50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 
66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 
98, 99, 100, 101, 102, 103, 104)), .Label = c("1931-07-23 22:15:36", 
"1932-05-20 22:00:00", "1932-10-01 22:00:00", "1933-04-01 22:00:00", 
"1933-09-30 22:00:00", "1934-04-07 22:00:00", "1934-10-06 22:00:00", 
"1935-04-06 22:00:00", "1935-10-05 22:00:00", "1936-04-04 22:00:00", 
"1936-10-03 22:00:00", "1937-04-03 22:00:00", "1937-10-02 22:00:00", 
"1938-04-02 22:00:00", "1938-10-01 22:00:00", "1939-04-01 22:00:00", 
"1939-09-30 22:00:00", "1979-05-26 22:00:00", "1979-09-29 21:00:00", 
"1980-04-05 21:00:00", "1980-09-27 22:00:00", "1990-12-31 22:00:00", 
"1991-03-30 22:00:00", "1991-09-28 22:00:00", "1992-03-28 22:00:00", 
"1992-09-26 22:00:00", "1993-03-27 22:00:00", "1993-09-25 22:00:00", 
"1993-12-31 22:00:00", "1994-03-26 22:00:00", "1994-09-24 21:00:00", 
"1995-03-25 22:00:00", "1995-09-23 21:00:00", "1996-03-30 22:00:00", 
"1996-10-26 21:00:00", "1996-12-31 22:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00"), class = "factor"), offSet = c(7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200)), .Names = c("Bucharest", "offSet"), row.names = c("1", 
"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
"14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
"25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", 
"36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", 
"47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", 
"58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", 
"69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", 
"80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", 
"91", "92", "93", "94", "95", "96", "97", "98", "99", "100", 
"101", "102", "103", "104", "105", "106", "107", "108", "109", 
"110", "111", "112", "113", "114", "115", "116", "117", "118", 
"119", "120", "121", "122", "123", "124"), class = "data.frame") }


"Budapest" = 
function() {
structure(list(Budapest = structure(as.integer(c(1, 2, 3, 4, 
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, NA, 36, 
NA, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 
68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 
84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 
100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 
113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 
126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137)), 
.Label = c("1916-04-30 22:00:00", 
"1916-09-30 23:00:00", "1917-04-16 01:00:00", "1917-09-17 01:00:00", 
"1917-12-31 23:00:00", "1918-04-01 02:00:00", "1918-09-29 01:00:00", 
"1919-04-15 02:00:00", "1919-09-15 01:00:00", "1920-04-05 02:00:00", 
"1920-09-30 01:00:00", "1941-04-06 01:00:00", "1942-11-02 01:00:00", 
"1943-03-29 01:00:00", "1943-10-04 01:00:00", "1944-04-03 01:00:00", 
"1944-10-02 01:00:00", "1945-05-01 22:00:00", "1945-11-02 22:00:00", 
"1946-03-31 01:00:00", "1946-10-06 01:00:00", "1947-04-06 01:00:00", 
"1947-10-05 01:00:00", "1948-04-04 01:00:00", "1948-10-03 01:00:00", 
"1949-04-10 01:00:00", "1949-10-02 01:00:00", "1950-04-17 01:00:00", 
"1950-10-23 01:00:00", "1954-05-22 23:00:00", "1954-10-02 22:00:00", 
"1955-05-22 23:00:00", "1955-10-02 22:00:00", "1956-06-02 23:00:00", 
"1956-09-29 22:00:00", "1957-09-29 01:00:00", "1980-09-28 01:00:00", 
"1981-03-29 01:00:00", "1981-09-27 01:00:00", "1982-03-28 01:00:00", 
"1982-09-26 01:00:00", "1983-03-27 01:00:00", "1983-09-25 01:00:00", 
"1984-03-25 01:00:00", "1984-09-30 01:00:00", "1985-03-31 01:00:00", 
"1985-09-29 01:00:00", "1986-03-30 01:00:00", "1986-09-28 01:00:00", 
"1987-03-29 01:00:00", "1987-09-27 01:00:00", "1988-03-27 01:00:00", 
"1988-09-25 01:00:00", "1989-03-26 01:00:00", "1989-09-24 01:00:00", 
"1990-03-25 01:00:00", "1990-09-30 01:00:00", "1991-03-31 01:00:00", 
"1991-09-29 01:00:00", "1992-03-29 01:00:00", "1992-09-27 01:00:00", 
"1993-03-28 01:00:00", "1993-09-26 01:00:00", "1994-03-27 01:00:00", 
"1994-09-25 01:00:00", "1995-03-26 01:00:00", "1995-09-24 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00"), class = "factor"), offSet = c(7200, 3600, 
7200, 3600, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 3600, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600)), .Names = c("Budapest", "offSet"
), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", "9", 
"10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", 
"21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", 
"32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", 
"43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", 
"54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", 
"65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", 
"76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", 
"87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", 
"98", "99", "100", "101", "102", "103", "104", "105", "106", 
"107", "108", "109", "110", "111", "112", "113", "114", "115", 
"116", "117", "118", "119", "120", "121", "122", "123", "124", 
"125", "126", "127", "128", "129", "130", "131", "132", "133", 
"134", "135", "136", "137", "138", "139"), class = "data.frame") }


"Copenhagen" = 
function() {
structure(list(Copenhagen = structure(as.integer(c(1, 2, 3, 4, 
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 
38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 
54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
114, 115, 116, 117, 118, 119, 120)), .Label = c("1894-03-31 23:09:40", 
"1916-05-14 22:00:00", "1916-09-30 21:00:00", "1940-05-14 23:00:00", 
"1942-11-02 01:00:00", "1943-03-29 01:00:00", "1943-10-04 01:00:00", 
"1944-04-03 01:00:00", "1944-10-02 01:00:00", "1945-04-02 01:00:00", 
"1945-08-15 01:00:00", "1946-05-01 01:00:00", "1946-09-01 01:00:00", 
"1947-05-04 01:00:00", "1947-08-10 01:00:00", "1948-05-09 01:00:00", 
"1948-08-08 01:00:00", "1979-12-31 23:00:00", "1980-04-06 01:00:00", 
"1980-09-28 01:00:00", "1981-03-29 01:00:00", "1981-09-27 01:00:00", 
"1982-03-28 01:00:00", "1982-09-26 01:00:00", "1983-03-27 01:00:00", 
"1983-09-25 01:00:00", "1984-03-25 01:00:00", "1984-09-30 01:00:00", 
"1985-03-31 01:00:00", "1985-09-29 01:00:00", "1986-03-30 01:00:00", 
"1986-09-28 01:00:00", "1987-03-29 01:00:00", "1987-09-27 01:00:00", 
"1988-03-27 01:00:00", "1988-09-25 01:00:00", "1989-03-26 01:00:00", 
"1989-09-24 01:00:00", "1990-03-25 01:00:00", "1990-09-30 01:00:00", 
"1991-03-31 01:00:00", "1991-09-29 01:00:00", "1992-03-29 01:00:00", 
"1992-09-27 01:00:00", "1993-03-28 01:00:00", "1993-09-26 01:00:00", 
"1994-03-27 01:00:00", "1994-09-25 01:00:00", "1995-03-26 01:00:00", 
"1995-09-24 01:00:00", "1996-03-31 01:00:00", "1996-10-27 01:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00"), class = "factor"), 
offSet = c(3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600)), .Names = c("Copenhagen", "offSet"), row.names = c("1", 
"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
"14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
"25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", 
"36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", 
"47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", 
"58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", 
"69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", 
"80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", 
"91", "92", "93", "94", "95", "96", "97", "98", "99", "100", 
"101", "102", "103", "104", "105", "106", "107", "108", "109", 
"110", "111", "112", "113", "114", "115", "116", "117", "118", 
"119", "120"), class = "data.frame") }


"Dublin" = 
function() {
structure(list(Dublin = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, NA, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 
38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 
54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 
140, 141, 142, 143, NA, 144, 145, 146, 147, 148, 149, 150, 151, 
152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 
165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 
178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 
191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 
204, 205, 206, 207, 208, 209, 210, 211, 212, 213)), 
.Label = c("1916-05-21 02:25:21", 
"1916-10-01 02:25:21", "1917-04-08 02:00:00", "1917-09-17 02:00:00", 
"1918-03-24 02:00:00", "1918-09-30 02:00:00", "1919-03-30 02:00:00", 
"1919-09-29 02:00:00", "1920-03-28 02:00:00", "1920-10-25 02:00:00", 
"1921-04-03 02:00:00", "1921-10-03 02:00:00", "1922-03-26 02:00:00", 
"1922-10-08 02:00:00", "1923-04-22 02:00:00", "1923-09-16 02:00:00", 
"1924-04-13 02:00:00", "1924-09-21 02:00:00", "1925-04-19 02:00:00", 
"1925-10-04 02:00:00", "1926-04-18 02:00:00", "1926-10-03 02:00:00", 
"1927-04-10 02:00:00", "1927-10-02 02:00:00", "1928-04-22 02:00:00", 
"1928-10-07 02:00:00", "1929-04-21 02:00:00", "1929-10-06 02:00:00", 
"1930-04-13 02:00:00", "1930-10-05 02:00:00", "1931-04-19 02:00:00", 
"1931-10-04 02:00:00", "1932-04-17 02:00:00", "1932-10-02 02:00:00", 
"1933-04-09 02:00:00", "1933-10-08 02:00:00", "1934-04-22 02:00:00", 
"1934-10-07 02:00:00", "1935-04-14 02:00:00", "1935-10-06 02:00:00", 
"1936-04-19 02:00:00", "1936-10-04 02:00:00", "1937-04-18 02:00:00", 
"1937-10-03 02:00:00", "1938-04-10 02:00:00", "1938-10-02 02:00:00", 
"1939-04-16 02:00:00", "1939-11-19 02:00:00", "1940-02-25 02:00:00", 
"1946-10-06 01:00:00", "1947-03-16 02:00:00", "1947-11-02 01:00:00", 
"1948-04-18 02:00:00", "1948-10-31 02:00:00", "1949-04-03 02:00:00", 
"1949-10-30 02:00:00", "1950-04-16 02:00:00", "1950-10-22 02:00:00", 
"1951-04-15 02:00:00", "1951-10-21 02:00:00", "1952-04-20 02:00:00", 
"1952-10-26 02:00:00", "1953-04-19 02:00:00", "1953-10-04 02:00:00", 
"1954-04-11 02:00:00", "1954-10-03 02:00:00", "1955-04-17 02:00:00", 
"1955-10-02 02:00:00", "1956-04-22 02:00:00", "1956-10-07 02:00:00", 
"1957-04-14 02:00:00", "1957-10-06 02:00:00", "1958-04-20 02:00:00", 
"1958-10-05 02:00:00", "1959-04-19 02:00:00", "1959-10-04 02:00:00", 
"1960-04-10 02:00:00", "1960-10-02 02:00:00", "1961-03-26 02:00:00", 
"1961-10-29 02:00:00", "1962-03-25 02:00:00", "1962-10-28 02:00:00", 
"1963-03-31 02:00:00", "1963-10-27 02:00:00", "1964-03-22 02:00:00", 
"1964-10-25 02:00:00", "1965-03-21 02:00:00", "1965-10-24 02:00:00", 
"1966-03-20 02:00:00", "1966-10-23 02:00:00", "1967-03-19 02:00:00", 
"1967-10-29 02:00:00", "1968-02-18 02:00:00", "1968-10-26 23:00:00", 
"1971-10-31 02:00:00", "1972-03-19 02:00:00", "1972-10-29 02:00:00", 
"1973-03-18 02:00:00", "1973-10-28 02:00:00", "1974-03-17 02:00:00", 
"1974-10-27 02:00:00", "1975-03-16 02:00:00", "1975-10-26 02:00:00", 
"1976-03-21 02:00:00", "1976-10-24 02:00:00", "1977-03-20 02:00:00", 
"1977-10-23 02:00:00", "1978-03-19 02:00:00", "1978-10-29 02:00:00", 
"1979-03-18 02:00:00", "1979-10-28 02:00:00", "1980-03-16 02:00:00", 
"1980-10-26 02:00:00", "1981-03-29 01:00:00", "1981-10-25 01:00:00", 
"1982-03-28 01:00:00", "1982-10-24 01:00:00", "1983-03-27 01:00:00", 
"1983-10-23 01:00:00", "1984-03-25 01:00:00", "1984-10-28 01:00:00", 
"1985-03-31 01:00:00", "1985-10-27 01:00:00", "1986-03-30 01:00:00", 
"1986-10-26 01:00:00", "1987-03-29 01:00:00", "1987-10-25 01:00:00", 
"1988-03-27 01:00:00", "1988-10-23 01:00:00", "1989-03-26 01:00:00", 
"1989-10-29 01:00:00", "1990-03-25 01:00:00", "1990-10-28 01:00:00", 
"1991-03-31 01:00:00", "1991-10-27 01:00:00", "1992-03-29 01:00:00", 
"1992-10-25 01:00:00", "1993-03-28 01:00:00", "1993-10-24 01:00:00", 
"1994-03-27 01:00:00", "1994-10-23 01:00:00", "1995-03-26 01:00:00", 
"1995-10-22 01:00:00", "1996-03-31 01:00:00", "1996-10-27 01:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00"), class = "factor"), 
offSet = c(124740, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 0, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0)), .Names = c("Dublin", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", 
"9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
"20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", 
"31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", 
"42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", 
"53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", 
"64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", 
"75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", 
"86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", 
"97", "98", "99", "100", "101", "102", "103", "104", "105", "106", 
"107", "108", "109", "110", "111", "112", "113", "114", "115", 
"116", "117", "118", "119", "120", "121", "122", "123", "124", 
"125", "126", "127", "128", "129", "130", "131", "132", "133", 
"134", "135", "136", "137", "138", "139", "140", "141", "142", 
"143", "144", "145", "146", "147", "148", "149", "150", "151", 
"152", "153", "154", "155", "156", "157", "158", "159", "160", 
"161", "162", "163", "164", "165", "166", "167", "168", "169", 
"170", "171", "172", "173", "174", "175", "176", "177", "178", 
"179", "180", "181", "182", "183", "184", "185", "186", "187", 
"188", "189", "190", "191", "192", "193", "194", "195", "196", 
"197", "198", "199", "200", "201", "202", "203", "204", "205", 
"206", "207", "208", "209", "210", "211", "212", "213", "214", 
"215"), class = "data.frame") }


"Helsinki" = 
function() {
structure(list(Helsinki = structure(as.integer(c(1, 2, 3, NA, 
4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 
37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 
53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 
85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
101, 102, 103)), .Label = c("1921-04-30 22:20:08", "1942-04-02 22:00:00", 
"1942-10-02 21:00:00", "1981-03-29 01:00:00", "1981-09-27 01:00:00", 
"1982-03-28 01:00:00", "1982-09-26 01:00:00", "1983-03-27 01:00:00", 
"1983-09-25 01:00:00", "1984-03-25 01:00:00", "1984-09-30 01:00:00", 
"1985-03-31 01:00:00", "1985-09-29 01:00:00", "1986-03-30 01:00:00", 
"1986-09-28 01:00:00", "1987-03-29 01:00:00", "1987-09-27 01:00:00", 
"1988-03-27 01:00:00", "1988-09-25 01:00:00", "1989-03-26 01:00:00", 
"1989-09-24 01:00:00", "1990-03-25 01:00:00", "1990-09-30 01:00:00", 
"1991-03-31 01:00:00", "1991-09-29 01:00:00", "1992-03-29 01:00:00", 
"1992-09-27 01:00:00", "1993-03-28 01:00:00", "1993-09-26 01:00:00", 
"1994-03-27 01:00:00", "1994-09-25 01:00:00", "1995-03-26 01:00:00", 
"1995-09-24 01:00:00", "1996-03-31 01:00:00", "1996-10-27 01:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00"), class = "factor"), 
offSet = c(7200, 10800, 7200, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200)), .Names = c("Helsinki", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", 
"9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
"20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", 
"31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", 
"42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", 
"53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", 
"64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", 
"75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", 
"86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", 
"97", "98", "99", "100", "101", "102", "103", "104"), class = "data.frame") }


"Istanbul" = 
function() {
structure(list(Istanbul = structure(as.integer(c(1, 2, 3, 4, 
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 
38, 39, 40, 41, 42, 43, 44, NA, NA, 45, 46, 47, 48, 49, 50, 51, 
52, 53, NA, 54, NA, 55, NA, 56, NA, 57, 58, 59, 60, 61, 62, NA, 
NA, NA, NA, NA, NA, NA, NA, NA, NA, 63, 64, 65, 66, 67, 68, 69, 
70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 
140, 141, 142, 143)), .Label = c("1910-09-30 22:03:04", "1916-04-30 22:00:00", 
"1916-09-30 21:00:00", "1920-03-27 22:00:00", "1920-10-24 21:00:00", 
"1921-04-02 22:00:00", "1921-10-02 21:00:00", "1922-03-25 22:00:00", 
"1922-10-07 21:00:00", "1924-05-12 22:00:00", "1924-09-30 21:00:00", 
"1925-04-30 22:00:00", "1925-09-30 21:00:00", "1940-06-29 22:00:00", 
"1940-10-04 21:00:00", "1940-11-30 22:00:00", "1941-09-20 21:00:00", 
"1942-03-31 22:00:00", "1942-10-31 21:00:00", "1945-04-01 22:00:00", 
"1945-10-07 21:00:00", "1946-05-31 22:00:00", "1946-09-30 21:00:00", 
"1947-04-19 22:00:00", "1947-10-04 21:00:00", "1948-04-17 22:00:00", 
"1948-10-02 21:00:00", "1949-04-09 22:00:00", "1949-10-01 21:00:00", 
"1950-04-18 22:00:00", "1950-10-07 21:00:00", "1951-04-21 22:00:00", 
"1951-10-07 21:00:00", "1962-07-14 22:00:00", "1962-10-07 21:00:00", 
"1964-05-14 22:00:00", "1964-09-30 21:00:00", "1970-05-02 22:00:00", 
"1970-10-03 21:00:00", "1971-05-01 22:00:00", "1971-10-02 21:00:00", 
"1972-05-06 22:00:00", "1972-10-07 21:00:00", "1973-06-02 23:00:00", 
"1974-11-03 02:00:00", "1975-03-29 22:00:00", "1975-10-25 21:00:00", 
"1976-05-31 22:00:00", "1976-10-30 21:00:00", "1977-04-02 22:00:00", 
"1977-10-15 21:00:00", "1978-04-01 22:00:00", "1978-10-14 21:00:00", 
"1979-10-14 20:00:00", "1980-10-12 20:00:00", "1981-10-11 20:00:00", 
"1982-10-10 20:00:00", "1983-07-30 21:00:00", "1983-10-01 20:00:00", 
"1985-04-19 21:00:00", "1985-09-27 21:00:00", "1985-12-31 22:00:00", 
"1990-12-31 22:00:00", "1991-03-31 01:00:00", "1991-09-29 01:00:00", 
"1992-03-29 01:00:00", "1992-09-27 01:00:00", "1993-03-28 01:00:00", 
"1993-09-26 01:00:00", "1994-03-27 01:00:00", "1994-09-25 01:00:00", 
"1995-03-26 01:00:00", "1995-09-24 01:00:00", "1996-03-31 01:00:00", 
"1996-10-27 01:00:00", "1997-03-30 01:00:00", "1997-10-26 01:00:00", 
"1998-03-29 01:00:00", "1998-10-25 01:00:00", "1999-03-28 01:00:00", 
"1999-10-31 01:00:00", "2000-03-26 01:00:00", "2000-10-29 01:00:00", 
"2001-03-25 01:00:00", "2001-10-28 01:00:00", "2002-03-31 01:00:00", 
"2002-10-27 01:00:00", "2003-03-30 01:00:00", "2003-10-26 01:00:00", 
"2004-03-28 01:00:00", "2004-10-31 01:00:00", "2005-03-27 01:00:00", 
"2005-10-30 01:00:00", "2006-03-26 01:00:00", "2006-10-29 01:00:00", 
"2007-03-25 01:00:00", "2007-10-28 01:00:00", "2008-03-30 01:00:00", 
"2008-10-26 01:00:00", "2009-03-29 01:00:00", "2009-10-25 01:00:00", 
"2010-03-28 01:00:00", "2010-10-31 01:00:00", "2011-03-27 01:00:00", 
"2011-10-30 01:00:00", "2012-03-25 01:00:00", "2012-10-28 01:00:00", 
"2013-03-31 01:00:00", "2013-10-27 01:00:00", "2014-03-30 01:00:00", 
"2014-10-26 01:00:00", "2015-03-29 01:00:00", "2015-10-25 01:00:00", 
"2016-03-27 01:00:00", "2016-10-30 01:00:00", "2017-03-26 01:00:00", 
"2017-10-29 01:00:00", "2018-03-25 01:00:00", "2018-10-28 01:00:00", 
"2019-03-31 01:00:00", "2019-10-27 01:00:00", "2020-03-29 01:00:00", 
"2020-10-25 01:00:00", "2021-03-28 01:00:00", "2021-10-31 01:00:00", 
"2022-03-27 01:00:00", "2022-10-30 01:00:00", "2023-03-26 01:00:00", 
"2023-10-29 01:00:00", "2024-03-31 01:00:00", "2024-10-27 01:00:00", 
"2025-03-30 01:00:00", "2025-10-26 01:00:00", "2026-03-29 01:00:00", 
"2026-10-25 01:00:00", "2027-03-28 01:00:00", "2027-10-31 01:00:00", 
"2028-03-26 01:00:00", "2028-10-29 01:00:00", "2029-03-25 01:00:00", 
"2029-10-28 01:00:00", "2030-03-31 01:00:00", "2030-10-27 01:00:00"
), class = "factor"), offSet = c(7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 10800, 
14400, 10800, 14400, 10800, 14400, 10800, 14400, 10800, 14400, 
10800, 10800, 7200, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200)), .Names = c("Istanbul", "offSet"
), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", "9", 
"10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", 
"21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", 
"32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", 
"43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", 
"54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", 
"65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", 
"76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", 
"87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", 
"98", "99", "100", "101", "102", "103", "104", "105", "106", 
"107", "108", "109", "110", "111", "112", "113", "114", "115", 
"116", "117", "118", "119", "120", "121", "122", "123", "124", 
"125", "126", "127", "128", "129", "130", "131", "132", "133", 
"134", "135", "136", "137", "138", "139", "140", "141", "142", 
"143", "144", "145", "146", "147", "148", "149", "150", "151", 
"152", "153", "154", "155", "156", "157", "158", "159"), class = "data.frame") }


"Kiev" = 
function() {
structure(list(Kiev = structure(as.integer(c(1, 2, 3, 4, 5, 6, 
7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 
71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
102, 103, 104, 105, 106, 107)), .Label = c("1924-05-01 21:57:56", 
"1930-06-20 22:00:00", "1941-09-19 21:00:00", "1942-11-02 01:00:00", 
"1943-03-29 01:00:00", "1943-10-04 01:00:00", "1943-11-05 23:00:00", 
"1981-03-31 21:00:00", "1981-09-30 20:00:00", "1982-03-31 21:00:00", 
"1982-09-30 20:00:00", "1983-03-31 21:00:00", "1983-09-30 20:00:00", 
"1984-03-31 21:00:00", "1984-09-29 23:00:00", "1985-03-30 23:00:00", 
"1985-09-28 23:00:00", "1986-03-29 23:00:00", "1986-09-27 23:00:00", 
"1987-03-28 23:00:00", "1987-09-26 23:00:00", "1988-03-26 23:00:00", 
"1988-09-24 23:00:00", "1989-03-25 23:00:00", "1989-09-23 23:00:00", 
"1989-12-31 21:00:00", "1990-06-30 23:00:00", "1991-12-31 22:00:00", 
"1992-03-28 22:00:00", "1992-09-26 21:00:00", "1993-03-27 22:00:00", 
"1993-09-25 21:00:00", "1994-03-26 22:00:00", "1994-09-24 21:00:00", 
"1994-12-31 22:00:00", "1995-03-26 01:00:00", "1995-09-24 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00"), class = "factor"), offSet = c(7200, 10800, 
3600, 3600, 7200, 3600, 10800, 14400, 10800, 14400, 10800, 14400, 
10800, 14400, 10800, 14400, 10800, 14400, 10800, 14400, 10800, 
14400, 10800, 14400, 10800, 10800, 7200, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200)), .Names = c("Kiev", "offSet"
), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", "9", 
"10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", 
"21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", 
"32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", 
"43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", 
"54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", 
"65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", 
"76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", 
"87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", 
"98", "99", "100", "101", "102", "103", "104", "105", "106", 
"107"), class = "data.frame") }


"Lisbon" = 
function() {
structure(list(Lisbon = structure(as.integer(c(1, 2, NA, 3, 4, 
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 
38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 
54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, NA, NA, NA, NA, 
NA, NA, 98, NA, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 
109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 
122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 
135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 
148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 
161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 
174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 
187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199
)), .Label = c("1911-05-24 00:36:32", "1916-06-17 23:00:00", 
"1917-02-28 23:00:00", "1917-10-14 23:00:00", "1918-03-01 23:00:00", 
"1918-10-14 23:00:00", "1919-02-28 23:00:00", "1919-10-14 23:00:00", 
"1920-02-29 23:00:00", "1920-10-14 23:00:00", "1921-02-28 23:00:00", 
"1921-10-14 23:00:00", "1924-04-16 23:00:00", "1924-10-14 23:00:00", 
"1926-04-17 23:00:00", "1926-10-02 23:00:00", "1927-04-09 23:00:00", 
"1927-10-01 23:00:00", "1928-04-14 23:00:00", "1928-10-06 23:00:00", 
"1929-04-20 23:00:00", "1929-10-05 23:00:00", "1931-04-18 23:00:00", 
"1931-10-03 23:00:00", "1932-04-02 23:00:00", "1932-10-01 23:00:00", 
"1934-04-07 23:00:00", "1934-10-06 23:00:00", "1935-03-30 23:00:00", 
"1935-10-05 23:00:00", "1936-04-18 23:00:00", "1936-10-03 23:00:00", 
"1937-04-03 23:00:00", "1937-10-02 23:00:00", "1938-03-26 23:00:00", 
"1938-10-01 23:00:00", "1939-04-15 23:00:00", "1939-11-18 23:00:00", 
"1940-02-24 23:00:00", "1940-10-05 23:00:00", "1941-04-05 23:00:00", 
"1941-10-05 23:00:00", "1942-03-14 23:00:00", "1942-04-25 22:00:00", 
"1942-08-15 22:00:00", "1942-10-24 23:00:00", "1943-03-13 23:00:00", 
"1943-04-17 22:00:00", "1943-08-28 22:00:00", "1943-10-30 23:00:00", 
"1944-03-11 23:00:00", "1944-04-22 22:00:00", "1944-08-26 22:00:00", 
"1944-10-28 23:00:00", "1945-03-10 23:00:00", "1945-04-21 22:00:00", 
"1945-08-25 22:00:00", "1945-10-27 23:00:00", "1946-04-06 23:00:00", 
"1946-10-05 23:00:00", "1947-04-06 02:00:00", "1947-10-05 02:00:00", 
"1948-04-04 02:00:00", "1948-10-03 02:00:00", "1949-04-03 02:00:00", 
"1949-10-02 02:00:00", "1951-04-01 02:00:00", "1951-10-07 02:00:00", 
"1952-04-06 02:00:00", "1952-10-05 02:00:00", "1953-04-05 02:00:00", 
"1953-10-04 02:00:00", "1954-04-04 02:00:00", "1954-10-03 02:00:00", 
"1955-04-03 02:00:00", "1955-10-02 02:00:00", "1956-04-01 02:00:00", 
"1956-10-07 02:00:00", "1957-04-07 02:00:00", "1957-10-06 02:00:00", 
"1958-04-06 02:00:00", "1958-10-05 02:00:00", "1959-04-05 02:00:00", 
"1959-10-04 02:00:00", "1960-04-03 02:00:00", "1960-10-02 02:00:00", 
"1961-04-02 02:00:00", "1961-10-01 02:00:00", "1962-04-01 02:00:00", 
"1962-10-07 02:00:00", "1963-04-07 02:00:00", "1963-10-06 02:00:00", 
"1964-04-05 02:00:00", "1964-10-04 02:00:00", "1965-04-04 02:00:00", 
"1965-10-03 02:00:00", "1966-04-03 02:00:00", "1979-09-30 01:00:00", 
"1980-09-28 01:00:00", "1981-03-29 01:00:00", "1981-09-27 01:00:00", 
"1982-03-28 01:00:00", "1982-09-26 01:00:00", "1983-03-27 02:00:00", 
"1983-09-25 01:00:00", "1984-03-25 01:00:00", "1984-09-30 01:00:00", 
"1985-03-31 01:00:00", "1985-09-29 01:00:00", "1986-03-30 01:00:00", 
"1986-09-28 01:00:00", "1987-03-29 01:00:00", "1987-09-27 01:00:00", 
"1988-03-27 01:00:00", "1988-09-25 01:00:00", "1989-03-26 01:00:00", 
"1989-09-24 01:00:00", "1990-03-25 01:00:00", "1990-09-30 01:00:00", 
"1991-03-31 01:00:00", "1991-09-29 01:00:00", "1992-03-29 01:00:00", 
"1992-09-27 01:00:00", "1993-03-28 01:00:00", "1993-09-26 01:00:00", 
"1994-03-27 01:00:00", "1994-09-25 01:00:00", "1995-03-26 01:00:00", 
"1995-09-24 01:00:00", "1996-03-31 01:00:00", "1996-10-27 01:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00"), class = "factor"), 
offSet = c(0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 3600, 0, 3600, 7200, 3600, 0, 3600, 7200, 
3600, 0, 3600, 7200, 3600, 0, 3600, 7200, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 3600, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 0, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 3600, 0)), .Names = c("Lisbon", "offSet"
), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", "9", 
"10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", 
"21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", 
"32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", 
"43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", 
"54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", 
"65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", 
"76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", 
"87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", 
"98", "99", "100", "101", "102", "103", "104", "105", "106", 
"107", "108", "109", "110", "111", "112", "113", "114", "115", 
"116", "117", "118", "119", "120", "121", "122", "123", "124", 
"125", "126", "127", "128", "129", "130", "131", "132", "133", 
"134", "135", "136", "137", "138", "139", "140", "141", "142", 
"143", "144", "145", "146", "147", "148", "149", "150", "151", 
"152", "153", "154", "155", "156", "157", "158", "159", "160", 
"161", "162", "163", "164", "165", "166", "167", "168", "169", 
"170", "171", "172", "173", "174", "175", "176", "177", "178", 
"179", "180", "181", "182", "183", "184", "185", "186", "187", 
"188", "189", "190", "191", "192", "193", "194", "195", "196", 
"197", "198", "199", "200", "201", "202", "203", "204", "205", 
"206", "207"), class = "data.frame") }


"Ljubljana" = 
function() {
structure(list(Ljubljana = structure(as.integer(c(1, 2, 3, 4, 
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 
38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 
54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
101, 102, 103, 104, 105)), .Label = c("1941-04-18 22:00:00", 
"1942-11-02 01:00:00", "1943-03-29 01:00:00", "1943-10-04 01:00:00", 
"1944-04-03 01:00:00", "1944-10-02 01:00:00", "1945-05-08 01:00:00", 
"1945-09-16 01:00:00", "1982-11-26 23:00:00", "1983-03-27 01:00:00", 
"1983-09-25 01:00:00", "1984-03-25 01:00:00", "1984-09-30 01:00:00", 
"1985-03-31 01:00:00", "1985-09-29 01:00:00", "1986-03-30 01:00:00", 
"1986-09-28 01:00:00", "1987-03-29 01:00:00", "1987-09-27 01:00:00", 
"1988-03-27 01:00:00", "1988-09-25 01:00:00", "1989-03-26 01:00:00", 
"1989-09-24 01:00:00", "1990-03-25 01:00:00", "1990-09-30 01:00:00", 
"1991-03-31 01:00:00", "1991-09-29 01:00:00", "1992-03-29 01:00:00", 
"1992-09-27 01:00:00", "1993-03-28 01:00:00", "1993-09-26 01:00:00", 
"1994-03-27 01:00:00", "1994-09-25 01:00:00", "1995-03-26 01:00:00", 
"1995-09-24 01:00:00", "1996-03-31 01:00:00", "1996-10-27 01:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00"), class = "factor"), 
offSet = c(3600, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600)), .Names = c("Ljubljana", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", 
"9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
"20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", 
"31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", 
"42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", 
"53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", 
"64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", 
"75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", 
"86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", 
"97", "98", "99", "100", "101", "102", "103", "104", "105"), 
class = "data.frame") }


"London" = 
function() {
structure(list(London = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 
71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
154, 155, 156, 157, NA, 158, 159, 160, 161, 162, 163, 164, 165, 
166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 
179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 
192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 
205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 
218, 219, 220, 221, 222, 223, 224, 225, 226, 227)), 
.Label = c("1916-05-21 02:00:00", 
"1916-10-01 02:00:00", "1917-04-08 02:00:00", "1917-09-17 02:00:00", 
"1918-03-24 02:00:00", "1918-09-30 02:00:00", "1919-03-30 02:00:00", 
"1919-09-29 02:00:00", "1920-03-28 02:00:00", "1920-10-25 02:00:00", 
"1921-04-03 02:00:00", "1921-10-03 02:00:00", "1922-03-26 02:00:00", 
"1922-10-08 02:00:00", "1923-04-22 02:00:00", "1923-09-16 02:00:00", 
"1924-04-13 02:00:00", "1924-09-21 02:00:00", "1925-04-19 02:00:00", 
"1925-10-04 02:00:00", "1926-04-18 02:00:00", "1926-10-03 02:00:00", 
"1927-04-10 02:00:00", "1927-10-02 02:00:00", "1928-04-22 02:00:00", 
"1928-10-07 02:00:00", "1929-04-21 02:00:00", "1929-10-06 02:00:00", 
"1930-04-13 02:00:00", "1930-10-05 02:00:00", "1931-04-19 02:00:00", 
"1931-10-04 02:00:00", "1932-04-17 02:00:00", "1932-10-02 02:00:00", 
"1933-04-09 02:00:00", "1933-10-08 02:00:00", "1934-04-22 02:00:00", 
"1934-10-07 02:00:00", "1935-04-14 02:00:00", "1935-10-06 02:00:00", 
"1936-04-19 02:00:00", "1936-10-04 02:00:00", "1937-04-18 02:00:00", 
"1937-10-03 02:00:00", "1938-04-10 02:00:00", "1938-10-02 02:00:00", 
"1939-04-16 02:00:00", "1939-11-19 02:00:00", "1940-02-25 02:00:00", 
"1941-05-04 01:00:00", "1941-08-10 01:00:00", "1942-04-05 01:00:00", 
"1942-08-09 01:00:00", "1943-04-04 01:00:00", "1943-08-15 01:00:00", 
"1944-04-02 01:00:00", "1944-09-17 01:00:00", "1945-04-02 01:00:00", 
"1945-07-15 01:00:00", "1945-10-07 02:00:00", "1946-04-14 02:00:00", 
"1946-10-06 02:00:00", "1947-03-16 02:00:00", "1947-04-13 01:00:00", 
"1947-08-10 01:00:00", "1947-11-02 02:00:00", "1948-03-14 02:00:00", 
"1948-10-31 02:00:00", "1949-04-03 02:00:00", "1949-10-30 02:00:00", 
"1950-04-16 02:00:00", "1950-10-22 02:00:00", "1951-04-15 02:00:00", 
"1951-10-21 02:00:00", "1952-04-20 02:00:00", "1952-10-26 02:00:00", 
"1953-04-19 02:00:00", "1953-10-04 02:00:00", "1954-04-11 02:00:00", 
"1954-10-03 02:00:00", "1955-04-17 02:00:00", "1955-10-02 02:00:00", 
"1956-04-22 02:00:00", "1956-10-07 02:00:00", "1957-04-14 02:00:00", 
"1957-10-06 02:00:00", "1958-04-20 02:00:00", "1958-10-05 02:00:00", 
"1959-04-19 02:00:00", "1959-10-04 02:00:00", "1960-04-10 02:00:00", 
"1960-10-02 02:00:00", "1961-03-26 02:00:00", "1961-10-29 02:00:00", 
"1962-03-25 02:00:00", "1962-10-28 02:00:00", "1963-03-31 02:00:00", 
"1963-10-27 02:00:00", "1964-03-22 02:00:00", "1964-10-25 02:00:00", 
"1965-03-21 02:00:00", "1965-10-24 02:00:00", "1966-03-20 02:00:00", 
"1966-10-23 02:00:00", "1967-03-19 02:00:00", "1967-10-29 02:00:00", 
"1968-02-18 02:00:00", "1968-10-26 23:00:00", "1971-10-31 02:00:00", 
"1972-03-19 02:00:00", "1972-10-29 02:00:00", "1973-03-18 02:00:00", 
"1973-10-28 02:00:00", "1974-03-17 02:00:00", "1974-10-27 02:00:00", 
"1975-03-16 02:00:00", "1975-10-26 02:00:00", "1976-03-21 02:00:00", 
"1976-10-24 02:00:00", "1977-03-20 02:00:00", "1977-10-23 02:00:00", 
"1978-03-19 02:00:00", "1978-10-29 02:00:00", "1979-03-18 02:00:00", 
"1979-10-28 02:00:00", "1980-03-16 02:00:00", "1980-10-26 02:00:00", 
"1981-03-29 01:00:00", "1981-10-25 01:00:00", "1982-03-28 01:00:00", 
"1982-10-24 01:00:00", "1983-03-27 01:00:00", "1983-10-23 01:00:00", 
"1984-03-25 01:00:00", "1984-10-28 01:00:00", "1985-03-31 01:00:00", 
"1985-10-27 01:00:00", "1986-03-30 01:00:00", "1986-10-26 01:00:00", 
"1987-03-29 01:00:00", "1987-10-25 01:00:00", "1988-03-27 01:00:00", 
"1988-10-23 01:00:00", "1989-03-26 01:00:00", "1989-10-29 01:00:00", 
"1990-03-25 01:00:00", "1990-10-28 01:00:00", "1991-03-31 01:00:00", 
"1991-10-27 01:00:00", "1992-03-29 01:00:00", "1992-10-25 01:00:00", 
"1993-03-28 01:00:00", "1993-10-24 01:00:00", "1994-03-27 01:00:00", 
"1994-10-23 01:00:00", "1995-03-26 01:00:00", "1995-10-22 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00"), class = "factor"), offSet = c(3600, 0, 
3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 0, 3600, 0, 3600, 7200, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0)), .Names = c("London", "offSet"), row.names = c("1", 
"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
"14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
"25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", 
"36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", 
"47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", 
"58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", 
"69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", 
"80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", 
"91", "92", "93", "94", "95", "96", "97", "98", "99", "100", 
"101", "102", "103", "104", "105", "106", "107", "108", "109", 
"110", "111", "112", "113", "114", "115", "116", "117", "118", 
"119", "120", "121", "122", "123", "124", "125", "126", "127", 
"128", "129", "130", "131", "132", "133", "134", "135", "136", 
"137", "138", "139", "140", "141", "142", "143", "144", "145", 
"146", "147", "148", "149", "150", "151", "152", "153", "154", 
"155", "156", "157", "158", "159", "160", "161", "162", "163", 
"164", "165", "166", "167", "168", "169", "170", "171", "172", 
"173", "174", "175", "176", "177", "178", "179", "180", "181", 
"182", "183", "184", "185", "186", "187", "188", "189", "190", 
"191", "192", "193", "194", "195", "196", "197", "198", "199", 
"200", "201", "202", "203", "204", "205", "206", "207", "208", 
"209", "210", "211", "212", "213", "214", "215", "216", "217", 
"218", "219", "220", "221", "222", "223", "224", "225", "226", 
"227", "228"), class = "data.frame") }


"Luxembourg" = 
function() {
structure(list(Luxembourg = structure(as.integer(c(1, 2, 3, 4, 
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, NA, 15, 16, 17, NA, 18, NA, 
19, NA, 20, NA, 21, NA, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 
32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 
48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 
64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 
80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 
96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 
109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 
122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 
135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 
148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 
161, 162, 163)), .Label = c("1916-05-14 22:00:00", "1916-09-30 23:00:00", 
"1917-04-28 22:00:00", "1917-09-16 23:00:00", "1918-04-15 01:00:00", 
"1918-09-16 01:00:00", "1918-11-24 23:00:00", "1919-03-01 23:00:00", 
"1919-10-05 02:00:00", "1920-02-14 23:00:00", "1920-10-24 01:00:00", 
"1921-03-14 23:00:00", "1921-10-26 01:00:00", "1922-03-25 23:00:00", 
"1923-04-21 23:00:00", "1923-10-07 01:00:00", "1924-03-29 23:00:00", 
"1925-04-05 23:00:00", "1926-04-17 23:00:00", "1927-04-09 23:00:00", 
"1928-04-14 23:00:00", "1929-04-20 23:00:00", "1929-10-06 02:00:00", 
"1930-04-13 02:00:00", "1930-10-05 02:00:00", "1931-04-19 02:00:00", 
"1931-10-04 02:00:00", "1932-04-03 02:00:00", "1932-10-02 02:00:00", 
"1933-03-26 02:00:00", "1933-10-08 02:00:00", "1934-04-08 02:00:00", 
"1934-10-07 02:00:00", "1935-03-31 02:00:00", "1935-10-06 02:00:00", 
"1936-04-19 02:00:00", "1936-10-04 02:00:00", "1937-04-04 02:00:00", 
"1937-10-03 02:00:00", "1938-03-27 02:00:00", "1938-10-02 02:00:00", 
"1939-04-16 02:00:00", "1939-11-19 02:00:00", "1940-02-25 02:00:00", 
"1940-05-14 02:00:00", "1942-11-02 01:00:00", "1943-03-29 01:00:00", 
"1943-10-04 01:00:00", "1944-04-03 01:00:00", "1944-09-18 01:00:00", 
"1945-04-02 01:00:00", "1945-09-16 01:00:00", "1946-05-19 01:00:00", 
"1946-10-07 01:00:00", "1976-12-31 23:00:00", "1977-04-03 01:00:00", 
"1977-09-25 01:00:00", "1978-04-02 01:00:00", "1978-10-01 01:00:00", 
"1979-04-01 01:00:00", "1979-09-30 01:00:00", "1980-04-06 01:00:00", 
"1980-09-28 01:00:00", "1981-03-29 01:00:00", "1981-09-27 01:00:00", 
"1982-03-28 01:00:00", "1982-09-26 01:00:00", "1983-03-27 01:00:00", 
"1983-09-25 01:00:00", "1984-03-25 01:00:00", "1984-09-30 01:00:00", 
"1985-03-31 01:00:00", "1985-09-29 01:00:00", "1986-03-30 01:00:00", 
"1986-09-28 01:00:00", "1987-03-29 01:00:00", "1987-09-27 01:00:00", 
"1988-03-27 01:00:00", "1988-09-25 01:00:00", "1989-03-26 01:00:00", 
"1989-09-24 01:00:00", "1990-03-25 01:00:00", "1990-09-30 01:00:00", 
"1991-03-31 01:00:00", "1991-09-29 01:00:00", "1992-03-29 01:00:00", 
"1992-09-27 01:00:00", "1993-03-28 01:00:00", "1993-09-26 01:00:00", 
"1994-03-27 01:00:00", "1994-09-25 01:00:00", "1995-03-26 01:00:00", 
"1995-09-24 01:00:00", "1996-03-31 01:00:00", "1996-10-27 01:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00"), class = "factor"), 
offSet = c(7200, 3600, 7200, 3600, 7200, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 3600, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600)), .Names = c("Luxembourg", "offSet"), row.names = c("1", 
"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
"14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
"25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", 
"36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", 
"47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", 
"58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", 
"69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", 
"80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", 
"91", "92", "93", "94", "95", "96", "97", "98", "99", "100", 
"101", "102", "103", "104", "105", "106", "107", "108", "109", 
"110", "111", "112", "113", "114", "115", "116", "117", "118", 
"119", "120", "121", "122", "123", "124", "125", "126", "127", 
"128", "129", "130", "131", "132", "133", "134", "135", "136", 
"137", "138", "139", "140", "141", "142", "143", "144", "145", 
"146", "147", "148", "149", "150", "151", "152", "153", "154", 
"155", "156", "157", "158", "159", "160", "161", "162", "163", 
"164", "165", "166", "167", "168", "169"), class = "data.frame") }


"Madrid" = 
function() {
structure(list(Madrid = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 
71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
141, 142, 143, 144, 145, 146, 147, 148, 149, 150)), 
.Label = c("1917-05-05 23:00:00", 
"1917-10-06 23:00:00", "1918-04-15 23:00:00", "1918-10-06 23:00:00", 
"1919-04-05 23:00:00", "1919-10-06 23:00:00", "1924-04-16 23:00:00", 
"1924-10-04 23:00:00", "1926-04-17 23:00:00", "1926-10-02 23:00:00", 
"1927-04-09 23:00:00", "1927-10-01 23:00:00", "1928-04-14 23:00:00", 
"1928-10-06 23:00:00", "1929-04-20 23:00:00", "1929-10-05 23:00:00", 
"1937-05-22 23:00:00", "1937-10-02 23:00:00", "1938-03-22 23:00:00", 
"1938-10-01 23:00:00", "1939-04-15 23:00:00", "1939-10-07 23:00:00", 
"1940-03-16 23:00:00", "1942-05-02 22:00:00", "1942-09-01 22:00:00", 
"1943-04-17 22:00:00", "1943-10-03 22:00:00", "1944-04-15 22:00:00", 
"1944-10-10 22:00:00", "1945-04-14 22:00:00", "1945-09-29 23:00:00", 
"1946-04-13 22:00:00", "1946-09-29 22:00:00", "1949-04-30 22:00:00", 
"1949-09-29 23:00:00", "1974-04-13 22:00:00", "1974-10-05 23:00:00", 
"1975-04-19 22:00:00", "1975-10-04 23:00:00", "1976-03-27 22:00:00", 
"1976-09-25 23:00:00", "1977-04-02 22:00:00", "1977-09-24 23:00:00", 
"1978-04-02 22:00:00", "1978-09-30 23:00:00", "1978-12-31 23:00:00", 
"1979-04-01 01:00:00", "1979-09-30 01:00:00", "1980-04-06 01:00:00", 
"1980-09-28 01:00:00", "1981-03-29 01:00:00", "1981-09-27 01:00:00", 
"1982-03-28 01:00:00", "1982-09-26 01:00:00", "1983-03-27 01:00:00", 
"1983-09-25 01:00:00", "1984-03-25 01:00:00", "1984-09-30 01:00:00", 
"1985-03-31 01:00:00", "1985-09-29 01:00:00", "1986-03-30 01:00:00", 
"1986-09-28 01:00:00", "1987-03-29 01:00:00", "1987-09-27 01:00:00", 
"1988-03-27 01:00:00", "1988-09-25 01:00:00", "1989-03-26 01:00:00", 
"1989-09-24 01:00:00", "1990-03-25 01:00:00", "1990-09-30 01:00:00", 
"1991-03-31 01:00:00", "1991-09-29 01:00:00", "1992-03-29 01:00:00", 
"1992-09-27 01:00:00", "1993-03-28 01:00:00", "1993-09-26 01:00:00", 
"1994-03-27 01:00:00", "1994-09-25 01:00:00", "1995-03-26 01:00:00", 
"1995-09-24 01:00:00", "1996-03-31 01:00:00", "1996-10-27 01:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00"), class = "factor"), 
offSet = c(3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600)), .Names = c("Madrid", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", 
"9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
"20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", 
"31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", 
"42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", 
"53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", 
"64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", 
"75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", 
"86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", 
"97", "98", "99", "100", "101", "102", "103", "104", "105", "106", 
"107", "108", "109", "110", "111", "112", "113", "114", "115", 
"116", "117", "118", "119", "120", "121", "122", "123", "124", 
"125", "126", "127", "128", "129", "130", "131", "132", "133", 
"134", "135", "136", "137", "138", "139", "140", "141", "142", 
"143", "144", "145", "146", "147", "148", "149", "150"), 
class = "data.frame") }


"Monaco" = 
function() {
structure(list(Monaco = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
55, 56, 57, 58, 59, 60, NA, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 
140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 
153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 
166, 167, 168, 169, 170)), .Label = c("1911-03-10 23:50:39", 
"1916-06-14 23:00:00", "1916-10-01 23:00:00", "1917-03-24 23:00:00", 
"1917-10-07 23:00:00", "1918-03-09 23:00:00", "1918-10-06 23:00:00", 
"1919-03-01 23:00:00", "1919-10-05 23:00:00", "1920-02-14 23:00:00", 
"1920-10-23 23:00:00", "1921-03-14 23:00:00", "1921-10-25 23:00:00", 
"1922-03-25 23:00:00", "1922-10-07 23:00:00", "1923-05-26 23:00:00", 
"1923-10-06 23:00:00", "1924-03-29 23:00:00", "1924-10-04 23:00:00", 
"1925-04-04 23:00:00", "1925-10-03 23:00:00", "1926-04-17 23:00:00", 
"1926-10-02 23:00:00", "1927-04-09 23:00:00", "1927-10-01 23:00:00", 
"1928-04-14 23:00:00", "1928-10-06 23:00:00", "1929-04-20 23:00:00", 
"1929-10-05 23:00:00", "1930-04-12 23:00:00", "1930-10-04 23:00:00", 
"1931-04-18 23:00:00", "1931-10-03 23:00:00", "1932-04-02 23:00:00", 
"1932-10-01 23:00:00", "1933-03-25 23:00:00", "1933-10-07 23:00:00", 
"1934-04-07 23:00:00", "1934-10-06 23:00:00", "1935-03-30 23:00:00", 
"1935-10-05 23:00:00", "1936-04-18 23:00:00", "1936-10-03 23:00:00", 
"1937-04-03 23:00:00", "1937-10-02 23:00:00", "1938-03-26 23:00:00", 
"1938-10-01 23:00:00", "1939-04-15 23:00:00", "1939-11-18 23:00:00", 
"1940-02-25 02:00:00", "1941-05-04 23:00:00", "1941-10-05 22:00:00", 
"1942-03-08 23:00:00", "1942-11-02 01:00:00", "1943-03-29 01:00:00", 
"1943-10-04 01:00:00", "1944-04-03 01:00:00", "1944-10-07 23:00:00", 
"1945-04-02 01:00:00", "1945-09-16 01:00:00", "1976-09-25 23:00:00", 
"1976-12-31 23:00:00", "1977-04-03 01:00:00", "1977-09-25 01:00:00", 
"1978-04-02 01:00:00", "1978-10-01 01:00:00", "1979-04-01 01:00:00", 
"1979-09-30 01:00:00", "1980-04-06 01:00:00", "1980-09-28 01:00:00", 
"1981-03-29 01:00:00", "1981-09-27 01:00:00", "1982-03-28 01:00:00", 
"1982-09-26 01:00:00", "1983-03-27 01:00:00", "1983-09-25 01:00:00", 
"1984-03-25 01:00:00", "1984-09-30 01:00:00", "1985-03-31 01:00:00", 
"1985-09-29 01:00:00", "1986-03-30 01:00:00", "1986-09-28 01:00:00", 
"1987-03-29 01:00:00", "1987-09-27 01:00:00", "1988-03-27 01:00:00", 
"1988-09-25 01:00:00", "1989-03-26 01:00:00", "1989-09-24 01:00:00", 
"1990-03-25 01:00:00", "1990-09-30 01:00:00", "1991-03-31 01:00:00", 
"1991-09-29 01:00:00", "1992-03-29 01:00:00", "1992-09-27 01:00:00", 
"1993-03-28 01:00:00", "1993-09-26 01:00:00", "1994-03-27 01:00:00", 
"1994-09-25 01:00:00", "1995-03-26 01:00:00", "1995-09-24 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00"), class = "factor"), offSet = c(0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600)), .Names = c("Monaco", "offSet"
), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", "9", 
"10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", 
"21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", 
"32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", 
"43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", 
"54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", 
"65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", 
"76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", 
"87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", 
"98", "99", "100", "101", "102", "103", "104", "105", "106", 
"107", "108", "109", "110", "111", "112", "113", "114", "115", 
"116", "117", "118", "119", "120", "121", "122", "123", "124", 
"125", "126", "127", "128", "129", "130", "131", "132", "133", 
"134", "135", "136", "137", "138", "139", "140", "141", "142", 
"143", "144", "145", "146", "147", "148", "149", "150", "151", 
"152", "153", "154", "155", "156", "157", "158", "159", "160", 
"161", "162", "163", "164", "165", "166", "167", "168", "169", 
"170", "171"), class = "data.frame") }


"Moscow" = 
function() {
structure(list(Moscow = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, NA, NA, 36, 
37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 
53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 
85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113
)), .Label = c("1916-07-02 21:30:00", "1917-07-01 20:29:12", 
"1917-12-27 20:29:12", "1918-05-31 19:29:12", "1918-09-15 20:29:12", 
"1919-05-31 19:29:12", "1919-06-30 21:29:12", "1919-08-15 20:00:00", 
"1921-02-14 20:00:00", "1921-03-20 19:00:00", "1921-08-31 19:00:00", 
"1921-09-30 20:00:00", "1922-09-30 21:00:00", "1930-06-20 22:00:00", 
"1981-03-31 21:00:00", "1981-09-30 20:00:00", "1982-03-31 21:00:00", 
"1982-09-30 20:00:00", "1983-03-31 21:00:00", "1983-09-30 20:00:00", 
"1984-03-31 21:00:00", "1984-09-29 23:00:00", "1985-03-30 23:00:00", 
"1985-09-28 23:00:00", "1986-03-29 23:00:00", "1986-09-27 23:00:00", 
"1987-03-28 23:00:00", "1987-09-26 23:00:00", "1988-03-26 23:00:00", 
"1988-09-24 23:00:00", "1989-03-25 23:00:00", "1989-09-23 23:00:00", 
"1990-03-24 23:00:00", "1990-09-29 23:00:00", "1991-03-30 23:00:00", 
"1992-03-28 20:00:00", "1992-09-26 19:00:00", "1993-03-27 23:00:00", 
"1993-09-25 23:00:00", "1994-03-26 23:00:00", "1994-09-24 23:00:00", 
"1995-03-25 23:00:00", "1995-09-23 23:00:00", "1996-03-30 23:00:00", 
"1996-10-26 23:00:00", "1997-03-29 23:00:00", "1997-10-25 23:00:00", 
"1998-03-28 23:00:00", "1998-10-24 23:00:00", "1999-03-27 23:00:00", 
"1999-10-30 23:00:00", "2000-03-25 23:00:00", "2000-10-28 23:00:00", 
"2001-03-24 23:00:00", "2001-10-27 23:00:00", "2002-03-30 23:00:00", 
"2002-10-26 23:00:00", "2003-03-29 23:00:00", "2003-10-25 23:00:00", 
"2004-03-27 23:00:00", "2004-10-30 23:00:00", "2005-03-26 23:00:00", 
"2005-10-29 23:00:00", "2006-03-25 23:00:00", "2006-10-28 23:00:00", 
"2007-03-24 23:00:00", "2007-10-27 23:00:00", "2008-03-29 23:00:00", 
"2008-10-25 23:00:00", "2009-03-28 23:00:00", "2009-10-24 23:00:00", 
"2010-03-27 23:00:00", "2010-10-30 23:00:00", "2011-03-26 23:00:00", 
"2011-10-29 23:00:00", "2012-03-24 23:00:00", "2012-10-27 23:00:00", 
"2013-03-30 23:00:00", "2013-10-26 23:00:00", "2014-03-29 23:00:00", 
"2014-10-25 23:00:00", "2015-03-28 23:00:00", "2015-10-24 23:00:00", 
"2016-03-26 23:00:00", "2016-10-29 23:00:00", "2017-03-25 23:00:00", 
"2017-10-28 23:00:00", "2018-03-24 23:00:00", "2018-10-27 23:00:00", 
"2019-03-30 23:00:00", "2019-10-26 23:00:00", "2020-03-28 23:00:00", 
"2020-10-24 23:00:00", "2021-03-27 23:00:00", "2021-10-30 23:00:00", 
"2022-03-26 23:00:00", "2022-10-29 23:00:00", "2023-03-25 23:00:00", 
"2023-10-28 23:00:00", "2024-03-30 23:00:00", "2024-10-26 23:00:00", 
"2025-03-29 23:00:00", "2025-10-25 23:00:00", "2026-03-28 23:00:00", 
"2026-10-24 23:00:00", "2027-03-27 23:00:00", "2027-10-30 23:00:00", 
"2028-03-25 23:00:00", "2028-10-28 23:00:00", "2029-03-24 23:00:00", 
"2029-10-27 23:00:00", "2030-03-30 23:00:00", "2030-10-26 23:00:00"
), class = "factor"), offSet = c(830880, 1190880, 830880, 1550880, 
1190880, 1550880, 14400, 10800, 14400, 18000, 14400, 10800, 7200, 
10800, 14400, 10800, 14400, 10800, 14400, 10800, 14400, 10800, 
14400, 10800, 14400, 10800, 14400, 10800, 14400, 10800, 14400, 
10800, 14400, 10800, 10800, 7200, 10800, 14400, 10800, 14400, 
10800, 14400, 10800, 14400, 10800, 14400, 10800, 14400, 10800, 
14400, 10800, 14400, 10800, 14400, 10800, 14400, 10800, 14400, 
10800, 14400, 10800, 14400, 10800, 14400, 10800, 14400, 10800, 
14400, 10800, 14400, 10800, 14400, 10800, 14400, 10800, 14400, 
10800, 14400, 10800, 14400, 10800, 14400, 10800, 14400, 10800, 
14400, 10800, 14400, 10800, 14400, 10800, 14400, 10800, 14400, 
10800, 14400, 10800, 14400, 10800, 14400, 10800, 14400, 10800, 
14400, 10800, 14400, 10800, 14400, 10800, 14400, 10800, 14400, 
10800, 14400, 10800)), .Names = c("Moscow", "offSet"), row.names = c("1", 
"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
"14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
"25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", 
"36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", 
"47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", 
"58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", 
"69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", 
"80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", 
"91", "92", "93", "94", "95", "96", "97", "98", "99", "100", 
"101", "102", "103", "104", "105", "106", "107", "108", "109", 
"110", "111", "112", "113", "114", "115"), class = "data.frame") }


"Nicosia" = 
function() {
structure(list(Nicosia = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 
71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113)), 
.Label = c("1975-04-12 22:00:00", 
"1975-10-11 21:00:00", "1976-05-14 22:00:00", "1976-10-10 21:00:00", 
"1977-04-02 22:00:00", "1977-09-24 21:00:00", "1978-04-01 22:00:00", 
"1978-10-01 21:00:00", "1979-03-31 22:00:00", "1979-09-29 21:00:00", 
"1980-04-05 22:00:00", "1980-09-27 21:00:00", "1981-03-28 22:00:00", 
"1981-09-26 21:00:00", "1982-03-27 22:00:00", "1982-09-25 21:00:00", 
"1983-03-26 22:00:00", "1983-09-24 21:00:00", "1984-03-24 22:00:00", 
"1984-09-29 21:00:00", "1985-03-30 22:00:00", "1985-09-28 21:00:00", 
"1986-03-29 22:00:00", "1986-09-27 21:00:00", "1987-03-28 22:00:00", 
"1987-09-26 21:00:00", "1988-03-26 22:00:00", "1988-09-24 21:00:00", 
"1989-03-25 22:00:00", "1989-09-23 21:00:00", "1990-03-24 22:00:00", 
"1990-09-29 21:00:00", "1991-03-30 22:00:00", "1991-09-28 21:00:00", 
"1992-03-28 22:00:00", "1992-09-26 21:00:00", "1993-03-27 22:00:00", 
"1993-09-25 21:00:00", "1994-03-26 22:00:00", "1994-09-24 21:00:00", 
"1995-03-25 22:00:00", "1995-09-23 21:00:00", "1996-03-30 22:00:00", 
"1996-09-28 21:00:00", "1997-03-29 22:00:00", "1997-09-27 21:00:00", 
"1998-03-28 22:00:00", "1998-08-31 21:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00"), class = "factor"), offSet = c(10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200)), .Names = c("Nicosia", "offSet"), row.names = c("1", 
"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
"14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
"25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", 
"36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", 
"47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", 
"58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", 
"69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", 
"80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", 
"91", "92", "93", "94", "95", "96", "97", "98", "99", "100", 
"101", "102", "103", "104", "105", "106", "107", "108", "109", 
"110", "111", "112", "113"), class = "data.frame") }


"Oslo" = 
function() {
structure(list(Oslo = structure(as.integer(c(NA, 1, 2, 3, 4, 
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 
38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 
54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126
)), .Label = c("1916-09-29 22:00:00", "1940-08-10 22:00:00", 
"1942-11-02 01:00:00", "1943-03-29 01:00:00", "1943-10-04 01:00:00", 
"1944-04-03 01:00:00", "1944-10-02 01:00:00", "1945-04-02 01:00:00", 
"1945-10-01 01:00:00", "1959-03-15 01:00:00", "1959-09-20 01:00:00", 
"1960-03-20 01:00:00", "1960-09-18 01:00:00", "1961-03-19 01:00:00", 
"1961-09-17 01:00:00", "1962-03-18 01:00:00", "1962-09-16 01:00:00", 
"1963-03-17 01:00:00", "1963-09-15 01:00:00", "1964-03-15 01:00:00", 
"1964-09-20 01:00:00", "1965-04-25 01:00:00", "1965-09-19 01:00:00", 
"1979-12-31 23:00:00", "1980-04-06 01:00:00", "1980-09-28 01:00:00", 
"1981-03-29 01:00:00", "1981-09-27 01:00:00", "1982-03-28 01:00:00", 
"1982-09-26 01:00:00", "1983-03-27 01:00:00", "1983-09-25 01:00:00", 
"1984-03-25 01:00:00", "1984-09-30 01:00:00", "1985-03-31 01:00:00", 
"1985-09-29 01:00:00", "1986-03-30 01:00:00", "1986-09-28 01:00:00", 
"1987-03-29 01:00:00", "1987-09-27 01:00:00", "1988-03-27 01:00:00", 
"1988-09-25 01:00:00", "1989-03-26 01:00:00", "1989-09-24 01:00:00", 
"1990-03-25 01:00:00", "1990-09-30 01:00:00", "1991-03-31 01:00:00", 
"1991-09-29 01:00:00", "1992-03-29 01:00:00", "1992-09-27 01:00:00", 
"1993-03-28 01:00:00", "1993-09-26 01:00:00", "1994-03-27 01:00:00", 
"1994-09-25 01:00:00", "1995-03-26 01:00:00", "1995-09-24 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00"), class = "factor"), offSet = c(7200, 3600, 
3600, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600)), .Names = c("Oslo", "offSet"), row.names = c("1", 
"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
"14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
"25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", 
"36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", 
"47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", 
"58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", 
"69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", 
"80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", 
"91", "92", "93", "94", "95", "96", "97", "98", "99", "100", 
"101", "102", "103", "104", "105", "106", "107", "108", "109", 
"110", "111", "112", "113", "114", "115", "116", "117", "118", 
"119", "120", "121", "122", "123", "124", "125", "126", "127"
), class = "data.frame") }


"Paris" = 
function() {
structure(list(Paris = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
55, 56, 57, 58, 59, NA, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 
140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 
153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 
166, 167, 168, 169)), .Label = c("1911-03-10 23:51:39", "1916-06-14 23:00:00", 
"1916-10-01 23:00:00", "1917-03-24 23:00:00", "1917-10-07 23:00:00", 
"1918-03-09 23:00:00", "1918-10-06 23:00:00", "1919-03-01 23:00:00", 
"1919-10-05 23:00:00", "1920-02-14 23:00:00", "1920-10-23 23:00:00", 
"1921-03-14 23:00:00", "1921-10-25 23:00:00", "1922-03-25 23:00:00", 
"1922-10-07 23:00:00", "1923-05-26 23:00:00", "1923-10-06 23:00:00", 
"1924-03-29 23:00:00", "1924-10-04 23:00:00", "1925-04-04 23:00:00", 
"1925-10-03 23:00:00", "1926-04-17 23:00:00", "1926-10-02 23:00:00", 
"1927-04-09 23:00:00", "1927-10-01 23:00:00", "1928-04-14 23:00:00", 
"1928-10-06 23:00:00", "1929-04-20 23:00:00", "1929-10-05 23:00:00", 
"1930-04-12 23:00:00", "1930-10-04 23:00:00", "1931-04-18 23:00:00", 
"1931-10-03 23:00:00", "1932-04-02 23:00:00", "1932-10-01 23:00:00", 
"1933-03-25 23:00:00", "1933-10-07 23:00:00", "1934-04-07 23:00:00", 
"1934-10-06 23:00:00", "1935-03-30 23:00:00", "1935-10-05 23:00:00", 
"1936-04-18 23:00:00", "1936-10-03 23:00:00", "1937-04-03 23:00:00", 
"1937-10-02 23:00:00", "1938-03-26 23:00:00", "1938-10-01 23:00:00", 
"1939-04-15 23:00:00", "1939-11-18 23:00:00", "1940-02-25 02:00:00", 
"1940-06-14 22:00:00", "1942-11-02 01:00:00", "1943-03-29 01:00:00", 
"1943-10-04 01:00:00", "1944-04-03 01:00:00", "1944-08-24 22:00:00", 
"1944-10-08 01:00:00", "1945-04-02 01:00:00", "1945-09-16 01:00:00", 
"1976-09-25 23:00:00", "1976-12-31 23:00:00", "1977-04-03 01:00:00", 
"1977-09-25 01:00:00", "1978-04-02 01:00:00", "1978-10-01 01:00:00", 
"1979-04-01 01:00:00", "1979-09-30 01:00:00", "1980-04-06 01:00:00", 
"1980-09-28 01:00:00", "1981-03-29 01:00:00", "1981-09-27 01:00:00", 
"1982-03-28 01:00:00", "1982-09-26 01:00:00", "1983-03-27 01:00:00", 
"1983-09-25 01:00:00", "1984-03-25 01:00:00", "1984-09-30 01:00:00", 
"1985-03-31 01:00:00", "1985-09-29 01:00:00", "1986-03-30 01:00:00", 
"1986-09-28 01:00:00", "1987-03-29 01:00:00", "1987-09-27 01:00:00", 
"1988-03-27 01:00:00", "1988-09-25 01:00:00", "1989-03-26 01:00:00", 
"1989-09-24 01:00:00", "1990-03-25 01:00:00", "1990-09-30 01:00:00", 
"1991-03-31 01:00:00", "1991-09-29 01:00:00", "1992-03-29 01:00:00", 
"1992-09-27 01:00:00", "1993-03-28 01:00:00", "1993-09-26 01:00:00", 
"1994-03-27 01:00:00", "1994-09-25 01:00:00", "1995-03-26 01:00:00", 
"1995-09-24 01:00:00", "1996-03-31 01:00:00", "1996-10-27 01:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00"), class = "factor"), 
offSet = c(0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 
3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 0, 3600, 
3600, 3600, 7200, 3600, 7200, 0, 3600, 7200, 3600, 7200, 
3600, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600
)), .Names = c("Paris", "offSet"), row.names = c("1", "2", 
"3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", 
"15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", 
"26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", 
"37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", 
"48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", 
"59", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", 
"70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "80", 
"81", "82", "83", "84", "85", "86", "87", "88", "89", "90", "91", 
"92", "93", "94", "95", "96", "97", "98", "99", "100", "101", 
"102", "103", "104", "105", "106", "107", "108", "109", "110", 
"111", "112", "113", "114", "115", "116", "117", "118", "119", 
"120", "121", "122", "123", "124", "125", "126", "127", "128", 
"129", "130", "131", "132", "133", "134", "135", "136", "137", 
"138", "139", "140", "141", "142", "143", "144", "145", "146", 
"147", "148", "149", "150", "151", "152", "153", "154", "155", 
"156", "157", "158", "159", "160", "161", "162", "163", "164", 
"165", "166", "167", "168", "169", "170"), class = "data.frame") }


"Prague" = 
function() {
structure(list(Prague = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 
71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
128)), .Label = c("1891-09-30 23:02:16", "1916-04-30 22:00:00", 
"1916-09-30 23:00:00", "1917-04-16 01:00:00", "1917-09-17 01:00:00", 
"1918-04-15 01:00:00", "1918-09-16 01:00:00", "1940-04-01 01:00:00", 
"1942-11-02 01:00:00", "1943-03-29 01:00:00", "1943-10-04 01:00:00", 
"1944-04-03 01:00:00", "1944-09-17 01:00:00", "1945-04-08 01:00:00", 
"1945-11-18 01:00:00", "1946-05-06 01:00:00", "1946-10-06 01:00:00", 
"1947-04-20 01:00:00", "1947-10-05 01:00:00", "1948-04-18 01:00:00", 
"1948-10-03 01:00:00", "1949-04-09 01:00:00", "1949-10-02 01:00:00", 
"1978-12-31 23:00:00", "1979-04-01 01:00:00", "1979-09-30 01:00:00", 
"1980-04-06 01:00:00", "1980-09-28 01:00:00", "1981-03-29 01:00:00", 
"1981-09-27 01:00:00", "1982-03-28 01:00:00", "1982-09-26 01:00:00", 
"1983-03-27 01:00:00", "1983-09-25 01:00:00", "1984-03-25 01:00:00", 
"1984-09-30 01:00:00", "1985-03-31 01:00:00", "1985-09-29 01:00:00", 
"1986-03-30 01:00:00", "1986-09-28 01:00:00", "1987-03-29 01:00:00", 
"1987-09-27 01:00:00", "1988-03-27 01:00:00", "1988-09-25 01:00:00", 
"1989-03-26 01:00:00", "1989-09-24 01:00:00", "1990-03-25 01:00:00", 
"1990-09-30 01:00:00", "1991-03-31 01:00:00", "1991-09-29 01:00:00", 
"1992-03-29 01:00:00", "1992-09-27 01:00:00", "1993-03-28 01:00:00", 
"1993-09-26 01:00:00", "1994-03-27 01:00:00", "1994-09-25 01:00:00", 
"1995-03-26 01:00:00", "1995-09-24 01:00:00", "1996-03-31 01:00:00", 
"1996-10-27 01:00:00", "1997-03-30 01:00:00", "1997-10-26 01:00:00", 
"1998-03-29 01:00:00", "1998-10-25 01:00:00", "1999-03-28 01:00:00", 
"1999-10-31 01:00:00", "2000-03-26 01:00:00", "2000-10-29 01:00:00", 
"2001-03-25 01:00:00", "2001-10-28 01:00:00", "2002-03-31 01:00:00", 
"2002-10-27 01:00:00", "2003-03-30 01:00:00", "2003-10-26 01:00:00", 
"2004-03-28 01:00:00", "2004-10-31 01:00:00", "2005-03-27 01:00:00", 
"2005-10-30 01:00:00", "2006-03-26 01:00:00", "2006-10-29 01:00:00", 
"2007-03-25 01:00:00", "2007-10-28 01:00:00", "2008-03-30 01:00:00", 
"2008-10-26 01:00:00", "2009-03-29 01:00:00", "2009-10-25 01:00:00", 
"2010-03-28 01:00:00", "2010-10-31 01:00:00", "2011-03-27 01:00:00", 
"2011-10-30 01:00:00", "2012-03-25 01:00:00", "2012-10-28 01:00:00", 
"2013-03-31 01:00:00", "2013-10-27 01:00:00", "2014-03-30 01:00:00", 
"2014-10-26 01:00:00", "2015-03-29 01:00:00", "2015-10-25 01:00:00", 
"2016-03-27 01:00:00", "2016-10-30 01:00:00", "2017-03-26 01:00:00", 
"2017-10-29 01:00:00", "2018-03-25 01:00:00", "2018-10-28 01:00:00", 
"2019-03-31 01:00:00", "2019-10-27 01:00:00", "2020-03-29 01:00:00", 
"2020-10-25 01:00:00", "2021-03-28 01:00:00", "2021-10-31 01:00:00", 
"2022-03-27 01:00:00", "2022-10-30 01:00:00", "2023-03-26 01:00:00", 
"2023-10-29 01:00:00", "2024-03-31 01:00:00", "2024-10-27 01:00:00", 
"2025-03-30 01:00:00", "2025-10-26 01:00:00", "2026-03-29 01:00:00", 
"2026-10-25 01:00:00", "2027-03-28 01:00:00", "2027-10-31 01:00:00", 
"2028-03-26 01:00:00", "2028-10-29 01:00:00", "2029-03-25 01:00:00", 
"2029-10-28 01:00:00", "2030-03-31 01:00:00", "2030-10-27 01:00:00"
), class = "factor"), offSet = c(3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600)), .Names = c("Prague", "offSet"), row.names = c("1", 
"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
"14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
"25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", 
"36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", 
"47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", 
"58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", 
"69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", 
"80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", 
"91", "92", "93", "94", "95", "96", "97", "98", "99", "100", 
"101", "102", "103", "104", "105", "106", "107", "108", "109", 
"110", "111", "112", "113", "114", "115", "116", "117", "118", 
"119", "120", "121", "122", "123", "124", "125", "126", "127", 
"128"), class = "data.frame") }


"Riga" = 
function() {
structure(list(Riga = structure(as.integer(c(1, 2, 3, 4, 5, 6, 
7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
23, 24, 25, 26, 27, 28, 29, 30, NA, NA, NA, NA, NA, NA, NA, NA, 
NA, NA, NA, NA, NA, NA, NA, 31, 32, 33, 34, 35, 36, 37, 38, 39, 
40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 
56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 
72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 
88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99)), 
.Label = c("1918-04-15 00:23:36", 
"1918-09-16 00:23:36", "1919-04-01 00:23:36", "1919-05-22 00:23:36", 
"1926-05-10 22:23:36", "1940-08-04 22:00:00", "1941-06-30 21:00:00", 
"1942-11-02 01:00:00", "1943-03-29 01:00:00", "1943-10-04 01:00:00", 
"1944-04-03 01:00:00", "1944-10-02 01:00:00", "1944-10-12 23:00:00", 
"1981-03-31 21:00:00", "1981-09-30 20:00:00", "1982-03-31 21:00:00", 
"1982-09-30 20:00:00", "1983-03-31 21:00:00", "1983-09-30 20:00:00", 
"1984-03-31 21:00:00", "1984-09-29 23:00:00", "1985-03-30 23:00:00", 
"1985-09-28 23:00:00", "1986-03-29 23:00:00", "1986-09-27 23:00:00", 
"1987-03-28 23:00:00", "1987-09-26 23:00:00", "1988-03-26 23:00:00", 
"1988-09-24 23:00:00", "1989-03-25 23:00:00", "1997-01-20 22:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-02-28 22:00:00", "2000-12-31 22:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00"), class = "factor"), 
offSet = c(851040, 491040, 851040, 491040, 7200, 10800, 3600, 
3600, 7200, 3600, 7200, 3600, 10800, 14400, 10800, 14400, 
10800, 14400, 10800, 14400, 10800, 14400, 10800, 14400, 10800, 
14400, 10800, 14400, 10800, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
7200, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200)), .Names = c("Riga", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", 
"9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
"20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", 
"31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", 
"42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", 
"53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", 
"64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", 
"75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", 
"86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", 
"97", "98", "99", "100", "101", "102", "103", "104", "105", "106", 
"107", "108", "109", "110", "111", "112", "113", "114"), 
class = "data.frame") }


"Rome" = 
function() {
structure(list(Rome = structure(as.integer(c(1, 2, 3, 4, 5, 6, 
7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 
71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
154, 155, 156, 157)), .Label = c("1893-10-31 23:10:04", 
"1916-06-02 23:00:00", 
"1916-09-30 23:00:00", "1917-03-31 23:00:00", "1917-09-29 23:00:00", 
"1918-03-09 23:00:00", "1918-10-05 23:00:00", "1919-03-01 23:00:00", 
"1919-10-04 23:00:00", "1920-03-20 23:00:00", "1920-09-18 23:00:00", 
"1940-06-14 23:00:00", "1942-11-02 01:00:00", "1943-03-29 01:00:00", 
"1943-10-04 01:00:00", "1944-04-03 01:00:00", "1944-06-30 22:00:00", 
"1944-09-16 23:00:00", "1945-04-02 01:00:00", "1945-09-14 23:00:00", 
"1946-03-17 01:00:00", "1946-10-06 01:00:00", "1947-03-15 23:00:00", 
"1947-10-04 23:00:00", "1948-02-29 01:00:00", "1948-10-03 01:00:00", 
"1966-05-21 23:00:00", "1966-09-24 22:00:00", "1967-05-27 23:00:00", 
"1967-09-23 22:00:00", "1968-05-25 23:00:00", "1968-09-21 22:00:00", 
"1969-05-31 23:00:00", "1969-09-27 22:00:00", "1970-05-30 23:00:00", 
"1970-09-26 22:00:00", "1971-05-22 23:00:00", "1971-09-25 23:00:00", 
"1972-05-27 23:00:00", "1972-09-30 22:00:00", "1973-06-02 23:00:00", 
"1973-09-29 22:00:00", "1974-05-25 23:00:00", "1974-09-28 22:00:00", 
"1975-05-31 23:00:00", "1975-09-27 23:00:00", "1976-05-29 23:00:00", 
"1976-09-25 23:00:00", "1977-05-21 23:00:00", "1977-09-24 23:00:00", 
"1978-05-27 23:00:00", "1978-09-30 23:00:00", "1979-05-26 23:00:00", 
"1979-09-29 23:00:00", "1979-12-31 23:00:00", "1980-04-06 01:00:00", 
"1980-09-28 01:00:00", "1981-03-29 01:00:00", "1981-09-27 01:00:00", 
"1982-03-28 01:00:00", "1982-09-26 01:00:00", "1983-03-27 01:00:00", 
"1983-09-25 01:00:00", "1984-03-25 01:00:00", "1984-09-30 01:00:00", 
"1985-03-31 01:00:00", "1985-09-29 01:00:00", "1986-03-30 01:00:00", 
"1986-09-28 01:00:00", "1987-03-29 01:00:00", "1987-09-27 01:00:00", 
"1988-03-27 01:00:00", "1988-09-25 01:00:00", "1989-03-26 01:00:00", 
"1989-09-24 01:00:00", "1990-03-25 01:00:00", "1990-09-30 01:00:00", 
"1991-03-31 01:00:00", "1991-09-29 01:00:00", "1992-03-29 01:00:00", 
"1992-09-27 01:00:00", "1993-03-28 01:00:00", "1993-09-26 01:00:00", 
"1994-03-27 01:00:00", "1994-09-25 01:00:00", "1995-03-26 01:00:00", 
"1995-09-24 01:00:00", "1996-03-31 01:00:00", "1996-10-27 01:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00"), class = "factor"), 
offSet = c(3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600)), .Names = c("Rome", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", 
"9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
"20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", 
"31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", 
"42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", 
"53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", 
"64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", 
"75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", 
"86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", 
"97", "98", "99", "100", "101", "102", "103", "104", "105", "106", 
"107", "108", "109", "110", "111", "112", "113", "114", "115", 
"116", "117", "118", "119", "120", "121", "122", "123", "124", 
"125", "126", "127", "128", "129", "130", "131", "132", "133", 
"134", "135", "136", "137", "138", "139", "140", "141", "142", 
"143", "144", "145", "146", "147", "148", "149", "150", "151", 
"152", "153", "154", "155", "156", "157"), class = "data.frame") }


"Sofia" = 
function() {
structure(list(Sofia = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13, 14, NA, NA, NA, NA, NA, NA, NA, NA, 
NA, NA, NA, NA, NA, NA, NA, NA, NA, 15, 16, 17, 18, 19, 20, 21, 
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 
38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 
54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96)), 
.Label = c("1894-11-29 22:03:04", 
"1942-11-02 01:00:00", "1943-03-29 01:00:00", "1943-10-04 01:00:00", 
"1944-04-03 01:00:00", "1944-10-02 01:00:00", "1945-04-02 02:00:00", 
"1979-03-31 21:00:00", "1979-09-30 22:00:00", "1980-04-05 21:00:00", 
"1980-09-28 22:00:00", "1981-04-04 21:00:00", "1981-09-26 23:00:00", 
"1982-04-03 21:00:00", "1990-12-31 22:00:00", "1991-03-30 22:00:00", 
"1991-09-28 21:00:00", "1992-03-28 22:00:00", "1992-09-26 21:00:00", 
"1993-03-27 22:00:00", "1993-09-25 21:00:00", "1994-03-26 22:00:00", 
"1994-09-24 21:00:00", "1995-03-25 22:00:00", "1995-09-23 21:00:00", 
"1996-03-30 22:00:00", "1996-10-26 21:00:00", "1996-12-31 22:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00"), class = "factor"), 
offSet = c(7200, 3600, 7200, 3600, 7200, 3600, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200)), .Names = c("Sofia", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", 
"9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
"20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", 
"31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", 
"42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", 
"53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", 
"64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", 
"75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", 
"86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", 
"97", "98", "99", "100", "101", "102", "103", "104", "105", "106", 
"107", "108", "109", "110", "111", "112", "113"), class = "data.frame") }


"Stockholm" = 
function() {
structure(list(Stockholm = structure(as.integer(c(1, 2, 3, 4, 
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 
38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 
54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
101, 102, 103, 104, 105, 106)), .Label = c("1899-12-31 22:59:46", 
"1916-05-14 22:00:00", "1916-09-30 23:00:00", "1979-12-31 23:00:00", 
"1980-04-06 01:00:00", "1980-09-28 01:00:00", "1981-03-29 01:00:00", 
"1981-09-27 01:00:00", "1982-03-28 01:00:00", "1982-09-26 01:00:00", 
"1983-03-27 01:00:00", "1983-09-25 01:00:00", "1984-03-25 01:00:00", 
"1984-09-30 01:00:00", "1985-03-31 01:00:00", "1985-09-29 01:00:00", 
"1986-03-30 01:00:00", "1986-09-28 01:00:00", "1987-03-29 01:00:00", 
"1987-09-27 01:00:00", "1988-03-27 01:00:00", "1988-09-25 01:00:00", 
"1989-03-26 01:00:00", "1989-09-24 01:00:00", "1990-03-25 01:00:00", 
"1990-09-30 01:00:00", "1991-03-31 01:00:00", "1991-09-29 01:00:00", 
"1992-03-29 01:00:00", "1992-09-27 01:00:00", "1993-03-28 01:00:00", 
"1993-09-26 01:00:00", "1994-03-27 01:00:00", "1994-09-25 01:00:00", 
"1995-03-26 01:00:00", "1995-09-24 01:00:00", "1996-03-31 01:00:00", 
"1996-10-27 01:00:00", "1997-03-30 01:00:00", "1997-10-26 01:00:00", 
"1998-03-29 01:00:00", "1998-10-25 01:00:00", "1999-03-28 01:00:00", 
"1999-10-31 01:00:00", "2000-03-26 01:00:00", "2000-10-29 01:00:00", 
"2001-03-25 01:00:00", "2001-10-28 01:00:00", "2002-03-31 01:00:00", 
"2002-10-27 01:00:00", "2003-03-30 01:00:00", "2003-10-26 01:00:00", 
"2004-03-28 01:00:00", "2004-10-31 01:00:00", "2005-03-27 01:00:00", 
"2005-10-30 01:00:00", "2006-03-26 01:00:00", "2006-10-29 01:00:00", 
"2007-03-25 01:00:00", "2007-10-28 01:00:00", "2008-03-30 01:00:00", 
"2008-10-26 01:00:00", "2009-03-29 01:00:00", "2009-10-25 01:00:00", 
"2010-03-28 01:00:00", "2010-10-31 01:00:00", "2011-03-27 01:00:00", 
"2011-10-30 01:00:00", "2012-03-25 01:00:00", "2012-10-28 01:00:00", 
"2013-03-31 01:00:00", "2013-10-27 01:00:00", "2014-03-30 01:00:00", 
"2014-10-26 01:00:00", "2015-03-29 01:00:00", "2015-10-25 01:00:00", 
"2016-03-27 01:00:00", "2016-10-30 01:00:00", "2017-03-26 01:00:00", 
"2017-10-29 01:00:00", "2018-03-25 01:00:00", "2018-10-28 01:00:00", 
"2019-03-31 01:00:00", "2019-10-27 01:00:00", "2020-03-29 01:00:00", 
"2020-10-25 01:00:00", "2021-03-28 01:00:00", "2021-10-31 01:00:00", 
"2022-03-27 01:00:00", "2022-10-30 01:00:00", "2023-03-26 01:00:00", 
"2023-10-29 01:00:00", "2024-03-31 01:00:00", "2024-10-27 01:00:00", 
"2025-03-30 01:00:00", "2025-10-26 01:00:00", "2026-03-29 01:00:00", 
"2026-10-25 01:00:00", "2027-03-28 01:00:00", "2027-10-31 01:00:00", 
"2028-03-26 01:00:00", "2028-10-29 01:00:00", "2029-03-25 01:00:00", 
"2029-10-28 01:00:00", "2030-03-31 01:00:00", "2030-10-27 01:00:00"
), class = "factor"), offSet = c(3600, 7200, 3600, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600)), .Names = c("Stockholm", "offSet"), row.names = c("1", 
"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
"14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
"25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", 
"36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", 
"47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", 
"58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", 
"69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", 
"80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", 
"91", "92", "93", "94", "95", "96", "97", "98", "99", "100", 
"101", "102", "103", "104", "105", "106"), class = "data.frame") }


"Tallinn" = 
function() {
structure(list(Tallinn = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
23, 24, 25, 26, 27, 28, 29, NA, NA, NA, NA, NA, NA, NA, NA, NA, 
NA, NA, NA, NA, NA, NA, NA, NA, NA, 30, 31, 32, 33, 34)), 
.Label = c("1918-01-31 22:21:00", 
"1918-04-15 01:00:00", "1918-09-16 01:00:00", "1919-06-30 23:00:00", 
"1921-04-30 22:21:00", "1940-08-05 22:00:00", "1941-09-14 21:00:00", 
"1942-11-02 01:00:00", "1943-03-29 01:00:00", "1943-10-04 01:00:00", 
"1944-04-03 01:00:00", "1944-09-21 22:00:00", "1981-03-31 21:00:00", 
"1981-09-30 20:00:00", "1982-03-31 21:00:00", "1982-09-30 20:00:00", 
"1983-03-31 21:00:00", "1983-09-30 20:00:00", "1984-03-31 21:00:00", 
"1984-09-29 23:00:00", "1985-03-30 23:00:00", "1985-09-28 23:00:00", 
"1986-03-29 23:00:00", "1986-09-27 23:00:00", "1987-03-28 23:00:00", 
"1987-09-26 23:00:00", "1988-03-26 23:00:00", "1988-09-24 23:00:00", 
"1989-03-25 23:00:00", "1998-09-21 21:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "1999-10-31 22:00:00"
), class = "factor"), offSet = c(3600, 7200, 3600, 5940, 7200, 
10800, 3600, 3600, 7200, 3600, 7200, 10800, 14400, 10800, 14400, 
10800, 14400, 10800, 14400, 10800, 14400, 10800, 14400, 10800, 
14400, 10800, 14400, 10800, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 
7200, 10800, 7200, 10800, 7200, 7200, 10800, 7200, 7200)), .Names = c("Tallinn", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", 
"9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
"20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", 
"31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", 
"42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52"
), class = "data.frame") }


"Vaduz" = 
function() {
structure(list(Vaduz = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 
71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101)), 
.Label = c("1980-12-31 23:00:00", 
"1981-03-29 01:00:00", "1981-09-27 01:00:00", "1982-03-28 01:00:00", 
"1982-09-26 01:00:00", "1983-03-27 01:00:00", "1983-09-25 01:00:00", 
"1984-03-25 01:00:00", "1984-09-30 01:00:00", "1985-03-31 01:00:00", 
"1985-09-29 01:00:00", "1986-03-30 01:00:00", "1986-09-28 01:00:00", 
"1987-03-29 01:00:00", "1987-09-27 01:00:00", "1988-03-27 01:00:00", 
"1988-09-25 01:00:00", "1989-03-26 01:00:00", "1989-09-24 01:00:00", 
"1990-03-25 01:00:00", "1990-09-30 01:00:00", "1991-03-31 01:00:00", 
"1991-09-29 01:00:00", "1992-03-29 01:00:00", "1992-09-27 01:00:00", 
"1993-03-28 01:00:00", "1993-09-26 01:00:00", "1994-03-27 01:00:00", 
"1994-09-25 01:00:00", "1995-03-26 01:00:00", "1995-09-24 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00"), class = "factor"), offSet = c(3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600
)), .Names = c("Vaduz", "offSet"), row.names = c("1", "2", "3", 
"4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", 
"16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", 
"27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", 
"38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", 
"49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", 
"60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "70", 
"71", "72", "73", "74", "75", "76", "77", "78", "79", "80", "81", 
"82", "83", "84", "85", "86", "87", "88", "89", "90", "91", "92", 
"93", "94", "95", "96", "97", "98", "99", "100", "101"), 
class = "data.frame") }


"Vienna" = 
function() {
structure(list(Vienna = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 
71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
115, 116, 117, 118, 119, 120, 121, 122, 123)), 
.Label = c("1916-04-30 22:00:00", 
"1916-09-30 23:00:00", "1917-04-16 01:00:00", "1917-09-17 01:00:00", 
"1918-04-15 01:00:00", "1918-06-16 01:00:00", "1920-04-05 01:00:00", 
"1920-09-13 01:00:00", "1940-04-01 01:00:00", "1942-11-02 01:00:00", 
"1943-03-29 01:00:00", "1943-10-04 01:00:00", "1944-04-03 01:00:00", 
"1944-10-02 01:00:00", "1945-04-02 01:00:00", "1945-11-18 01:00:00", 
"1946-04-14 01:00:00", "1946-10-06 01:00:00", "1947-04-06 01:00:00", 
"1947-10-05 01:00:00", "1948-04-18 01:00:00", "1948-10-03 01:00:00", 
"1980-12-31 23:00:00", "1981-03-29 01:00:00", "1981-09-27 01:00:00", 
"1982-03-28 01:00:00", "1982-09-26 01:00:00", "1983-03-27 01:00:00", 
"1983-09-25 01:00:00", "1984-03-25 01:00:00", "1984-09-30 01:00:00", 
"1985-03-31 01:00:00", "1985-09-29 01:00:00", "1986-03-30 01:00:00", 
"1986-09-28 01:00:00", "1987-03-29 01:00:00", "1987-09-27 01:00:00", 
"1988-03-27 01:00:00", "1988-09-25 01:00:00", "1989-03-26 01:00:00", 
"1989-09-24 01:00:00", "1990-03-25 01:00:00", "1990-09-30 01:00:00", 
"1991-03-31 01:00:00", "1991-09-29 01:00:00", "1992-03-29 01:00:00", 
"1992-09-27 01:00:00", "1993-03-28 01:00:00", "1993-09-26 01:00:00", 
"1994-03-27 01:00:00", "1994-09-25 01:00:00", "1995-03-26 01:00:00", 
"1995-09-24 01:00:00", "1996-03-31 01:00:00", "1996-10-27 01:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00"), class = "factor"), 
offSet = c(7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600)), .Names = c("Vienna", "offSet"
), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", "9", 
"10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", 
"21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", 
"32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", 
"43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", 
"54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", 
"65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", 
"76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", 
"87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", 
"98", "99", "100", "101", "102", "103", "104", "105", "106", 
"107", "108", "109", "110", "111", "112", "113", "114", "115", 
"116", "117", "118", "119", "120", "121", "122", "123"), 
class = "data.frame") }


"Vilnius" = 
function() {
structure(list(Vilnius = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
23, 24, 25, 26, 27, 28, 29, 30, 31, 32, NA, NA, NA, NA, NA, NA, 
NA, NA, NA, NA, NA, NA, NA, 33, 34, 35, 36, 37)), 
.Label = c("1916-12-31 22:36:00", 
"1919-10-09 22:24:24", "1920-07-11 23:00:00", "1920-10-08 22:00:00", 
"1940-08-02 23:00:00", "1941-06-23 21:00:00", "1942-11-02 01:00:00", 
"1943-03-29 01:00:00", "1943-10-04 01:00:00", "1944-04-03 01:00:00", 
"1944-07-31 22:00:00", "1981-03-31 21:00:00", "1981-09-30 20:00:00", 
"1982-03-31 21:00:00", "1982-09-30 20:00:00", "1983-03-31 21:00:00", 
"1983-09-30 20:00:00", "1984-03-31 21:00:00", "1984-09-29 23:00:00", 
"1985-03-30 23:00:00", "1985-09-28 23:00:00", "1986-03-29 23:00:00", 
"1986-09-27 23:00:00", "1987-03-28 23:00:00", "1987-09-26 23:00:00", 
"1988-03-26 23:00:00", "1988-09-24 23:00:00", "1989-03-25 23:00:00", 
"1989-09-23 23:00:00", "1990-03-24 23:00:00", "1990-09-29 23:00:00", 
"1991-03-30 23:00:00", "1997-12-31 22:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00"
), class = "factor"), offSet = c(488160, 3600, 7200, 3600, 10800, 
3600, 3600, 7200, 3600, 7200, 10800, 14400, 10800, 14400, 10800, 
14400, 10800, 14400, 10800, 14400, 10800, 14400, 10800, 14400, 
10800, 14400, 10800, 14400, 10800, 14400, 10800, 10800, 7200, 
10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 10800, 7200, 
10800, 7200, 7200, 3600, 3600, 7200, 7200)), .Names = c("Vilnius", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6", "7", "8", 
"9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
"20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", 
"31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", 
"42", "43", "44", "45", "46", "47", "48", "49", "50"), class = "data.frame") }


"Warsaw" = 
function() {
structure(list(Warsaw = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, NA, NA, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
21, 22, 23, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 
NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 
NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 
NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 24, 
25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 
41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 
57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 
73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88
)), .Label = c("1915-08-04 22:36:00", "1916-04-30 22:00:00", 
"1916-09-30 23:00:00", "1917-04-16 01:00:00", "1917-09-17 01:00:00", 
"1918-04-15 01:00:00", "1918-09-16 01:00:00", "1922-05-31 22:00:00", 
"1940-06-23 01:00:00", "1942-11-02 01:00:00", "1943-03-29 01:00:00", 
"1943-10-04 01:00:00", "1944-04-03 01:00:00", "1944-09-30 22:00:00", 
"1944-10-04 01:00:00", "1945-04-28 23:00:00", "1945-10-31 22:00:00", 
"1946-04-13 23:00:00", "1946-09-06 22:00:00", "1947-05-03 23:00:00", 
"1947-10-04 22:00:00", "1948-04-17 23:00:00", "1948-10-02 22:00:00", 
"1998-12-31 23:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00"), class = "factor"), 
offSet = c(3600, 7200, 3600, 7200, 3600, 7200, 7200, 10800, 
7200, 3600, 3600, 3600, 7200, 3600, 7200, 3600, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600)), .Names = c("Warsaw", "offSet"), row.names = c("1", 
"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
"14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
"25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", 
"36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", 
"47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", 
"58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", 
"69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", 
"80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", 
"91", "92", "93", "94", "95", "96", "97", "98", "99", "100", 
"101", "102", "103", "104", "105", "106", "107", "108", "109", 
"110", "111", "112", "113", "114", "115", "116", "117", "118", 
"119", "120", "121", "122", "123", "124", "125", "126", "127", 
"128", "129", "130", "131", "132", "133", "134", "135", "136", 
"137", "138", "139", "140", "141", "142", "143", "144", "145", 
"146", "147", "148", "149", "150"), class = "data.frame") }


"Zagreb" = 
function() {
structure(list(Zagreb = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 
71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
102, 103, 104, 105)), .Label = c("1941-04-18 22:00:00", "1942-11-02 01:00:00", 
"1943-03-29 01:00:00", "1943-10-04 01:00:00", "1944-04-03 01:00:00", 
"1944-10-02 01:00:00", "1945-05-08 01:00:00", "1945-09-16 01:00:00", 
"1982-11-26 23:00:00", "1983-03-27 01:00:00", "1983-09-25 01:00:00", 
"1984-03-25 01:00:00", "1984-09-30 01:00:00", "1985-03-31 01:00:00", 
"1985-09-29 01:00:00", "1986-03-30 01:00:00", "1986-09-28 01:00:00", 
"1987-03-29 01:00:00", "1987-09-27 01:00:00", "1988-03-27 01:00:00", 
"1988-09-25 01:00:00", "1989-03-26 01:00:00", "1989-09-24 01:00:00", 
"1990-03-25 01:00:00", "1990-09-30 01:00:00", "1991-03-31 01:00:00", 
"1991-09-29 01:00:00", "1992-03-29 01:00:00", "1992-09-27 01:00:00", 
"1993-03-28 01:00:00", "1993-09-26 01:00:00", "1994-03-27 01:00:00", 
"1994-09-25 01:00:00", "1995-03-26 01:00:00", "1995-09-24 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00"), class = "factor"), offSet = c(3600, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 
3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600)), .Names = c("Zagreb", "offSet"), row.names = c("1", 
"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
"14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
"25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", 
"36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", 
"47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", 
"58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", 
"69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", 
"80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", 
"91", "92", "93", "94", "95", "96", "97", "98", "99", "100", 
"101", "102", "103", "104", "105"), class = "data.frame") }


"Zurich" = 
function() {
structure(list(Zurich = structure(as.integer(c(1, 2, 3, 4, 5, 
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 
71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
102, 103, 104, 105, 106, 107, 108)), .Label = c("1894-05-31 23:30:16", 
"1940-11-01 23:00:00", "1940-12-30 22:00:00", "1941-05-04 01:00:00", 
"1941-10-04 22:00:00", "1942-05-03 01:00:00", "1942-10-03 22:00:00", 
"1980-12-31 23:00:00", "1981-03-29 01:00:00", "1981-09-27 01:00:00", 
"1982-03-28 01:00:00", "1982-09-26 01:00:00", "1983-03-27 01:00:00", 
"1983-09-25 01:00:00", "1984-03-25 01:00:00", "1984-09-30 01:00:00", 
"1985-03-31 01:00:00", "1985-09-29 01:00:00", "1986-03-30 01:00:00", 
"1986-09-28 01:00:00", "1987-03-29 01:00:00", "1987-09-27 01:00:00", 
"1988-03-27 01:00:00", "1988-09-25 01:00:00", "1989-03-26 01:00:00", 
"1989-09-24 01:00:00", "1990-03-25 01:00:00", "1990-09-30 01:00:00", 
"1991-03-31 01:00:00", "1991-09-29 01:00:00", "1992-03-29 01:00:00", 
"1992-09-27 01:00:00", "1993-03-28 01:00:00", "1993-09-26 01:00:00", 
"1994-03-27 01:00:00", "1994-09-25 01:00:00", "1995-03-26 01:00:00", 
"1995-09-24 01:00:00", "1996-03-31 01:00:00", "1996-10-27 01:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00"), class = "factor"), 
offSet = c(3600, 7200, 3600, 7200, 3600, 7200, 3600, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 
7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600, 7200, 3600
)), .Names = c("Zurich", "offSet"), row.names = c("1", "2", 
"3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", 
"15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", 
"26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", 
"37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", 
"48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", 
"59", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", 
"70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "80", 
"81", "82", "83", "84", "85", "86", "87", "88", "89", "90", "91", 
"92", "93", "94", "95", "96", "97", "98", "99", "100", "101", 
"102", "103", "104", "105", "106", "107", "108"), class = "data.frame") }


# PACIFIC ----------------------------------------------------------------------


"Auckland" = 
function() {
structure(list(Auckland = structure(as.integer(c(1, 2, 3, 4, 
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 
38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 
54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 
140)), .Label = c("1927-11-25 14:30:00", "1928-03-03 14:00:00", 
"1928-11-03 14:30:00", "1929-03-02 14:00:00", "1929-10-29 14:30:00", 
"1930-03-15 14:00:00", "1930-10-11 14:30:00", "1931-03-14 14:00:00", 
"1931-10-10 14:30:00", "1932-03-19 14:00:00", "1932-10-08 14:30:00", 
"1933-03-18 14:00:00", "1933-10-07 14:30:00", "1934-04-28 14:00:00", 
"1934-09-29 14:30:00", "1935-04-27 14:00:00", "1935-09-28 14:30:00", 
"1936-04-25 14:00:00", "1936-09-26 14:30:00", "1937-04-24 14:00:00", 
"1937-09-25 14:30:00", "1938-04-23 14:00:00", "1938-09-24 14:30:00", 
"1939-04-29 14:00:00", "1939-09-23 14:30:00", "1940-04-27 14:00:00", 
"1940-09-28 14:30:00", "1974-11-02 14:00:00", "1975-02-22 14:00:00", 
"1975-10-25 14:00:00", "1976-03-06 14:00:00", "1976-10-30 14:00:00", 
"1977-03-05 14:00:00", "1977-10-29 14:00:00", "1978-03-04 14:00:00", 
"1978-10-28 14:00:00", "1979-03-03 14:00:00", "1979-10-27 14:00:00", 
"1980-03-01 14:00:00", "1980-10-25 14:00:00", "1981-02-28 14:00:00", 
"1981-10-24 14:00:00", "1982-03-06 14:00:00", "1982-10-30 14:00:00", 
"1983-03-05 14:00:00", "1983-10-29 14:00:00", "1984-03-03 14:00:00", 
"1984-10-27 14:00:00", "1985-03-02 14:00:00", "1985-10-26 14:00:00", 
"1986-03-01 14:00:00", "1986-10-25 14:00:00", "1987-02-28 14:00:00", 
"1987-10-24 14:00:00", "1988-03-05 14:00:00", "1988-10-29 14:00:00", 
"1989-03-04 14:00:00", "1989-10-07 14:00:00", "1990-03-17 14:00:00", 
"1990-10-06 14:00:00", "1991-03-16 14:00:00", "1991-10-05 14:00:00", 
"1992-03-14 14:00:00", "1992-10-03 14:00:00", "1993-03-20 14:00:00", 
"1993-10-02 14:00:00", "1994-03-19 14:00:00", "1994-10-01 14:00:00", 
"1995-03-18 14:00:00", "1995-09-30 14:00:00", "1996-03-16 14:00:00", 
"1996-10-05 14:00:00", "1997-03-15 14:00:00", "1997-10-04 14:00:00", 
"1998-03-14 14:00:00", "1998-10-03 14:00:00", "1999-03-20 14:00:00", 
"1999-10-02 14:00:00", "2000-03-18 14:00:00", "2000-09-30 14:00:00", 
"2001-03-17 14:00:00", "2001-10-06 14:00:00", "2002-03-16 14:00:00", 
"2002-10-05 14:00:00", "2003-03-15 14:00:00", "2003-10-04 14:00:00", 
"2004-03-20 14:00:00", "2004-10-02 14:00:00", "2005-03-19 14:00:00", 
"2005-10-01 14:00:00", "2006-03-18 14:00:00", "2006-09-30 14:00:00", 
"2007-03-17 14:00:00", "2007-10-06 14:00:00", "2008-03-15 14:00:00", 
"2008-10-04 14:00:00", "2009-03-14 14:00:00", "2009-10-03 14:00:00", 
"2010-03-20 14:00:00", "2010-10-02 14:00:00", "2011-03-19 14:00:00", 
"2011-10-01 14:00:00", "2012-03-17 14:00:00", "2012-10-06 14:00:00", 
"2013-03-16 14:00:00", "2013-10-05 14:00:00", "2014-03-15 14:00:00", 
"2014-10-04 14:00:00", "2015-03-14 14:00:00", "2015-10-03 14:00:00", 
"2016-03-19 14:00:00", "2016-10-01 14:00:00", "2017-03-18 14:00:00", 
"2017-09-30 14:00:00", "2018-03-17 14:00:00", "2018-10-06 14:00:00", 
"2019-03-16 14:00:00", "2019-10-05 14:00:00", "2020-03-14 14:00:00", 
"2020-10-03 14:00:00", "2021-03-20 14:00:00", "2021-10-02 14:00:00", 
"2022-03-19 14:00:00", "2022-10-01 14:00:00", "2023-03-18 14:00:00", 
"2023-09-30 14:00:00", "2024-03-16 14:00:00", "2024-10-05 14:00:00", 
"2025-03-15 14:00:00", "2025-10-04 14:00:00", "2026-03-14 14:00:00", 
"2026-10-03 14:00:00", "2027-03-20 14:00:00", "2027-10-02 14:00:00", 
"2028-03-18 14:00:00", "2028-09-30 14:00:00", "2029-03-17 14:00:00", 
"2029-10-06 14:00:00", "2030-03-16 14:00:00", "2030-10-05 14:00:00"
), class = "factor"), offSet = c(43200, 41400, 43200, 41400, 
43200, 41400, 43200, 41400, 43200, 41400, 43200, 41400, 43200, 
41400, 43200, 41400, 43200, 41400, 43200, 41400, 43200, 41400, 
43200, 41400, 43200, 41400, 43200, 46800, 43200, 46800, 43200, 
46800, 43200, 46800, 43200, 46800, 43200, 46800, 43200, 46800, 
43200, 46800, 43200, 46800, 43200, 46800, 43200, 46800, 43200, 
46800, 43200, 46800, 43200, 46800, 43200, 46800, 43200, 46800, 
43200, 46800, 43200, 46800, 43200, 46800, 43200, 46800, 43200, 
46800, 43200, 46800, 43200, 46800, 43200, 46800, 43200, 46800, 
43200, 46800, 43200, 46800, 43200, 46800, 43200, 46800, 43200, 
46800, 43200, 46800, 43200, 46800, 43200, 46800, 43200, 46800, 
43200, 46800, 43200, 46800, 43200, 46800, 43200, 46800, 43200, 
46800, 43200, 46800, 43200, 46800, 43200, 46800, 43200, 46800, 
43200, 46800, 43200, 46800, 43200, 46800, 43200, 46800, 43200, 
46800, 43200, 46800, 43200, 46800, 43200, 46800, 43200, 46800, 
43200, 46800, 43200, 46800, 43200, 46800, 43200, 46800, 43200, 
46800)), .Names = c("Auckland", "offSet"), row.names = c("1", 
"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
"14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
"25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", 
"36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", 
"47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", 
"58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", 
"69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", 
"80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", 
"91", "92", "93", "94", "95", "96", "97", "98", "99", "100", 
"101", "102", "103", "104", "105", "106", "107", "108", "109", 
"110", "111", "112", "113", "114", "115", "116", "117", "118", 
"119", "120", "121", "122", "123", "124", "125", "126", "127", 
"128", "129", "130", "131", "132", "133", "134", "135", "136", 
"137", "138", "139", "140"), class = "data.frame") }


"Honolulu" = 
function() {
structure(list(Honolulu = structure(as.integer(c(1, 2, 3, 4, 
5, 6)), .Label = c("1933-04-30 12:30:00", "1933-05-21 11:30:00", 
"1942-02-09 12:30:00", "1945-08-14 23:00:00", "1945-09-30 11:30:00", 
"1947-06-08 12:30:00"), class = "factor"), offSet = c(-34200, 
-37800, -34200, -34200, -37800, -36000)), .Names = c("Honolulu", 
"offSet"), row.names = c("1", "2", "3", "4", "5", "6"), class = "data.frame") }


################################################################################

